/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.dualselector.DualSelectorV2Interface;
import com.sas.swing.visuals.dualselector.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@SASScope(value="ALL")
public abstract class BaseDualSelector
extends JComponent
implements ActionListener,
Accessible {
    static final long serialVersionUID = 3422201980233088388L;
    protected boolean initialized;
    protected boolean targetControlsVisible;
    protected boolean transferAllControlsVisible;
    protected boolean alternatingSingleButtonStyle;
    protected boolean alternatingMultipleButtonStyle;
    protected boolean clearSelection;
    protected boolean copyModeEnabled;
    protected boolean copyModeDuplicatesAllowed;
    protected boolean dragAndDropEnabled;
    protected Component dragGestureInitiator;
    protected int targetMaximumCount;
    protected JPanel mainPanel;
    protected JPanel sourceContainer;
    protected JPanel targetContainer;
    protected JPanel buttonContainer;
    protected JPanel middleContainer;
    protected ProportionalSpacePartitioner partitioner;
    protected MouseListener sourceMouseListener;
    protected MouseListener targetMouseListener;
    protected JLabel sourceLabel;
    protected JLabel targetLabel;
    public JButton alternatingSingleButton;
    public static final String ALTERNATING_SINGLE_BUTTON = "alternatingSingleButton";
    public JButton leftButton;
    public JButton rightButton;
    public JButton alternatingMultipleButton;
    public static final String ALTERNATING_MULTIPLE_BUTTON = "alternatingMultipleButton";
    public JButton allRightButton;
    public JButton allLeftButton;
    public JButton targetDownButton;
    public JButton targetUpButton;
    protected DualSelectorInterface sourceAdapter;
    protected DualSelectorInterface targetAdapter;
    protected JPanel sourceTopButtonContainer;
    protected JPanel sourceBottomButtonContainer;
    protected List selectedItems;
    protected transient boolean direction;
    protected transient Icon leftArrow;
    protected transient Icon rightArrow;
    protected transient Icon doubleLeftArrow;
    protected transient Icon doubleRightArrow;
    protected static final boolean RIGHT = false;
    protected static final boolean LEFT = true;
    protected boolean designTime;
    private transient boolean defaultModelsSetCalled;
    private transient boolean linksSet;
    private transient Dimension preferredSize;
    private static Insets nullInsets = new Insets(0, 0, 0, 0);
    public static final int TOP_RIGHT = 6;
    public static final int MIDDLE_BOTTOM = 264;
    private static final String RIGHT_DIRECTION = "rightDirection";
    private static final String LEFT_DIRECTION = "leftDirection";
    private int targetButtonsLocation;
    private boolean grouping;
    private Map alternatingSingleButtonIcons;
    private Map alternatingMultipleButtonIcons;
    protected FocusListener sourceFocusListener;
    protected FocusListener targetFocusListener;
    public static final String RB_KEY = "BaseDualSelector.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Description", RB.getStringResource(RB_KEY, "list1Model.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}, {{"Name", "sourceItems"}, {"Description", RB.getStringResource(RB_KEY, "list1Items.pd.txt")}}, {{"Name", "sourceLabel"}, {"Description", RB.getStringResource(RB_KEY, "list1Label.pd.txt")}}, {{"Name", "targetControlsVisible"}, {"Description", RB.getStringResource(RB_KEY, "list2ControlsVisible.pd.txt")}}, {{"Name", "targetItems"}, {"Description", RB.getStringResource(RB_KEY, "list2Items.pd.txt")}}, {{"Name", "targetLabel"}, {"Description", RB.getStringResource(RB_KEY, "list2Label.pd.txt")}}, {{"Name", "targetMaximumCount"}, {"Description", RB.getStringResource(RB_KEY, "list2MaximumCount.pd.txt")}}, {{"Name", "targetModel"}, {"Description", RB.getStringResource(RB_KEY, "list2Model.pd.txt")}, {"Property editor class", "com.sas.beans.editors._SwingModelEditor"}}, {{"Name", "transferAllControlsVisible"}, {"Description", RB.getStringResource(RB_KEY, "transferAllControlsVisible.pd.txt")}}, {{"Name", "opaque"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultOutputPropertyName = "targetItems";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    protected void setDesignTime(boolean newValue) {
        this.designTime = newValue;
    }

    protected boolean isDesignTime() {
        return this.designTime;
    }

    public void setAlternatingSingleButtonStyle(boolean style) {
        boolean oldValue = this.alternatingSingleButtonStyle;
        this.alternatingSingleButtonStyle = style;
        this.makeBaseDualSelector();
        this.firePropertyChange("alternatingSingleButtonStyle", oldValue, this.alternatingSingleButtonStyle);
    }

    public boolean getAlternatingSingleButtonStyle() {
        return this.alternatingSingleButtonStyle;
    }

    public void setAlternatingMultipleButtonStyle(boolean style) {
        boolean oldValue = this.alternatingMultipleButtonStyle;
        this.alternatingMultipleButtonStyle = style;
        this.makeBaseDualSelector();
        this.firePropertyChange("alternatingMultipleButtonStyle", oldValue, this.alternatingMultipleButtonStyle);
    }

    public boolean getAlternatingMultipleButtonStyle() {
        return this.alternatingMultipleButtonStyle;
    }

    public void setDragAndDropEnabled(boolean enabled) {
        this.dragAndDropEnabled = enabled;
    }

    public boolean isDragAndDropEnabled() {
        return this.dragAndDropEnabled;
    }

    public boolean isInTargetModel(Object item) {
        return this.targetAdapter.isInAdapter(item);
    }

    public boolean isInSourceModel(Object item) {
        return this.sourceAdapter.isInAdapter(item);
    }

    public JPanel getSourceTopActionButtonContainer() {
        return this.sourceTopButtonContainer;
    }

    public JPanel getSourceBottomActionButtonContainer() {
        return this.sourceBottomButtonContainer;
    }

    public JComponent getSourceComponent() {
        if (this.sourceAdapter.getComponent() != null) {
            return this.sourceAdapter.getComponent();
        }
        return null;
    }

    public JComponent getTargetComponent() {
        if (this.targetAdapter.getComponent() != null) {
            return this.targetAdapter.getComponent();
        }
        return null;
    }

    public synchronized void setCopyModeEnabled(boolean mode) {
        boolean oldValue = this.copyModeEnabled;
        this.copyModeEnabled = mode;
        this.firePropertyChange("copyModeEnabled", oldValue, this.copyModeEnabled);
    }

    public boolean isCopyModeEnabled() {
        return this.copyModeEnabled;
    }

    public synchronized void setCopyModeDuplicatesAllowed(boolean duplicates) {
        boolean oldValue = this.copyModeDuplicatesAllowed;
        this.copyModeDuplicatesAllowed = duplicates;
        this.firePropertyChange("copyModeDuplicatesAllowed", oldValue, this.copyModeDuplicatesAllowed);
    }

    public boolean getCopyModeDuplicatesAllowed() {
        return this.copyModeDuplicatesAllowed;
    }

    public JComponent getSourceLabelComponent() {
        return this.sourceLabel;
    }

    public JComponent getTargetLabelComponent() {
        return this.targetLabel;
    }

    public String getSourceLabel() {
        return this.sourceLabel.getText();
    }

    public void setSourceLabel(String newValue) {
        String oldLabel = this.sourceLabel.getText();
        if (com.sas.util.Util.equal((Object)oldLabel, (Object)newValue)) {
            return;
        }
        this.sourceLabel.setText(newValue);
        this.firePropertyChange("sourceLabel", oldLabel, newValue);
    }

    public boolean isTargetControlsVisible() {
        return this.targetControlsVisible;
    }

    public void setTargetControlsVisible(boolean newValue) {
        if (newValue == this.targetControlsVisible) {
            return;
        }
        this.targetControlsVisible = newValue;
        this.targetUpButton.setVisible(newValue);
        this.targetDownButton.setVisible(newValue);
        this.ensureButtonsEnabled();
        this.validate();
        this.repaint();
        this.firePropertyChange("targetControlsVisible", this.targetControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.targetControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getTargetLabel() {
        return this.targetLabel.getText();
    }

    public void setTargetLabel(String newValue) {
        String oldValue = this.targetLabel.getText();
        if (com.sas.util.Util.equal((Object)newValue, (Object)oldValue)) {
            return;
        }
        this.targetLabel.setText(newValue);
        this.firePropertyChange("targetLabel", oldValue, newValue);
    }

    public int getTargetMaximumCount() {
        return this.targetMaximumCount;
    }

    public void setTargetMaximumCount(int newValue) {
        if (newValue == this.targetMaximumCount) {
            return;
        }
        if (newValue != -1 && this.targetAdapter.getCount() > newValue) {
            throw new IllegalStateException(Message.format((String)RB.getStringResource(RB_KEY, "invalidCount.ex.txt"), (Object)new Integer(newValue), (Object)new Integer(2), (Object)new Integer(this.targetAdapter.getCount())));
        }
        Integer oldValue = new Integer(this.targetMaximumCount);
        this.targetMaximumCount = newValue;
        this.firePropertyChange("targetMaximumCount", oldValue, new Integer(newValue));
        this.ensureButtonsEnabled();
    }

    @Override
    public void setEnabled(boolean e) {
        if (e != this.isEnabled() && this.initialized) {
            super.setEnabled(e);
            Util.setEnabledOnContainer(this, e);
            this.ensureButtonsEnabled();
        }
    }

    public boolean isTransferAllControlsVisible() {
        return this.transferAllControlsVisible;
    }

    public void setTransferAllControlsVisible(boolean newValue) {
        if (newValue == this.transferAllControlsVisible) {
            return;
        }
        this.transferAllControlsVisible = newValue;
        if (this.allRightButton != null) {
            this.allRightButton.setVisible(this.transferAllControlsVisible);
        }
        if (this.allLeftButton != null) {
            this.allLeftButton.setVisible(this.transferAllControlsVisible);
        }
        if (this.alternatingMultipleButton != null) {
            this.alternatingMultipleButton.setVisible(this.transferAllControlsVisible);
        }
        this.validate();
        this.repaint();
        this.firePropertyChange("transferAllControlsVisible", this.transferAllControlsVisible ? Boolean.FALSE : Boolean.TRUE, this.transferAllControlsVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setToolTipText(JComponent component, String text) {
        super.setToolTipText(text);
        component.setToolTipText(text);
    }

    public void setSourceMouseListener(MouseListener mouseListener) {
        JComponent component = this.getSourceComponent();
        component.removeMouseListener(this.sourceMouseListener);
        this.sourceMouseListener = mouseListener;
        component.addMouseListener(this.sourceMouseListener);
    }

    public void setTargetMouseListener(MouseListener mouseListener) {
        JComponent component = this.getTargetComponent();
        component.removeMouseListener(this.targetMouseListener);
        this.targetMouseListener = mouseListener;
        component.addMouseListener(this.targetMouseListener);
    }

    public MouseListener getSourceMouseListener() {
        return this.sourceMouseListener;
    }

    public MouseListener getTargetMouseListener() {
        return this.targetMouseListener;
    }

    protected synchronized void moveTargetItem(boolean moveItemUp) {
        int[] selectedIndices = ((DualSelectorUpDownInterface)this.targetAdapter).getSelectedIndices();
        if (selectedIndices != null && selectedIndices.length > 0) {
            int offset = moveItemUp ? -1 : 1;
            ((DualSelectorUpDownInterface)this.targetAdapter).moveItems(selectedIndices, offset);
        }
        this.ensureButtonsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferAllItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
        DualSelectorInterface dualSelectorInterface = fromAdapter;
        synchronized (dualSelectorInterface) {
            DualSelectorInterface dualSelectorInterface2 = toAdapter;
            synchronized (dualSelectorInterface2) {
                int count = fromAdapter.getCount() + toAdapter.getCount();
                int maxCount = -1;
                if (fromAdapter == this.sourceAdapter) {
                    maxCount = this.getTargetMaximumCount();
                }
                if (maxCount == -1 || count <= maxCount) {
                    List allItems = fromAdapter.getAllMoveableItems();
                    if (!this.copyModeDuplicatesAllowed && this.copyModeEnabled && fromAdapter == this.sourceAdapter) {
                        List toItems = toAdapter.getAllItems();
                        int toItemsSize = toItems.size();
                        int size = allItems.size();
                        for (int j = size - 1; j >= 0; --j) {
                            boolean add = true;
                            Object addItem = allItems.get(j);
                            for (int i = 0; i <= toItemsSize - 1; ++i) {
                                if (!this.areValuesEqual(addItem, toItems.get(i))) continue;
                                add = false;
                                allItems.remove(j);
                                break;
                            }
                            if (!add) continue;
                            toItems.add(addItem);
                            ++toItemsSize;
                        }
                    }
                    if (this.copyModeEnabled && fromAdapter == this.sourceAdapter || !this.copyModeEnabled) {
                        toAdapter.addItems(allItems);
                    }
                    if (!this.copyModeEnabled || this.copyModeEnabled && fromAdapter == this.targetAdapter) {
                        fromAdapter.removeItems(allItems);
                    }
                    if (toAdapter instanceof DualSelectorV2Interface) {
                        ((DualSelectorV2Interface)toAdapter).setSelectedValues(allItems);
                    }
                    this.ensureButtonsEnabled();
                    this.firePropertyChange("sourceItems", null, fromAdapter.getAllMoveableItems());
                    this.firePropertyChange("targetItems", null, toAdapter.getAllItems());
                }
            }
        }
    }

    public synchronized void transferAllSourceItems() {
        if (this.canTransferAllSourceItems()) {
            this.transferAllItems(this.sourceAdapter, this.targetAdapter);
        }
    }

    protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
        this.transferItems(fromAdapter, toAdapter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List passedItems) {
        int index;
        int selectedCount;
        int maxCnt = -1;
        if (fromAdapter == this.sourceAdapter) {
            maxCnt = this.getTargetMaximumCount();
        }
        if (passedItems == null) {
            this.selectedItems = fromAdapter.getSelectedItems();
            selectedCount = fromAdapter.getSelectedCount();
            index = fromAdapter.getLastSelectedIndex();
        } else {
            this.selectedItems = passedItems;
            index = selectedCount = passedItems.size();
        }
        if (this.selectedItems != null && selectedCount > 0) {
            DualSelectorInterface dualSelectorInterface = fromAdapter;
            synchronized (dualSelectorInterface) {
                DualSelectorInterface dualSelectorInterface2 = toAdapter;
                synchronized (dualSelectorInterface2) {
                    int count = this.selectedItems.size() + toAdapter.getCount();
                    if (maxCnt == -1 || count <= maxCnt) {
                        Vector addItems = new Vector(this.selectedItems);
                        if (!this.copyModeDuplicatesAllowed) {
                            List toItems = toAdapter.getAllItems();
                            int toItemsSize = toItems.size();
                            int size = addItems.size();
                            for (int j = size - 1; j >= 0; --j) {
                                boolean add = true;
                                Object addItem = addItems.get(j);
                                for (int i = 0; i <= toItemsSize - 1; ++i) {
                                    if (!this.areValuesEqual(addItem, toItems.get(i))) continue;
                                    add = false;
                                    addItems.remove(j);
                                    break;
                                }
                                if (!add) continue;
                                toItems.add(addItem);
                                ++toItemsSize;
                            }
                        }
                        if (addItems.size() > 0 && (this.copyModeEnabled && fromAdapter == this.sourceAdapter || !this.copyModeEnabled)) {
                            toAdapter.addItems(addItems);
                        }
                        if (!this.copyModeEnabled || this.copyModeEnabled && fromAdapter == this.targetAdapter) {
                            fromAdapter.removeItems(this.selectedItems);
                        }
                        if (toAdapter instanceof DualSelectorV2Interface) {
                            ((DualSelectorV2Interface)toAdapter).setSelectedValues(this.selectedItems);
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }
    }

    protected boolean areValuesEqual(Object o1, Object o2) {
        return o1.equals(o2);
    }

    public synchronized void transferSourceItems() {
        if (this.canTransferSelectedSourceItems()) {
            this.transferItems(this.sourceAdapter, this.targetAdapter);
        }
    }

    public synchronized void transferAllTargetItems() {
        if (this.canTransferAllTargetItems()) {
            this.transferAllItems(this.targetAdapter, this.sourceAdapter);
        }
    }

    public synchronized void transferTargetItems() {
        if (this.canTransferSelectedTargetItems()) {
            this.transferItems(this.targetAdapter, this.sourceAdapter);
        }
    }

    public void transferToTargetModel(Object[] objectArray) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i <= objectArray.length - 1; ++i) {
            if (!this.isInSourceModel(objectArray[i])) continue;
            items.add(objectArray[i]);
        }
        if (this.canTransferSourceItems(items)) {
            this.transferItems(this.sourceAdapter, this.targetAdapter, items);
        }
    }

    public void transferToSourceModel(Object[] objectArray) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i <= objectArray.length - 1; ++i) {
            if (!this.isInTargetModel(objectArray[i])) continue;
            items.add(objectArray[i]);
        }
        if (this.canTransferTargetItems(items)) {
            this.transferItems(this.targetAdapter, this.sourceAdapter, items);
        }
    }

    public boolean canTransferSelectedSourceItems() {
        int selCount = this.sourceAdapter.getSelectedItems().size();
        if (selCount < 0) {
            selCount = 0;
        }
        int targetCount = this.targetAdapter.getCount();
        int targetMaxCnt = this.getTargetMaximumCount();
        return targetMaxCnt == -1 || targetCount + selCount <= targetMaxCnt;
    }

    public boolean canTransferSelectedTargetItems() {
        return this.targetAdapter.getSelectedCount() > 0;
    }

    public boolean canTransferAllSourceItems() {
        int targetCount = this.targetAdapter.getCount();
        int sourceCount = this.sourceAdapter.getCount();
        int targetMaxCnt = this.getTargetMaximumCount();
        return targetMaxCnt == -1 || sourceCount + targetCount <= targetMaxCnt;
    }

    public boolean canTransferAllTargetItems() {
        return this.targetAdapter.getSelectedCount() > 0;
    }

    public boolean canTransferSourceItems(List items) {
        int targetCount;
        return items != null && ((targetCount = this.targetAdapter.getCount()) + items.size() <= this.getTargetMaximumCount() || this.getTargetMaximumCount() == -1);
    }

    public boolean canTransferTargetItems(List items) {
        return true;
    }

    protected void ensureButtonsEnabled() {
        int selCount = 0;
        int sourceCount = this.sourceAdapter.getCount();
        int targetCount = this.targetAdapter.getCount();
        if (!this.direction && sourceCount > 0 || this.direction && targetCount > 0) {
            int n = selCount = !this.direction ? this.sourceAdapter.getSelectedCount() : this.targetAdapter.getSelectedCount();
            if (selCount < 0) {
                selCount = 0;
            }
        } else {
            selCount = 0;
        }
        if (selCount == 0) {
            if (this.alternatingSingleButtonStyle) {
                if (this.alternatingSingleButton.isEnabled()) {
                    this.alternatingSingleButton.setEnabled(false);
                }
            } else {
                if (this.leftButton.isEnabled()) {
                    this.leftButton.setEnabled(false);
                }
                if (this.rightButton.isEnabled()) {
                    this.rightButton.setEnabled(false);
                }
            }
            if (this.alternatingMultipleButtonStyle) {
                if (this.alternatingMultipleButton.isEnabled()) {
                    this.alternatingMultipleButton.setEnabled(false);
                }
            } else {
                if (this.allLeftButton.isEnabled()) {
                    this.allLeftButton.setEnabled(false);
                }
                if (this.allRightButton.isEnabled()) {
                    this.allRightButton.setEnabled(false);
                }
            }
        } else if (this.isEnabled()) {
            boolean enable = false;
            enable = !this.direction ? this.canTransferSelectedSourceItems() : this.canTransferSelectedTargetItems();
            if (this.alternatingSingleButtonStyle) {
                if (this.alternatingSingleButton.isEnabled() != enable) {
                    this.alternatingSingleButton.setEnabled(enable);
                }
            } else if (!this.direction) {
                if (this.leftButton.isEnabled()) {
                    this.leftButton.setEnabled(false);
                }
                if (!this.rightButton.isEnabled()) {
                    this.rightButton.setEnabled(enable);
                }
            } else {
                if (!this.leftButton.isEnabled()) {
                    this.leftButton.setEnabled(enable);
                }
                if (this.rightButton.isEnabled()) {
                    this.rightButton.setEnabled(false);
                }
            }
            enable = !this.direction ? this.canTransferAllSourceItems() : this.canTransferAllTargetItems();
            if (this.alternatingMultipleButtonStyle) {
                if (this.alternatingMultipleButton.isEnabled() != enable) {
                    this.alternatingMultipleButton.setEnabled(enable);
                }
            } else {
                if (selCount > 0 && this.direction) {
                    if (this.allLeftButton.isEnabled() != enable) {
                        this.allLeftButton.setEnabled(enable);
                    }
                } else if (this.allLeftButton.isEnabled()) {
                    this.allLeftButton.setEnabled(false);
                }
                if (sourceCount > 0 && !this.direction) {
                    if (this.allRightButton.isEnabled() != enable) {
                        this.allRightButton.setEnabled(enable);
                    }
                } else if (this.allRightButton.isEnabled()) {
                    this.allRightButton.setEnabled(false);
                }
            }
        }
        if (this.direction && selCount > 0) {
            if (this.targetAdapter instanceof DualSelectorUpDownInterface && this.targetControlsVisible && selCount >= 0 && targetCount > 1 && selCount != targetCount) {
                int[] selectedIndices = ((DualSelectorUpDownInterface)this.targetAdapter).getSelectedIndices();
                boolean canMove = false;
                canMove = ((DualSelectorUpDownInterface)this.targetAdapter).canMove(selectedIndices, -1);
                if (canMove) {
                    this.targetUpButton.setEnabled(true);
                } else {
                    this.targetUpButton.setEnabled(false);
                }
                canMove = ((DualSelectorUpDownInterface)this.targetAdapter).canMove(selectedIndices, 1);
                if (canMove) {
                    this.targetDownButton.setEnabled(true);
                } else {
                    this.targetDownButton.setEnabled(false);
                }
            } else if (this.targetControlsVisible) {
                this.targetUpButton.setEnabled(false);
                this.targetDownButton.setEnabled(false);
            }
        } else if (this.targetControlsVisible) {
            this.targetUpButton.setEnabled(false);
            this.targetDownButton.setEnabled(false);
        }
    }

    protected void initializeBaseDualSelector() {
        this.initialized = false;
        this.targetControlsVisible = false;
        this.transferAllControlsVisible = true;
        this.alternatingSingleButtonStyle = true;
        this.alternatingMultipleButtonStyle = true;
        this.copyModeEnabled = false;
        this.copyModeDuplicatesAllowed = true;
        this.setOpaque(true);
        this.targetButtonsLocation = 264;
        this.grouping = false;
        this.alternatingSingleButtonIcons = new HashMap();
        this.alternatingMultipleButtonIcons = new HashMap();
        this.sourceMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BaseDualSelector.this.isEnabled()) {
                    BaseDualSelector.this.transferSourceItems();
                }
            }
        };
        this.targetMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BaseDualSelector.this.isEnabled()) {
                    BaseDualSelector.this.transferTargetItems();
                }
            }
        };
        this.leftArrow = Resources.getImageIcon((String)"LeftArrow");
        this.rightArrow = Resources.getImageIcon((String)"RightArrow");
        this.doubleLeftArrow = Resources.getImageIcon((String)"DoubleLeftArrow");
        this.doubleRightArrow = Resources.getImageIcon((String)"DoubleRightArrow");
        this.sourceLabel = this.createSourceLabel();
        this.targetLabel = this.createTargetLabel();
        this.alternatingSingleButton = new JButton((String)null);
        this.setAlternatingSingleButtonIcons(this.rightArrow, this.leftArrow);
        this.alternatingSingleButton.setMargin(nullInsets);
        this.alternatingSingleButton.setDefaultCapable(false);
        this.alternatingSingleButton.setToolTipText(RB.getStringResource(RB_KEY, "alternatingSingleButton.txt"));
        this.leftButton = new JButton((String)null);
        this.leftButton.setIcon(this.leftArrow);
        this.leftButton.setMargin(nullInsets);
        this.leftButton.setDefaultCapable(false);
        this.leftButton.setToolTipText(RB.getStringResource(RB_KEY, "leftButton.txt"));
        this.rightButton = new JButton((String)null);
        this.rightButton.setIcon(this.rightArrow);
        this.rightButton.setMargin(nullInsets);
        this.rightButton.setDefaultCapable(false);
        this.rightButton.setToolTipText(RB.getStringResource(RB_KEY, "rightButton.txt"));
        this.alternatingMultipleButton = new JButton((String)null);
        this.setAlternatingMultipleButtonIcons(this.doubleRightArrow, this.doubleLeftArrow);
        this.alternatingMultipleButton.setMargin(nullInsets);
        this.alternatingMultipleButton.setDefaultCapable(false);
        this.alternatingMultipleButton.setToolTipText(RB.getStringResource(RB_KEY, "alternatingMultipleButton.txt"));
        this.allLeftButton = new JButton((String)null);
        this.allLeftButton.setIcon(this.doubleLeftArrow);
        this.allLeftButton.setMargin(nullInsets);
        this.allLeftButton.setDefaultCapable(false);
        this.allLeftButton.setToolTipText(RB.getStringResource(RB_KEY, "allLeftButton.txt"));
        this.allRightButton = new JButton((String)null);
        this.allRightButton.setIcon(this.doubleRightArrow);
        this.allRightButton.setMargin(nullInsets);
        this.allRightButton.setDefaultCapable(false);
        this.allRightButton.setToolTipText(RB.getStringResource(RB_KEY, "allRightButton.txt"));
        this.targetUpButton = new JButton((String)null);
        ImageIcon icon = Resources.getImageIcon((String)"UpArrow");
        this.targetUpButton.setIcon(icon);
        this.targetUpButton.setMargin(nullInsets);
        this.targetUpButton.setDefaultCapable(false);
        this.targetUpButton.setToolTipText(RB.getStringResource(RB_KEY, "targetUpButton.txt"));
        this.targetDownButton = new JButton((String)null);
        icon = Resources.getImageIcon((String)"DownArrow");
        this.targetDownButton.setIcon(icon);
        this.targetDownButton.setMargin(nullInsets);
        this.targetDownButton.setDefaultCapable(false);
        this.targetDownButton.setToolTipText(RB.getStringResource(RB_KEY, "targetDownButton.txt"));
        this.initialized = true;
        this.makeBaseDualSelector();
    }

    protected void initializeSize() {
        this.setPreferredSize(new Dimension(250, 250));
    }

    protected void addListeners() {
        this.alternatingSingleButton.removeActionListener(this);
        this.alternatingSingleButton.addActionListener(this);
        this.leftButton.removeActionListener(this);
        this.leftButton.addActionListener(this);
        this.rightButton.removeActionListener(this);
        this.rightButton.addActionListener(this);
        this.alternatingMultipleButton.removeActionListener(this);
        this.alternatingMultipleButton.addActionListener(this);
        this.allRightButton.removeActionListener(this);
        this.allRightButton.addActionListener(this);
        this.allLeftButton.removeActionListener(this);
        this.allLeftButton.addActionListener(this);
        MyKeyAdapter keyAdapter = new MyKeyAdapter();
        this.sourceAdapter.getComponent().addKeyListener(keyAdapter);
        this.targetAdapter.getComponent().addKeyListener(keyAdapter);
        this.targetUpButton.removeActionListener(this);
        this.targetUpButton.addActionListener(this);
        this.targetDownButton.removeActionListener(this);
        this.targetDownButton.addActionListener(this);
        this.sourceFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BaseDualSelector.this.sourceAdapter.getLastSelectedIndex() < 0) {
                    BaseDualSelector.this.sourceAdapter.setSelectedIndex(0);
                }
                if (BaseDualSelector.this.sourceAdapter.getCount() > 0) {
                    BaseDualSelector.this.direction = false;
                    BaseDualSelector.this.ensureButtonsEnabled();
                }
            }
        };
        this.targetFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BaseDualSelector.this.targetAdapter.getLastSelectedIndex() < 0) {
                    BaseDualSelector.this.targetAdapter.setSelectedIndex(0);
                }
                if (BaseDualSelector.this.targetAdapter.getCount() > 0) {
                    BaseDualSelector.this.direction = true;
                    BaseDualSelector.this.ensureButtonsEnabled();
                }
            }
        };
    }

    private void makeBaseDualSelector() {
        this.removeAll();
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 0, 0, true, true, true);
        this.setLayout(mainLayout);
        this.mainPanel = new JPanel();
        this.mainPanel.setOpaque(false);
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 3, 5, 5, true, true, true);
        this.partitioner = new ProportionalSpacePartitioner(new double[]{0.5, -2.0, 0.5});
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        layout.setRemainderRow(1);
        this.mainPanel.setLayout(layout);
        layout.setColumnSpacePartitioner(this.partitioner);
        this.sourceContainer = new JPanel();
        this.sourceContainer.setOpaque(false);
        AutoSizingGridLayout sourceLayout = new AutoSizingGridLayout(4, 1, 5, 5, true, true, true);
        sourceLayout.setRemainderRow(3);
        sourceLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.sourceContainer.setLayout(sourceLayout);
        this.middleContainer = new JPanel();
        this.middleContainer.setOpaque(false);
        AutoSizingGridLayout middleLayout = new AutoSizingGridLayout(-1, 1, 5, 5, false, true, false);
        middleLayout.setRemainderRow(1);
        middleLayout.setIgnoreSizeOfNonVisibleComponents(true);
        middleLayout.setGridGravity(256);
        this.middleContainer.setLayout(middleLayout);
        this.buttonContainer = new JPanel();
        this.buttonContainer.setOpaque(false);
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(-1, 1, 5, 5);
        buttonLayout.setGridGravity(256);
        this.buttonContainer.setLayout(buttonLayout);
        this.targetContainer = new JPanel();
        this.targetContainer.setOpaque(false);
        AutoSizingGridLayout targetLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        targetLayout.setRemainderRow(2);
        targetLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.targetContainer.setLayout(targetLayout);
        JPanel targetInnerContainer = new JPanel();
        targetInnerContainer.setOpaque(false);
        AutoSizingGridLayout targetInnerContainerLayout = null;
        targetInnerContainerLayout = this.targetButtonsLocation == 6 ? new AutoSizingGridLayout(1, 2, 5, 5, true, true, true) : new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        targetInnerContainerLayout.setRemainderRow(1);
        targetInnerContainerLayout.setRemainderColumn(1);
        targetInnerContainerLayout.setIgnoreSizeOfNonVisibleComponents(true);
        targetInnerContainer.setLayout(targetInnerContainerLayout);
        JPanel targetUpDownContainer = new JPanel();
        targetUpDownContainer.setOpaque(false);
        AutoSizingGridLayout targetUpDownLayout = null;
        if (this.targetButtonsLocation == 264) {
            targetUpDownLayout = new AutoSizingGridLayout(1, 2, 5, 5);
            targetUpDownLayout.setIgnoreSizeOfNonVisibleComponents(true);
            targetUpDownLayout.setGridGravity(256);
        } else {
            targetUpDownLayout = new AutoSizingGridLayout(2, 1, 5, 5);
        }
        targetUpDownContainer.setLayout(targetUpDownLayout);
        targetUpDownContainer.add(this.targetUpButton);
        this.targetUpButton.setVisible(this.targetControlsVisible);
        targetUpDownContainer.add(this.targetDownButton);
        this.targetDownButton.setVisible(this.targetControlsVisible);
        this.sourceTopButtonContainer = new JPanel();
        this.sourceTopButtonContainer.setOpaque(false);
        AutoSizingGridLayout sourceTopButtonLayout = new AutoSizingGridLayout(1, 2, 5, 5);
        sourceTopButtonLayout.setIgnoreSizeOfNonVisibleComponents(true);
        sourceTopButtonLayout.setGridGravity(1);
        this.sourceTopButtonContainer.setLayout(sourceTopButtonLayout);
        this.sourceBottomButtonContainer = new JPanel();
        this.sourceBottomButtonContainer.setOpaque(false);
        AutoSizingGridLayout sourceBottomButtonLayout = new AutoSizingGridLayout(1, 2, 5, 5);
        sourceBottomButtonLayout.setIgnoreSizeOfNonVisibleComponents(true);
        sourceBottomButtonLayout.setGridGravity(1);
        this.sourceBottomButtonContainer.setLayout(sourceBottomButtonLayout);
        this.sourceContainer.add(this.sourceLabel);
        this.sourceContainer.add(this.sourceTopButtonContainer);
        this.sourceContainer.add(this.sourceAdapter.getContainerComponent());
        this.sourceContainer.add(this.sourceBottomButtonContainer);
        this.sourceContainer.requestFocus();
        if (!this.alternatingSingleButtonStyle && !this.alternatingMultipleButtonStyle && this.grouping) {
            this.buttonContainer.add(this.rightButton);
            this.buttonContainer.add(this.allRightButton);
            this.buttonContainer.add(this.leftButton);
            this.buttonContainer.add(this.allLeftButton);
        } else {
            if (this.alternatingSingleButtonStyle) {
                this.buttonContainer.add(this.alternatingSingleButton);
            } else {
                this.buttonContainer.add(this.rightButton);
                this.buttonContainer.add(this.leftButton);
            }
            if (this.alternatingMultipleButtonStyle) {
                this.buttonContainer.add(this.alternatingMultipleButton);
            } else {
                this.buttonContainer.add(this.allLeftButton);
                this.buttonContainer.add(this.allRightButton);
            }
        }
        this.middleContainer.add(this.buttonContainer);
        targetInnerContainer.add(this.targetAdapter.getContainerComponent());
        targetInnerContainer.add(targetUpDownContainer);
        this.targetContainer.add(this.targetLabel);
        this.targetContainer.add(targetInnerContainer);
        this.mainPanel.add(this.sourceContainer);
        this.mainPanel.add(this.middleContainer);
        this.mainPanel.add(this.targetContainer);
        this.add(this.mainPanel);
        this.initializeSize();
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    public JLabel createSourceLabel() {
        JLabel sourceLabel = new JLabel(RB.getStringResource(RB_KEY, "available.txt"));
        Integer keyEvent = new Integer(Util.getKeyMapping("VK_" + RB.getStringResource(RB_KEY, "availableMnemonic.txt")));
        sourceLabel.setDisplayedMnemonic(keyEvent);
        sourceLabel.setLabelFor(this.sourceAdapter.getComponent());
        return sourceLabel;
    }

    public JLabel createTargetLabel() {
        JLabel targetLabel = new JLabel(RB.getStringResource(RB_KEY, "selected.txt"));
        targetLabel.setLabelFor(this.targetAdapter.getComponent());
        Integer keyEvent = new Integer(Util.getKeyMapping("VK_" + RB.getStringResource(RB_KEY, "selectedMnemonic.txt")));
        targetLabel.setDisplayedMnemonic(keyEvent);
        return targetLabel;
    }

    @Override
    public void setBackground(Color color) {
        if (this.initialized) {
            this.sourceLabel.setBackground(color);
            this.targetLabel.setBackground(color);
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setBackground(color);
            } else {
                this.leftButton.setBackground(color);
                this.rightButton.setBackground(color);
            }
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setBackground(color);
            } else {
                this.allLeftButton.setBackground(color);
                this.allRightButton.setBackground(color);
            }
            this.targetUpButton.setBackground(color);
            this.targetDownButton.setBackground(color);
            this.mainPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    public void setFont(Font font) {
        if (this.initialized) {
            Font oldFont = this.getFont();
            super.setFont(font);
            this.sourceLabel.setFont(font);
            this.targetLabel.setFont(font);
            this.sourceAdapter.getComponent().setFont(font);
            this.targetAdapter.getComponent().setFont(font);
            if (oldFont != null && !oldFont.equals(font)) {
                this.invalidate();
                this.validate();
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.initialized) {
            this.sourceLabel.setForeground(color);
            this.targetLabel.setForeground(color);
            this.sourceAdapter.getComponent().setForeground(color);
            this.targetAdapter.getComponent().setForeground(color);
            this.mainPanel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setTargetButtonsLocation(int location) {
        this.targetButtonsLocation = location == 6 ? location : 264;
        this.makeBaseDualSelector();
    }

    public boolean isGroupDirectionalButtonsTogether() {
        return this.grouping;
    }

    public void setGroupDirectionalButtonsTogether(boolean grouping) {
        if (this.grouping != grouping) {
            this.grouping = grouping;
            this.makeBaseDualSelector();
        }
    }

    protected Icon getAlternatingButtonIcon(String buttonConstant, boolean direction) {
        if (buttonConstant == ALTERNATING_SINGLE_BUTTON) {
            if (!direction) {
                return (Icon)this.alternatingSingleButtonIcons.get(RIGHT_DIRECTION);
            }
            return (Icon)this.alternatingSingleButtonIcons.get(LEFT_DIRECTION);
        }
        if (buttonConstant == ALTERNATING_MULTIPLE_BUTTON) {
            if (!direction) {
                return (Icon)this.alternatingMultipleButtonIcons.get(RIGHT_DIRECTION);
            }
            return (Icon)this.alternatingMultipleButtonIcons.get(LEFT_DIRECTION);
        }
        throw new IllegalArgumentException(MessageFormat.format(com.sas.util.Util.getCommonStringResource((String)"InvalidValue.ex.txt"), buttonConstant));
    }

    public void setAlternatingSingleButtonIcons(Icon rightIcon, Icon leftIcon) {
        this.alternatingSingleButtonIcons.put(RIGHT_DIRECTION, rightIcon);
        this.alternatingSingleButtonIcons.put(LEFT_DIRECTION, leftIcon);
        if (!this.direction) {
            this.alternatingSingleButton.setIcon(rightIcon);
        } else {
            this.alternatingSingleButton.setIcon(leftIcon);
        }
    }

    public void setAlternatingMultipleButtonIcons(Icon rightIcon, Icon leftIcon) {
        this.alternatingMultipleButtonIcons.put(RIGHT_DIRECTION, rightIcon);
        this.alternatingMultipleButtonIcons.put(LEFT_DIRECTION, leftIcon);
        if (!this.direction) {
            this.alternatingMultipleButton.setIcon(rightIcon);
        } else {
            this.alternatingMultipleButton.setIcon(leftIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.allRightButton) {
            this.transferAllSourceItems();
            this.allLeftButton.requestFocusInWindow();
        } else if (source == this.alternatingSingleButton) {
            if (!this.direction) {
                this.transferSourceItems();
            } else if (this.direction) {
                this.transferTargetItems();
            }
            this.alternatingSingleButton.requestFocusInWindow();
        } else if (source == this.allLeftButton) {
            this.transferAllTargetItems();
            this.allRightButton.requestFocusInWindow();
        } else if (source == this.alternatingMultipleButton) {
            if (!this.direction) {
                this.transferAllSourceItems();
            } else if (this.direction) {
                this.transferAllTargetItems();
            }
            this.alternatingMultipleButton.requestFocusInWindow();
        } else if (source == this.targetUpButton) {
            this.moveTargetItem(true);
            DualSelectorInterface dualSelectorInterface = this.targetAdapter;
            synchronized (dualSelectorInterface) {
                if (((DualSelectorUpDownInterface)this.targetAdapter).isSelectedIndex(0)) {
                    this.targetDownButton.requestFocusInWindow();
                } else {
                    this.targetUpButton.requestFocusInWindow();
                }
            }
        } else if (source == this.targetDownButton) {
            this.moveTargetItem(false);
            DualSelectorInterface dualSelectorInterface = this.targetAdapter;
            synchronized (dualSelectorInterface) {
                if (((DualSelectorUpDownInterface)this.targetAdapter).isSelectedIndex(this.targetAdapter.getCount() - 1)) {
                    this.targetUpButton.requestFocusInWindow();
                } else {
                    this.targetDownButton.requestFocusInWindow();
                }
            }
        } else if (source == this.leftButton) {
            this.transferTargetItems();
            this.rightButton.requestFocusInWindow();
        } else if (source == this.rightButton) {
            this.transferSourceItems();
            this.leftButton.requestFocusInWindow();
        }
    }

    @Override
    @SASScope
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPanel();
        }
        return this.accessibleContext;
    }

    @SASScope
    public class MyKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            Object source = e.getSource();
            JComponent sourceComponent = BaseDualSelector.this.sourceAdapter.getComponent();
            JComponent targetComponent = BaseDualSelector.this.targetAdapter.getComponent();
            if (e.getModifiers() == 2) {
                if (e.getKeyCode() == 39 && source == sourceComponent) {
                    BaseDualSelector.this.transferSourceItems();
                } else if (e.getKeyCode() == 37 && source == targetComponent) {
                    BaseDualSelector.this.transferTargetItems();
                } else if (e.getKeyCode() == 38 && source == targetComponent) {
                    BaseDualSelector.this.moveTargetItem(true);
                } else if (e.getKeyCode() == 40 && source == targetComponent) {
                    BaseDualSelector.this.moveTargetItem(false);
                }
            }
            if (e.getModifiers() == 3) {
                if (e.getKeyCode() == 39 && source == sourceComponent) {
                    BaseDualSelector.this.transferAllSourceItems();
                } else if (e.getKeyCode() == 37 && source == targetComponent) {
                    BaseDualSelector.this.transferAllTargetItems();
                }
            } else if (e.getKeyCode() == 127 && source == targetComponent) {
                BaseDualSelector.this.transferTargetItems();
            }
        }
    }

    @SASScope
    public class AccessibleJPanel
    extends JComponent.AccessibleJComponent {
        public AccessibleJPanel() {
            super(BaseDualSelector.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

