/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.totals;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.totals.OLAPTotalsSelectorInterface;
import com.sas.dataselectors.totals.TotalsSelectorInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.totals.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

@SASScope(value="ALL")
public class TotalsSelector
extends BaseSwingSelectorPanel
implements LayoutConstants,
ActionListener {
    public static final String RB_KEY = "TotalsSelector.";
    private boolean isOLAP;
    private JCheckBox rowsTotalCheckBox;
    private JCheckBox rowsSubTotalCheckBox;
    private JCheckBox columnsTotalCheckBox;
    private JCheckBox columnsSubTotalCheckBox;
    private JRadioButton topRadio;
    private JRadioButton bottomRadio;
    private JCheckBox expandCheckBox;
    private JRadioButton preRadio;
    private JRadioButton visualRadio;
    private JPanel positionRadioPanel;
    private JPanel expandPanel;
    private JPanel typeLabelPanel;
    private JPanel typeRadioPanel;
    private LabelView messageLabel;

    public TotalsSelector() {
        this.createComponents();
        this.addListeners();
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(7, 1, 5, 5, false, true, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        JPanel insertLabelPanel = new JPanel();
        insertLabelPanel.setLayout(new AutoSizingGridLayout(1, 1, 5, 5, false, false, false));
        JLabel label = new JLabel(RB.getStringResource(RB_KEY, "insertLabel.txt"));
        insertLabelPanel.add(label);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new AutoSizingGridLayout(2, 4, 5, 5, false, false, false));
        JLabel rowsLabel = new JLabel(RB.getStringResource(RB_KEY, "forRowsLabel.txt"));
        this.rowsTotalCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "total.txt"));
        this.rowsSubTotalCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "subtotal.txt"));
        JLabel colsLabel = new JLabel(RB.getStringResource(RB_KEY, "forColumnsLabel.txt"));
        this.columnsTotalCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "total.txt"));
        this.columnsSubTotalCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "subtotal.txt"));
        checkBoxPanel.add(this.getVerticalSeparator());
        checkBoxPanel.add(rowsLabel);
        checkBoxPanel.add(this.rowsSubTotalCheckBox);
        checkBoxPanel.add(this.rowsTotalCheckBox);
        checkBoxPanel.add(this.getVerticalSeparator());
        checkBoxPanel.add(colsLabel);
        checkBoxPanel.add(this.columnsSubTotalCheckBox);
        checkBoxPanel.add(this.columnsTotalCheckBox);
        this.positionRadioPanel = new JPanel();
        this.positionRadioPanel.setLayout(new AutoSizingGridLayout(2, 2, 5, 5, false, false, false));
        ButtonGroup group = new ButtonGroup();
        this.topRadio = new JRadioButton(RB.getStringResource(RB_KEY, "top.txt"));
        group.add(this.topRadio);
        this.bottomRadio = new JRadioButton(RB.getStringResource(RB_KEY, "bottom.txt"));
        group.add(this.bottomRadio);
        this.positionRadioPanel.add(this.getVerticalSeparator());
        this.positionRadioPanel.add(this.topRadio);
        this.positionRadioPanel.add(this.getVerticalSeparator());
        this.positionRadioPanel.add(this.bottomRadio);
        this.expandPanel = new JPanel();
        this.expandPanel.setLayout(new AutoSizingGridLayout(1, 2, 5, 5, false, false, false));
        this.expandCheckBox = new JCheckBox(RB.getStringResource(RB_KEY, "expandedtotal.txt"));
        this.expandPanel.add(this.getVerticalSeparator());
        this.expandPanel.add(this.expandCheckBox);
        this.typeLabelPanel = new JPanel();
        this.typeLabelPanel.setLayout(new AutoSizingGridLayout(1, 1, 5, 5, false, false, false));
        JLabel tlabel = new JLabel(RB.getStringResource(RB_KEY, "typeLabel.txt"));
        this.typeLabelPanel.add(tlabel);
        this.typeRadioPanel = new JPanel();
        this.typeRadioPanel.setLayout(new AutoSizingGridLayout(2, 2, 5, 5, false, false, false));
        ButtonGroup tgroup = new ButtonGroup();
        this.preRadio = new JRadioButton(RB.getStringResource(RB_KEY, "unfiltered.txt"));
        tgroup.add(this.preRadio);
        this.visualRadio = new JRadioButton(RB.getStringResource(RB_KEY, "visual.txt"));
        tgroup.add(this.visualRadio);
        this.typeRadioPanel.add(this.getVerticalSeparator());
        this.typeRadioPanel.add(this.preRadio);
        this.typeRadioPanel.add(this.getVerticalSeparator());
        this.typeRadioPanel.add(this.visualRadio);
        this.messageLabel = new LabelView(RB.getStringResource(RB_KEY, "noAdditiveDataItems.txt"));
        this.messageLabel.setPreferredSpanSize(new Dimension(195, -1));
        this.messageLabel.setVisible(false);
        this.add(insertLabelPanel);
        this.add(checkBoxPanel);
        this.add(this.positionRadioPanel);
        this.add(this.expandPanel);
        this.add(this.typeLabelPanel);
        this.add(this.typeRadioPanel);
        this.add(this.messageLabel);
    }

    private JSeparator getVerticalSeparator() {
        JSeparator b = new JSeparator(1);
        b.setPreferredSize(new Dimension(10, 0));
        return b;
    }

    protected void addListeners() {
        this.rowsTotalCheckBox.addActionListener(this);
        this.rowsSubTotalCheckBox.addActionListener(this);
        this.columnsTotalCheckBox.addActionListener(this);
        this.columnsSubTotalCheckBox.addActionListener(this);
        this.expandCheckBox.addActionListener(this);
        this.topRadio.addActionListener(this);
        this.bottomRadio.addActionListener(this);
        this.preRadio.addActionListener(this);
        this.visualRadio.addActionListener(this);
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && model instanceof TotalsSelectorInterface) {
            Object old = this.selectorModel;
            this.selectorModel = (TotalsSelectorInterface)model;
            this.isOLAP = this.selectorModel instanceof OLAPTotalsSelectorInterface;
            this.columnsTotalCheckBox.setEnabled(true);
            this.columnsTotalCheckBox.setSelected(((TotalsSelectorInterface)this.selectorModel).columnTotals());
            if (this.isOLAP) {
                this.rowsTotalCheckBox.setEnabled(true);
                this.rowsTotalCheckBox.setSelected(((OLAPTotalsSelectorInterface)this.selectorModel).rowTotals());
                this.rowsSubTotalCheckBox.setEnabled(true);
                this.rowsSubTotalCheckBox.setSelected(((OLAPTotalsSelectorInterface)this.selectorModel).rowSubtotals());
                this.columnsSubTotalCheckBox.setEnabled(true);
                this.columnsSubTotalCheckBox.setSelected(((OLAPTotalsSelectorInterface)this.selectorModel).columnSubtotals());
                this.setExpandTotalsCheckBoxState();
                this.setPositionRadioState();
                this.expandCheckBox.setSelected(((OLAPTotalsSelectorInterface)this.selectorModel).isExpandedTotals());
                this.topRadio.setSelected(((OLAPTotalsSelectorInterface)this.selectorModel).getTotalsPosition().equals("T"));
                this.bottomRadio.setSelected("B".equals(((OLAPTotalsSelectorInterface)this.selectorModel).getTotalsPosition()));
                this.preRadio.setSelected("U".equals(((OLAPTotalsSelectorInterface)this.selectorModel).getTotalsType()));
                this.visualRadio.setSelected("V".equals(((OLAPTotalsSelectorInterface)this.selectorModel).getTotalsType()));
            } else {
                this.rowsTotalCheckBox.setEnabled(false);
                this.rowsTotalCheckBox.setSelected(false);
                this.rowsSubTotalCheckBox.setEnabled(false);
                this.rowsSubTotalCheckBox.setSelected(false);
                this.columnsSubTotalCheckBox.setEnabled(false);
                this.columnsSubTotalCheckBox.setSelected(false);
                this.positionRadioPanel.setVisible(false);
                this.expandPanel.setVisible(false);
                this.typeLabelPanel.setVisible(false);
                this.typeRadioPanel.setVisible(false);
            }
            this.messageLabel.setVisible(false);
            if (!this.isOLAP && !((TotalsSelectorInterface)this.selectorModel).hasSummarizeableItems()) {
                this.columnsTotalCheckBox.setEnabled(false);
                this.messageLabel.setVisible(true);
            }
            this.setSize(this.getPreferredSize());
            Window window = (Window)Util.getParent(this, JDialog.class);
            if (window != null) {
                window.pack();
            }
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    @Override
    public String getDialogTitle() {
        return RB.getStringResource(RB_KEY, "total.txt");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        TotalsSelectorInterface model = (TotalsSelectorInterface)this.selectorModel;
        if (source == this.rowsTotalCheckBox) {
            ((OLAPTotalsSelectorInterface)model).rowTotals(this.rowsTotalCheckBox.isSelected());
            if (this.isOLAP) {
                this.setExpandTotalsCheckBoxState();
                this.setPositionRadioState();
            }
        } else if (source == this.columnsTotalCheckBox) {
            model.columnTotals(this.columnsTotalCheckBox.isSelected());
            if (this.isOLAP) {
                this.setExpandTotalsCheckBoxState();
                this.setPositionRadioState();
            }
        } else if (source == this.rowsSubTotalCheckBox) {
            ((OLAPTotalsSelectorInterface)model).rowSubtotals(this.rowsSubTotalCheckBox.isSelected());
            if (this.isOLAP) {
                this.setPositionRadioState();
            }
        } else if (source == this.columnsSubTotalCheckBox) {
            ((OLAPTotalsSelectorInterface)model).columnSubtotals(this.columnsSubTotalCheckBox.isSelected());
            if (this.isOLAP) {
                this.setPositionRadioState();
            }
        } else if (source == this.expandCheckBox) {
            ((OLAPTotalsSelectorInterface)model).setExpandedTotals(this.expandCheckBox.isSelected());
        } else if (source == this.topRadio) {
            ((OLAPTotalsSelectorInterface)model).setTotalsPosition(this.topRadio.isSelected() ? "T" : "B");
        } else if (source == this.bottomRadio) {
            ((OLAPTotalsSelectorInterface)model).setTotalsPosition(this.bottomRadio.isSelected() ? "B" : "T");
        } else if (source == this.preRadio) {
            ((OLAPTotalsSelectorInterface)model).setTotalsType(this.preRadio.isSelected() ? "U" : "V");
        } else if (source == this.visualRadio) {
            ((OLAPTotalsSelectorInterface)model).setTotalsType(this.visualRadio.isSelected() ? "V" : "U");
        }
    }

    private void setExpandTotalsCheckBoxState() {
        this.expandCheckBox.setEnabled(this.rowsTotalCheckBox.isSelected() || this.columnsTotalCheckBox.isSelected());
    }

    private void setPositionRadioState() {
        boolean isSubtotals = this.rowsSubTotalCheckBox.isSelected() || this.columnsSubTotalCheckBox.isSelected() || this.columnsTotalCheckBox.isSelected() || this.rowsTotalCheckBox.isSelected();
        this.topRadio.setEnabled(isSubtotals);
        this.bottomRadio.setEnabled(isSubtotals);
    }

    @Override
    @SASScope
    public void onApply() {
        OLAPTotalsSelectorInterface model;
        this.contentsValid = true;
        if (this.isOLAP && (model = (OLAPTotalsSelectorInterface)this.selectorModel).isGoingToRemovePercentOfTotal() && 2 == JOptionPane.showConfirmDialog(this, RB.getStringResource(RB_KEY, "removePercentConfirmationMsg.txt"), "title", 2, 2)) {
            this.contentsValid = false;
        }
        super.onApply();
    }
}

