/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters.editors;

import com.sas.swing.visuals.dataselectors.filters.editors.ValueEditorInterface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ValueEditorJTextPane
extends JTextPane
implements ValueEditorInterface {
    transient List valueEditorActionListeners = new ArrayList();
    transient JLabel valueLabel = null;

    public ValueEditorJTextPane(JComponent parent, String label, String name) {
        if (label != null) {
            this.valueLabel = new JLabel();
            this.valueLabel.setBounds(new Rectangle(0, 100, 205, 17));
            this.valueLabel.setName(label);
            this.valueLabel.setText(label);
        }
        ValueEditorJTextPane tmpTextPane = this;
        tmpTextPane.setBounds(new Rectangle(0, 0, 148, 23));
        tmpTextPane.setName(name);
        tmpTextPane.setMargin(new Insets(0, 1, 0, 0));
        JScrollPane tmpScrollPane = new JScrollPane(tmpTextPane);
        tmpScrollPane.setBounds(new Rectangle(205, 142, 168, 24));
        tmpScrollPane.setName("Scroll " + name);
        JComboBox tmpBug = new JComboBox();
        tmpTextPane.setFont(tmpBug.getFont());
        tmpScrollPane.setBorder(tmpBug.getBorder());
        if (this.valueLabel != null) {
            this.valueLabel.setLabelFor(tmpTextPane);
            parent.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 6, 0, 5), 0, 0));
        }
        parent.add((Component)tmpScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(2, 4, 2, 6), 0, 0));
        InnerDocumentListener myDocumentListener = new InnerDocumentListener();
        Document doc = this.getDocument();
        doc.addDocumentListener(myDocumentListener);
        this.setText("");
    }

    @Override
    public List setEditorValues(List newValues) {
        ArrayList vals = new ArrayList(newValues);
        if (vals.size() == 0) {
            return vals;
        }
        ValueEditorJTextPane text = this;
        String textValue = "";
        Iterator iter = vals.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            iter.remove();
            if (val == null) continue;
            textValue = textValue + val.toString();
            if (!iter.hasNext()) continue;
            textValue = textValue + "\n";
        }
        text.setText(textValue);
        this.notifyValueEditorActionListeners("Set Values");
        return vals;
    }

    @Override
    public List getEditorValues() {
        ArrayList<String> vals = new ArrayList<String>();
        ValueEditorJTextPane text = this;
        String multiLineVal = text.getText();
        StringTokenizer strTok = new StringTokenizer(multiLineVal, "\n");
        while (strTok.hasMoreElements()) {
            String val = strTok.nextToken();
            vals.add(val);
        }
        return vals;
    }

    @Override
    public List copyEditorValues(ValueEditorInterface fromEditor) {
        List vals = fromEditor.getEditorValues();
        List remainingVals = this.setEditorValues(vals);
        return remainingVals;
    }

    @Override
    public void addValueEditorActionListener(ActionListener l) {
        if (this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.add(l);
    }

    @Override
    public void removeValueEditorActionListener(ActionListener l) {
        if (!this.valueEditorActionListeners.contains(l)) {
            return;
        }
        this.valueEditorActionListeners.remove(l);
    }

    public void notifyValueEditorActionListeners(String command) {
        ActionEvent event = new ActionEvent(this, 1001, command);
        for (ActionListener listener : this.valueEditorActionListeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.valueLabel.setEnabled(enable);
    }

    class InnerDocumentListener
    implements DocumentListener {
        InnerDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            ValueEditorJTextPane.this.notifyValueEditorActionListeners(event.toString());
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            ValueEditorJTextPane.this.notifyValueEditorActionListeners(event.toString());
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            ValueEditorJTextPane.this.notifyValueEditorActionListeners(event.toString());
        }
    }
}

