/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.SystemVariableInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.filters.FilterValueProviderPanelInterface;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

@SASScope
public class SystemPropertyValueSelectorPanel
extends JPanel
implements ListSelectionListener,
LayoutConstants,
FilterValueProviderPanelInterface {
    public static final String RB_KEY = "SystemPropertyValuePanel.";
    private DefaultTableModel tableModel;
    private TableView propertyTable;
    private DefaultTableCellRenderer descriptionRenderer;
    private boolean resizing;
    private List filterValueList;

    public SystemPropertyValueSelectorPanel() {
        this.createComponents();
        this.addListeners();
        this.filterValueList = new ArrayList(5);
    }

    public void setAvailableValues(List values) {
        this.filterValueList.clear();
        int numRows = this.tableModel.getRowCount();
        if (numRows > 0) {
            for (int k = numRows - 1; k >= 0; --k) {
                this.tableModel.removeRow(k);
            }
        }
        if (values != null) {
            int i = 0;
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String example;
                FilterValueInterface val;
                Object value = null;
                Object obj = iterator.next();
                if (!(obj instanceof FilterValueInterface) || !((value = (val = (FilterValueInterface)obj).getData()) instanceof SystemVariableInterface)) continue;
                SystemVariableInterface systemVariable = (SystemVariableInterface)value;
                String propertyName = systemVariable.getName();
                String description = systemVariable.getDescription();
                Object exampleValue = systemVariable.getExample();
                String string = example = exampleValue != null ? exampleValue.toString() : "";
                if (description == null) {
                    description = "";
                }
                if (propertyName == null || propertyName.length() <= 0) continue;
                this.tableModel.addRow(new String[]{propertyName, description, example});
                this.filterValueList.add(i, obj);
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SystemPropertyValueSelectorPanel.this.sizeTable(0);
                    SystemPropertyValueSelectorPanel.this.sizeTable(2);
                    SystemPropertyValueSelectorPanel.this.forceTableResize();
                }
            });
        }
    }

    protected void addListeners() {
        this.propertyTable.getRowModel().getSelectionModel().addListSelectionListener(this);
    }

    protected void createComponents() {
        LabelView instructionText = new LabelView(RB.getStringResource(RB_KEY, "instructions.txt"));
        instructionText.setPreferredSpanSize(new Dimension(306, -1));
        this.descriptionRenderer = new DefaultTableCellRenderer();
        this.descriptionRenderer.setWrapStyleWord(true);
        this.descriptionRenderer.setLineWrap(true);
        this.descriptionRenderer.setVerticalAlignment(1);
        DefaultTableCellRenderer propertyNameRenderer = new DefaultTableCellRenderer();
        propertyNameRenderer.setWrapStyleWord(true);
        propertyNameRenderer.setLineWrap(true);
        propertyNameRenderer.setVerticalAlignment(1);
        DefaultTableCellRenderer exampleRenderer = new DefaultTableCellRenderer();
        exampleRenderer.setWrapStyleWord(true);
        exampleRenderer.setLineWrap(true);
        exampleRenderer.setVerticalAlignment(1);
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn(RB.getStringResource(RB_KEY, "propertyName.txt"));
        this.tableModel.addColumn(RB.getStringResource(RB_KEY, "description.txt"));
        this.tableModel.addColumn(RB.getStringResource(RB_KEY, "example.txt"));
        this.propertyTable = new TableView(this.tableModel);
        this.propertyTable.setName("filterSystemPropertyValueTable");
        instructionText.setLabelFor(this.propertyTable);
        this.propertyTable.setCellRenderer(-1, 1, propertyNameRenderer);
        this.propertyTable.setCellRenderer(-1, 2, this.descriptionRenderer);
        this.propertyTable.setCellRenderer(-1, 3, exampleRenderer);
        this.propertyTable.setRowAutoResizeMode(6);
        this.propertyTable.getEditController().setEditEnabled(false);
        this.propertyTable.setColumnHeaderVisible(true);
        this.propertyTable.setRowHeaderVisible(false);
        this.propertyTable.setPopupMenuEnabled(false);
        this.propertyTable.getRowModel().getSelectionModel().setSelectionMode(0);
        this.propertyTable.getRowHeader().setCellsToSizeCount(-1);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        this.propertyTable.setColumnSelectionAllowed(false);
        this.propertyTable.setCellSelectionEnabled(false);
        this.propertyTable.setRowSelectionAllowed(true);
        this.propertyTable.setPreferredScrollableViewportSize(new Dimension(260, 110));
        this.propertyTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = SystemPropertyValueSelectorPanel.this.propertyTable.columnAtPoint(p);
                int hitRowIndex = SystemPropertyValueSelectorPanel.this.propertyTable.rowAtPoint(p);
                if (hitColumnIndex != -1 && hitRowIndex != -1) {
                    Object obj = SystemPropertyValueSelectorPanel.this.tableModel.getValueAt(SystemPropertyValueSelectorPanel.this.propertyTable.convertRowIndexToModel(hitRowIndex), SystemPropertyValueSelectorPanel.this.propertyTable.convertColumnIndexToModel(hitColumnIndex));
                    String tip = null;
                    if (obj != null) {
                        tip = obj.toString();
                    }
                    if (tip != null && tip.length() > 0) {
                        SystemPropertyValueSelectorPanel.this.propertyTable.setToolTipText(tip);
                    }
                }
            }
        });
        this.propertyTable.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SystemPropertyValueSelectorPanel.this.forceTableResize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        JScrollPane scroller = new JScrollPane(this.propertyTable);
        scroller.setVerticalScrollBarPolicy(20);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        this.setLayout(mainLayout);
        this.add(instructionText);
        this.add(scroller);
        this.propertyTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                TableColumn tc = SystemPropertyValueSelectorPanel.this.propertyTable.getColumnHeader().getResizingColumn();
                if (tc != null) {
                    SystemPropertyValueSelectorPanel.this.sizeTable(tc.getModelIndex());
                }
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }
        });
    }

    private void forceTableResize() {
        this.resizing = true;
        int width = this.propertyTable.getScrollPane().getViewport().getSize().width;
        int width1 = this.propertyTable.getColumnModel().getColumn(0).getPreferredWidth();
        int width2 = this.propertyTable.getColumnModel().getColumn(2).getPreferredWidth();
        int newWidth = width - width1 - width2;
        this.descriptionRenderer.setPreferredSpanSize(new Dimension(newWidth, -1));
        this.propertyTable.getColumnHeader().sizeColumnToFit(1);
        this.sizeTable(1);
    }

    private void sizeTable(int columnIndex) {
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.propertyTable.getCellRenderer(0, columnIndex);
        int newWidth = this.propertyTable.getColumnModel().getColumn(columnIndex).getWidth() - 3;
        if (renderer != null && newWidth != renderer.getPreferredSpanSize().width) {
            renderer.setPreferredSpanSize(new Dimension(newWidth, -1));
            this.propertyTable.getRowHeader().sizeRowsToFit(0, this.propertyTable.getRowCount() - 1, true);
        }
    }

    @Override
    public List getSelectedValues() {
        ArrayList values = new ArrayList();
        int selectedIndex = this.propertyTable.getSelectedRow();
        if (selectedIndex > -1) {
            values.add(this.filterValueList.get(selectedIndex));
        } else {
            values.add(null);
        }
        return values;
    }

    @Override
    public void setSelectedValues(List vals) {
        final List values = vals;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object obj;
                ListSelectionModel selectionModel = SystemPropertyValueSelectorPanel.this.propertyTable.getRowModel().getSelectionModel();
                selectionModel.clearSelection();
                if (values != null && values.size() > 0 && (obj = values.get(0)) != null && obj instanceof FilterValueInterface && ((FilterValueInterface)obj).getData() instanceof SystemVariableInterface) {
                    SystemVariableInterface systemVariable = (SystemVariableInterface)((FilterValueInterface)obj).getData();
                    String name = systemVariable.getName();
                    int rowCount = SystemPropertyValueSelectorPanel.this.propertyTable.getModel().getRowCount();
                    for (int i = 0; i < rowCount; ++i) {
                        Object propertyNameValue = SystemPropertyValueSelectorPanel.this.propertyTable.getValueAt(i, 0);
                        if (!propertyNameValue.equals(name)) continue;
                        SystemPropertyValueSelectorPanel.this.propertyTable.changeSelection(i, -1, false, false);
                        break;
                    }
                }
                SystemPropertyValueSelectorPanel.this.firePropertyChange("selectionChanged", null, SystemPropertyValueSelectorPanel.this.getSelectedValues());
            }
        });
    }

    @Override
    public boolean isSelectionComplete() {
        return this.propertyTable.getSelectedRowCount() > 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.firePropertyChange("selectionChanged", null, this.getSelectedValues());
        }
    }
}

