/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.swing.visuals.LabelView;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

class MultiLineToolTipUI
extends BasicToolTipUI {
    static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    static JToolTip tip;
    protected CellRendererPane rendererPane;
    private static LabelView labelView;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        tip = (JToolTip)c;
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        labelView.setBackground(c.getBackground());
        this.rendererPane.paintComponent(g, labelView, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        labelView = new LabelView(tipText);
        labelView.setPreferredSpanSize(new Dimension(425, -1));
        labelView.setBorder(BorderFactory.createEmptyBorder(0, 2, 1, 2));
        this.rendererPane.removeAll();
        this.rendererPane.add(labelView);
        labelView.setWrapStyleWord(true);
        Dimension dim = labelView.getPreferredSize();
        ++dim.height;
        ++dim.width;
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

