/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemListInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.LimitedTextField;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import com.sas.swing.visuals.dataselectors.format.FormatSelector;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.Resources;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class SimpleCalculatedItemEditPanel
extends BaseSwingSelectorPanel
implements LayoutConstants {
    private static final String RB_KEY = "SimpleCalculatedItemEditPanel.";
    private static Insets buttonInsets = new Insets(2, 7, 2, 7);
    private CalculatedItemListInterface list;
    private CalculatedItemInterface calculatedItem;
    protected LimitedTextField nameTF;
    protected JTextField descTF;
    protected JTextField formatTF;
    private DefaultListModel dataItemsModel;
    protected JList dataItemsList;
    protected JButton transferB;
    protected JTextArea expressionTA;
    protected JButton plusB;
    protected JButton minusB;
    protected JButton multB;
    protected JButton divB;
    protected JButton parensB;
    protected JButton selectFormatB;
    protected JButton clearFormatB;
    private String[][] dataItems;
    private String originalName;
    private String originalDesc;
    private String originalExpr;
    private String originalFormat;
    private boolean edit;

    public SimpleCalculatedItemEditPanel(CalculatedItemListInterface list, CalculatedItemInterface calculatedItem, boolean isRelational, String[][] dataItems, boolean edit) {
        this.list = list;
        this.calculatedItem = calculatedItem;
        this.dataItems = dataItems;
        this.edit = edit;
        this.createComponents();
        this.populateData(isRelational);
        this.addListeners();
    }

    private void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(3, 1, 5, 10, true, true, true);
        mainLayout.setRemainderRow(2);
        this.setLayout(mainLayout);
        JPanel topPanel = new JPanel(new AutoSizingGridLayout(2, 2, 5, 5, true, false, true));
        topPanel.add(new JLabel(RB.getStringResource(RB_KEY, "name.txt")));
        this.nameTF = new LimitedTextField();
        this.nameTF.setName("Name");
        try {
            this.nameTF.setMaxCharacters(this.list.getMaxLengthOfItemName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        topPanel.add(this.nameTF);
        topPanel.add(new JLabel(RB.getStringResource(RB_KEY, "desc.txt")));
        this.descTF = new JTextField();
        this.descTF.setName("Description");
        topPanel.add(this.descTF);
        this.add(topPanel);
        JPanel itemExprPanel = new JPanel();
        AutoSizingGridLayout itemExprPanelLayout = new AutoSizingGridLayout(4, 3, 5, 5, true, true, true);
        itemExprPanelLayout.setRemainderRow(2);
        itemExprPanelLayout.setColumnSpacePartitioner(new ProportionalSpacePartitioner(new double[]{0.5, -2.0, 0.5}));
        itemExprPanel.setLayout(itemExprPanelLayout);
        itemExprPanel.add(new JLabel(RB.getStringResource(RB_KEY, "availableDataItems.txt")));
        itemExprPanel.add(new JLabel(""));
        itemExprPanel.add(new JLabel(RB.getStringResource(RB_KEY, "expression.txt")));
        this.dataItemsModel = new DefaultListModel();
        this.dataItemsList = new JList(this.dataItemsModel);
        this.dataItemsList.setSelectionMode(0);
        this.dataItemsList.setVisibleRowCount(6);
        this.dataItemsList.setName("DataItems");
        JScrollPane dataItemsScrollPane = new JScrollPane(this.dataItemsList);
        itemExprPanel.add(dataItemsScrollPane);
        AutoSizingGridLayout moveButtonPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        moveButtonPanelLayout.setGridGravity(256);
        JPanel moveButtonPanel = new JPanel(moveButtonPanelLayout);
        this.transferB = new JButton(Resources.getImageIcon((String)RB.getStringResource(RB_KEY, "transfer.image")));
        this.transferB.setMargin(buttonInsets);
        this.transferB.setName("Transfer");
        moveButtonPanel.add(this.transferB);
        itemExprPanel.add(moveButtonPanel);
        this.expressionTA = new JTextArea();
        this.expressionTA.setLineWrap(true);
        itemExprPanel.add(new JScrollPane(this.expressionTA));
        itemExprPanel.add(new JLabel(""));
        itemExprPanel.add(new JLabel(""));
        JPanel arithButtonsPanel = new JPanel();
        GridLayout arithButtonsPanelLayout = new GridLayout(1, 0);
        arithButtonsPanelLayout.setHgap(5);
        arithButtonsPanel.setLayout(arithButtonsPanelLayout);
        this.plusB = new JButton(RB.getStringResource(RB_KEY, "plus.txt"));
        this.plusB.setName("Plus");
        this.plusB.setMargin(buttonInsets);
        this.minusB = new JButton(RB.getStringResource(RB_KEY, "minus.txt"));
        this.minusB.setName("Minus");
        this.minusB.setMargin(buttonInsets);
        this.multB = new JButton(RB.getStringResource(RB_KEY, "mult.txt"));
        this.multB.setName("Multiply");
        this.multB.setMargin(buttonInsets);
        this.divB = new JButton(RB.getStringResource(RB_KEY, "div.txt"));
        this.divB.setName("Divide");
        this.divB.setMargin(buttonInsets);
        this.parensB = new JButton(RB.getStringResource(RB_KEY, "parens.txt"));
        this.parensB.setName("Parens");
        this.parensB.setMargin(buttonInsets);
        arithButtonsPanel.add(this.plusB);
        arithButtonsPanel.add(this.minusB);
        arithButtonsPanel.add(this.multB);
        arithButtonsPanel.add(this.divB);
        arithButtonsPanel.add(this.parensB);
        AutoSizingGridLayout arithButtonsOuterPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, false);
        arithButtonsOuterPanelLayout.setGridGravity(256);
        JPanel arithButtonsOuterPanel = new JPanel(arithButtonsOuterPanelLayout);
        arithButtonsOuterPanel.add(arithButtonsPanel);
        itemExprPanel.add(arithButtonsOuterPanel);
        itemExprPanel.add(new JLabel(""));
        itemExprPanel.add(new JLabel(""));
        AutoSizingGridLayout hintsPanelLayout = new AutoSizingGridLayout(1, 1, 5, 5, false, false, true);
        hintsPanelLayout.setGridGravity(256);
        JPanel hintsPanel = new JPanel(hintsPanelLayout);
        LabelView hintsLabel = new LabelView("<html><em>" + RB.getStringResource(RB_KEY, "arithButtonHint.txt") + "</html></em>");
        hintsLabel.setHorizontalAlignment(0);
        hintsLabel.setWrapStyleWord(true);
        hintsLabel.setLineWrap(true);
        hintsPanel.add(hintsLabel);
        itemExprPanel.add(hintsPanel);
        Dimension size = itemExprPanel.getPreferredSize();
        itemExprPanel.setSize(556, (int)size.getHeight());
        this.add(itemExprPanel);
        JPanel formatPanel = new JPanel();
        AutoSizingGridLayout formatPanelLayout = new AutoSizingGridLayout(2, 4, 5, 5, false, false, true);
        formatPanelLayout.setRemainderColumn(2);
        formatPanel.setLayout(formatPanelLayout);
        formatPanel.add(new JLabel(RB.getStringResource(RB_KEY, "format.txt")));
        this.formatTF = new JTextField();
        this.formatTF.setName("Format");
        this.formatTF.setEditable(false);
        formatPanel.add(this.formatTF);
        this.selectFormatB = new JButton(RB.getStringResource(RB_KEY, "selectFormatButton.txt"));
        this.selectFormatB.setName("Select Format");
        formatPanel.add(this.selectFormatB);
        this.clearFormatB = new JButton(RB.getStringResource(RB_KEY, "clearFormatButton.txt"));
        this.clearFormatB.setName("Clear Format");
        formatPanel.add(this.clearFormatB);
        formatPanel.add(new JLabel());
        LabelView noteLabel = new LabelView("<html><em>" + RB.getStringResource(RB_KEY, "formatNote.txt") + "</html></em>");
        noteLabel.setWrapStyleWord(true);
        noteLabel.setLineWrap(true);
        formatPanel.add(noteLabel);
        formatPanel.add(new JLabel());
        formatPanel.add(new JLabel());
        this.add(formatPanel);
        this.setEnabledStateOfTransferButton();
    }

    private void populateData(boolean isRelational) {
        int numberOfDataItems = this.dataItems.length;
        for (int i = 0; i < numberOfDataItems; ++i) {
            ListElement le = new ListElement(this.dataItems[i][0], this.dataItems[i][1]);
            this.dataItemsModel.addElement(le);
        }
        if (this.edit) {
            this.originalName = this.calculatedItem.getLabel();
            this.originalDesc = this.calculatedItem.getDescription();
            this.originalExpr = this.calculatedItem.getExpression();
            this.originalFormat = this.calculatedItem.getFormat();
            this.nameTF.setText(this.originalName);
            this.descTF.setText(this.originalDesc);
            this.expressionTA.setText(this.originalExpr);
            this.formatTF.setText(this.originalFormat);
        } else {
            ArrayList<String> collection = new ArrayList<String>();
            for (CalculatedItemInterface ci : this.list.getCalculatedItemList()) {
                collection.add(ci.getLabel());
            }
            this.nameTF.setText(Util.getUniqueName(RB.getStringResource(RB_KEY, "newItemNameTemplate.fmt.txt"), RB.getStringResource(RB_KEY, isRelational ? "newColumnNameForTemplate.txt" : "newMeasureNameForTemplate.txt"), collection));
            this.nameTF.selectAll();
        }
    }

    private void addListeners() {
        this.dataItemsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SimpleCalculatedItemEditPanel.this.setEnabledStateOfTransferButton();
            }
        });
        this.dataItemsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListElement le = (ListElement)SimpleCalculatedItemEditPanel.this.dataItemsList.getSelectedValue();
                    SimpleCalculatedItemEditPanel.this.replaceSelectionAndSetFocusInExpressionArea(le.id);
                }
            }
        });
        this.transferB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListElement le = (ListElement)SimpleCalculatedItemEditPanel.this.dataItemsList.getSelectedValue();
                SimpleCalculatedItemEditPanel.this.replaceSelectionAndSetFocusInExpressionArea(le.id);
            }
        });
        MathButtonsListener mathButtonsListener = new MathButtonsListener();
        this.plusB.addActionListener(mathButtonsListener);
        this.minusB.addActionListener(mathButtonsListener);
        this.multB.addActionListener(mathButtonsListener);
        this.divB.addActionListener(mathButtonsListener);
        this.parensB.addActionListener(mathButtonsListener);
        this.selectFormatB.addActionListener(new FormatButtonListener(this));
        this.clearFormatB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleCalculatedItemEditPanel.this.formatTF.setText("");
            }
        });
    }

    @Override
    public void onApply() {
        this.setContentsValid(true);
        String nameInDialog = this.nameTF.getText().trim();
        if (!this.edit || !this.originalName.equals(nameInDialog)) {
            for (CalculatedItemInterface ci : this.list.getCalculatedItemList()) {
                if (!ci.getLabel().equals(nameInDialog)) continue;
                Message msg = new Message(RB.getResources(), "SimpleCalculatedItemEditPanel.Exsts.fmt.txt", (Object)nameInDialog);
                this.displayMessageAndSetStatusAndFocus(this, msg, this.nameTF);
                return;
            }
        }
        this.calculatedItem.setLabel(nameInDialog);
        this.calculatedItem.setExpression(this.expressionTA.getText());
        this.calculatedItem.setDescription(this.descTF.getText());
        String format = this.formatTF.getText().trim();
        if (format.length() > 0) {
            this.calculatedItem.setFormat(format);
        } else {
            this.calculatedItem.setFormat(null);
        }
        if (this.list.getLevelHasMembers()) {
            this.calculatedItem.setExpressionType(-2);
        } else {
            this.calculatedItem.setExpressionType(2);
        }
        if (this.calculatedItem.validate()) {
            return;
        }
        String errorMessage = this.calculatedItem.getLastInvalidCalculatedItemMessage();
        this.displayMessageAndSetStatusAndFocus(this, new Message(errorMessage), null);
    }

    @Override
    public void onCancel() {
        if (this.edit) {
            this.calculatedItem.setLabel(this.originalName);
            this.calculatedItem.setDescription(this.originalDesc);
            this.calculatedItem.setExpression(this.originalExpr);
            this.calculatedItem.setFormat(this.originalFormat);
        }
        super.onCancel();
    }

    private void setEnabledStateOfTransferButton() {
        this.transferB.setEnabled(this.dataItemsList.getSelectedIndex() >= 0);
    }

    private void displayMessageAndSetStatusAndFocus(Component component, Message message, Component focusComponent) {
        new JOptionPaneErrorHandler().handleError(component, message, null);
        this.contentsValid = false;
        if (focusComponent != null) {
            focusComponent.requestFocus();
        }
    }

    private void replaceSelectionAndSetFocusInExpressionArea(String insertText) {
        this.expressionTA.replaceSelection(insertText);
        this.expressionTA.requestFocus();
    }

    @SASScope
    private static class ListElement {
        String label;
        String id;

        ListElement(String label, String id) {
            this.label = label;
            this.id = id;
        }

        public String toString() {
            return this.label;
        }
    }

    @SASScope
    private static class Util {
        private Util() {
        }

        public static String getUniqueName(String template, String name, Collection collection) {
            if (Util.containsName(name, collection)) {
                return Util.getNumberedName(template, name, 2, collection);
            }
            return name;
        }

        private static String getNumberedName(String template, String name, int number, Collection strings) {
            String candidateName = MessageFormat.format(template, name, String.valueOf(number));
            if (Util.containsName(candidateName, strings)) {
                return Util.getNumberedName(template, name, number + 1, strings);
            }
            return candidateName;
        }

        private static boolean containsName(String name, Collection strings) {
            if (name == null || strings == null || strings.isEmpty()) {
                return false;
            }
            for (Object next : strings) {
                if (!next.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    @SASScope
    private class MathButtonsListener
    implements ActionListener {
        private MathButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton buttonPressed = (JButton)e.getSource();
            if (buttonPressed == SimpleCalculatedItemEditPanel.this.parensB) {
                String selectedText = SimpleCalculatedItemEditPanel.this.expressionTA.getSelectedText();
                SimpleCalculatedItemEditPanel.this.expressionTA.replaceSelection(selectedText == null ? "()" : "(" + selectedText + ")");
                int newCaretPos = SimpleCalculatedItemEditPanel.this.expressionTA.getCaretPosition() - 1;
                SimpleCalculatedItemEditPanel.this.expressionTA.setCaretPosition(newCaretPos);
                SimpleCalculatedItemEditPanel.this.expressionTA.requestFocus();
            } else {
                String insertString = null;
                if (buttonPressed == SimpleCalculatedItemEditPanel.this.plusB) {
                    insertString = " + ";
                } else if (buttonPressed == SimpleCalculatedItemEditPanel.this.minusB) {
                    insertString = " - ";
                } else if (buttonPressed == SimpleCalculatedItemEditPanel.this.divB) {
                    insertString = " / ";
                } else if (buttonPressed == SimpleCalculatedItemEditPanel.this.multB) {
                    insertString = " * ";
                }
                SimpleCalculatedItemEditPanel.this.replaceSelectionAndSetFocusInExpressionArea(insertString);
            }
        }
    }

    @SASScope
    private class FormatButtonListener
    implements ActionListener {
        Component component;

        FormatButtonListener(Component component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String format;
            FormatSelector formatSelector = new FormatSelector(this.component, SimpleCalculatedItemEditPanel.this.list.getFormatAdapter(), 8, SimpleCalculatedItemEditPanel.this.formatTF.getText());
            com.sas.swing.visuals.util.Util.centerOverWindow(formatSelector, this.component);
            formatSelector.setVisible(true);
            if (!formatSelector.wasCancelled() && (format = formatSelector.getFormatString()) != null) {
                SimpleCalculatedItemEditPanel.this.formatTF.setText(format);
            }
        }
    }
}

