/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.swing.visuals.dataselectors.calculateditems.BasicWindowUtil;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class AdvancedCalculatedItemSelector
extends JComponent
implements Accessible {
    public static final String RB_KEY = "AdvancedCalculatedItemSelector.";
    public static String EXPRESSION_TYPE = "expressionType";
    public static String EXPRESSION_TEXT = "expressionText";
    public static String EXPRESSION_NAME = "expressionName";
    public static String EXPRESSION_DESCRIPTION = "expressionDescription";
    String _nameLabelValue = RB.getStringResource("AdvancedCalculatedItemSelector.", "ExpressionNameLabel.txt");
    String _descriptionLabelValue = RB.getStringResource("AdvancedCalculatedItemSelector.", "ExpressionDescriptionLabel.txt");
    String _expressionLabelValue = RB.getStringResource("AdvancedCalculatedItemSelector.", "ExpressionTextLabel.txt");
    String _typeLabelValue = RB.getStringResource("AdvancedCalculatedItemSelector.", "ExpressionTypeLabel.txt");
    JLabel _nameLabel = null;
    JLabel _descriptionLabel = null;
    JLabel _expressionLabel = null;
    JLabel _typeLabel = null;
    String _expressionOkTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationSucceededMessageBoxTitle.txt");
    String _expressionOkMessage = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationSucceededMessage.txt");
    String _expressionInvalidTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationFailedMessageBoxTitle.txt");
    String _expressionWarningTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationWarningMessageBoxTitle.txt");
    ActionListener _validateActionListener = new ValidateActionListener();
    JTextField _nameField = null;
    JTextField _descriptionField = null;
    JPanel _userContentLabelPanel = null;
    JPanel _userContentFieldPanel = null;
    JComboBox _typeField = null;
    ExpressionBuilderPanel _expressionField = null;
    CalculatedItemInterface _itemModel = null;
    private boolean _userOverRidesTypeEnable = false;
    private boolean _userTypeEnabled = false;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", EXPRESSION_NAME}, {"Expert", "true"}}, {{"Name", EXPRESSION_DESCRIPTION}, {"Expert", "true"}}, {{"Name", EXPRESSION_TYPE}, {"Expert", "true"}}, {{"Name", EXPRESSION_TEXT}, {"Expert", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public AdvancedCalculatedItemSelector() {
        this.init();
    }

    void init() {
        this.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.setName("AdvancedCalculatedItemEditorPanel");
        this.setOpaque(false);
        this.setMinimumSize(new Dimension(300, 370));
        this._nameField = new JTextField();
        this._nameLabel = this.newMnemonicLabel(this._nameLabelValue);
        this._nameLabel.setLabelFor(this._nameField);
        this._descriptionField = new JTextField();
        this._descriptionLabel = this.newMnemonicLabel(this._descriptionLabelValue);
        this._descriptionLabel.setLabelFor(this._descriptionField);
        this._userContentLabelPanel = new JPanel();
        this._userContentLabelPanel.setPreferredSize(new Dimension(0, 0));
        this._userContentLabelPanel.setLayout(new FlowLayout(0, 4, 4));
        this._userContentFieldPanel = new JPanel();
        this._userContentFieldPanel.setPreferredSize(new Dimension(0, 0));
        this._userContentFieldPanel.setLayout(new FlowLayout(0, 4, 4));
        this._typeField = new JComboBox();
        this._typeLabel = this.newMnemonicLabel(this._typeLabelValue);
        this._typeLabel.setLabelFor(this._typeField);
        this._typeField.setEnabled(true);
        this._expressionField = new ExpressionBuilderPanel();
        this._expressionField.setOpaque(false);
        this._expressionField.setSingleButtonInsertInToolBar(false);
        this._expressionField.setSingleButtonInsertMode(true);
        this._expressionField.setSourceDescriptionEnabled(true);
        this._expressionField.setExpressionTextLabel(this._expressionLabelValue);
        this._expressionField.setValidationButtonVisible(true);
        int n = 0;
        this.add((Component)this._nameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._descriptionLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._descriptionField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._userContentLabelPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._userContentFieldPanel, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._typeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._typeField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
        this.add((Component)this._expressionField, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 4, 4, 4), 0, 0));
        ++n;
        this.setEnabled(true);
        InnerFocusListener myFocusListener = new InnerFocusListener();
        InnerActionListener myActionListener = new InnerActionListener();
        this._nameField.addFocusListener(myFocusListener);
        this._descriptionField.addFocusListener(myFocusListener);
        this._typeField.addActionListener(myActionListener);
        this._expressionField.addFocusListener((FocusListener)myFocusListener);
        this._expressionField.addValidateActionListener(this._validateActionListener);
    }

    public void commitChangesToField(JComponent source) {
        if (source == this._nameField) {
            this.checkForUserChangingName();
        } else if (source == this._descriptionField) {
            this.checkForUserChangingDescription();
        } else if (source == this._typeField) {
            this.checkForUserChangingType();
        } else if (source == this._expressionField) {
            this.checkForUserChangingExpression();
        } else if (this._expressionField.isAncestorOf((Component)source)) {
            this.checkForUserChangingExpression();
        }
    }

    public void setModel(CalculatedItemInterface model) {
        if (this._itemModel != model) {
            this._itemModel = model;
            this.refresh();
        }
    }

    public CalculatedItemInterface getModel() {
        return this._itemModel;
    }

    public void refresh() {
        if (this._itemModel == null) {
            this._nameField.setText("");
            this._descriptionField.setText("");
            this._typeField.removeAllItems();
            this._typeField.setSelectedIndex(-1);
            this._expressionField.setExpressionText("");
            this._expressionField.setOperationList(null);
            this._expressionField.setFunctionListTreeModel(null);
            this._expressionField.setDataSourceTreeModel(null);
            return;
        }
        this.checkForModelChangingName();
        this.checkForModelChangingDescription();
        this.checkForModelChangingExpression();
        this.checkForModelChangingType();
        this._expressionField.setOperationList(this._itemModel.getOperationList());
        this._expressionField.setFunctionListTreeModel((TreeModel)this._itemModel.getFunctionListTree());
        this._expressionField.setDataSourceTreeModel((TreeModel)this._itemModel.getDataSourceTree());
    }

    public String getExpressionName() {
        return this._nameField.getText();
    }

    void checkForModelChangingName() {
        String modelName = this._itemModel == null ? "" : this._itemModel.getLabel();
        String localName = this._nameField.getText();
        if (modelName == null) {
            modelName = "";
        }
        if (localName == null) {
            localName = "";
        }
        if (modelName.compareTo(localName) != 0) {
            this._nameField.setText(modelName);
            this.signalChange(EXPRESSION_NAME, localName, modelName);
        }
    }

    void checkForUserChangingName() {
        if (this._itemModel == null) {
            return;
        }
        String modelName = this._itemModel == null ? "" : this._itemModel.getLabel();
        String localName = this._nameField.getText();
        if (modelName == null) {
            modelName = "";
        }
        if (localName == null) {
            localName = "";
        }
        if (modelName.compareTo(localName) != 0) {
            this._itemModel.setLabel(localName);
            this.signalChange(EXPRESSION_NAME, modelName, localName);
        }
    }

    public String getExpressionDescription() {
        return this._descriptionField.getText();
    }

    void checkForModelChangingDescription() {
        String modelDescription = this._itemModel == null ? "" : this._itemModel.getDescription();
        String localDescription = this._descriptionField.getText();
        if (modelDescription == null) {
            modelDescription = "";
        }
        if (localDescription == null) {
            localDescription = "";
        }
        if (modelDescription.compareTo(localDescription) != 0) {
            this._descriptionField.setText(modelDescription);
            this.signalChange(EXPRESSION_DESCRIPTION, localDescription, modelDescription);
        }
    }

    void checkForUserChangingDescription() {
        if (this._itemModel == null) {
            return;
        }
        String modelDescription = this._itemModel == null ? "" : this._itemModel.getDescription();
        String localDescription = this._descriptionField.getText();
        if (modelDescription == null) {
            modelDescription = "";
        }
        if (localDescription == null) {
            localDescription = "";
        }
        if (modelDescription.compareTo(localDescription) != 0) {
            this._itemModel.setDescription(localDescription);
            this.signalChange(EXPRESSION_DESCRIPTION, modelDescription, localDescription);
        }
    }

    public String getExpressionText() {
        return this._descriptionField.getText();
    }

    void checkForModelChangingExpression() {
        String modelExpression = this._itemModel == null ? "" : this._itemModel.getExpression();
        String localExpression = this._expressionField.getExpressionText();
        if (modelExpression == null) {
            modelExpression = "";
        }
        if (localExpression == null) {
            localExpression = "";
        }
        if (modelExpression.compareTo(localExpression) != 0) {
            this._expressionField.setExpressionText(modelExpression);
            this.signalChange(EXPRESSION_TEXT, localExpression, modelExpression);
        }
    }

    void checkForUserChangingExpression() {
        if (this._itemModel == null) {
            return;
        }
        String modelExpression = this._itemModel.getExpression();
        String localExpression = this._expressionField.getExpressionText();
        if (modelExpression == null) {
            modelExpression = "";
        }
        if (localExpression == null) {
            localExpression = "";
        }
        if (modelExpression.compareTo(localExpression) != 0) {
            this._itemModel.setExpression(localExpression);
            this.signalChange(EXPRESSION_TEXT, modelExpression, localExpression);
        }
    }

    public int getExpressionType() {
        expressionNameAndType localTypeSelected = (expressionNameAndType)this._typeField.getSelectedItem();
        return localTypeSelected != null ? localTypeSelected._type : 0;
    }

    void checkForUserChangingType() {
        int localType;
        if (this._itemModel == null) {
            return;
        }
        int modelType = this._itemModel.getExpressionType();
        expressionNameAndType localTypeSelected = (expressionNameAndType)this._typeField.getSelectedItem();
        int n = localType = localTypeSelected != null ? localTypeSelected._type : 0;
        if (localType != modelType) {
            this._itemModel.setExpressionType(localType);
            this.signalChange(EXPRESSION_TYPE, new Integer(modelType), new Integer(localType));
            this._expressionField.setOperationList(this._itemModel.getOperationList());
            this._expressionField.setFunctionListTreeModel((TreeModel)this._itemModel.getFunctionListTree());
            this._expressionField.setDataSourceTreeModel((TreeModel)this._itemModel.getDataSourceTree());
        }
    }

    void checkForModelChangingType() {
        expressionNameAndType item;
        int i;
        boolean updateTypeSelection;
        if (this._itemModel == null) {
            this._typeField.removeAllItems();
            return;
        }
        int[] modelTypeValues = this._itemModel.getValidExpressionTypeValues();
        String[] modelTypeNames = this._itemModel.getValidExpressionTypeNames();
        boolean updateTypeList = false;
        if (modelTypeValues.length != this._typeField.getItemCount()) {
            updateTypeList = true;
        } else {
            for (int i2 = 0; i2 < modelTypeValues.length; ++i2) {
                expressionNameAndType item2 = (expressionNameAndType)this._typeField.getItemAt(i2);
                if (modelTypeValues[i2] == item2._type && modelTypeNames[i2].compareTo(item2._name) == 0) continue;
                updateTypeList = true;
                break;
            }
        }
        int modelType = this._itemModel.getExpressionType();
        expressionNameAndType localTypeSelected = (expressionNameAndType)this._typeField.getSelectedItem();
        int localType = localTypeSelected != null ? localTypeSelected._type : 0;
        boolean bl = updateTypeSelection = updateTypeList || localType != modelType;
        if (updateTypeList) {
            this._typeField.removeAllItems();
            for (i = 0; i < modelTypeValues.length; ++i) {
                item = new expressionNameAndType(modelTypeNames[i], modelTypeValues[i]);
                this._typeField.addItem(item);
            }
        }
        if (updateTypeSelection) {
            for (i = 0; i < this._typeField.getItemCount(); ++i) {
                item = (expressionNameAndType)this._typeField.getItemAt(i);
                if (item._type != modelType) continue;
                this._typeField.setSelectedIndex(i);
                break;
            }
        }
        if (this._typeField.getSelectedIndex() == -1 && modelTypeValues.length > 0) {
            this._typeField.setSelectedIndex(0);
            expressionNameAndType item3 = (expressionNameAndType)this._typeField.getItemAt(0);
            this._itemModel.setExpressionType(item3._type);
        }
        boolean enableType = this._typeField.isEnabled();
        if (modelTypeValues.length > 1) {
            if (!this._typeField.isEnabled()) {
                enableType = this._userOverRidesTypeEnable ? this._userTypeEnabled : true;
            }
        } else if (modelTypeValues.length <= 1 && this._typeField.isEnabled()) {
            enableType = false;
        }
        if (this._typeField.isEnabled() != enableType) {
            this._typeField.setEnabled(enableType);
        }
        if (modelType != localType) {
            this.signalChange(EXPRESSION_TYPE, new Integer(localType), new Integer(modelType));
            this._expressionField.setOperationList(this._itemModel.getOperationList());
            this._expressionField.setFunctionListTreeModel((TreeModel)this._itemModel.getFunctionListTree());
            this._expressionField.setDataSourceTreeModel((TreeModel)this._itemModel.getDataSourceTree());
        }
    }

    public ExpressionBuilderPanel getExpressionBuilderPanel() {
        return this._expressionField;
    }

    private void signalChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    public void setNameVisible(boolean visible) {
        this._nameLabel.setVisible(visible);
        this._nameField.setVisible(visible);
    }

    public void setDescriptionVisible(boolean visible) {
        this._descriptionLabel.setVisible(visible);
        this._descriptionField.setVisible(visible);
    }

    public void setTypeVisible(boolean visible) {
        this._typeLabel.setVisible(visible);
        this._typeField.setVisible(visible);
    }

    public void setNameEnabled(boolean enable) {
        this._nameField.setEnabled(enable);
    }

    public void setDescriptionEnabled(boolean enable) {
        this._descriptionField.setEnabled(enable);
    }

    public void setTypeEnabled(boolean enable) {
        this._userOverRidesTypeEnable = true;
        this._userTypeEnabled = enable;
        if (this._typeField.isEnabled() != enable) {
            this._typeField.setEnabled(enable);
        }
    }

    public void setNameLabel(String label) {
        this._nameLabelValue = label;
        this.setMnemonicLabel(this._nameLabel, label);
    }

    public void setDescriptionLabel(String label) {
        this._descriptionLabelValue = label;
        this.setMnemonicLabel(this._descriptionLabel, label);
    }

    public void setExpressionLabel(String label) {
        this._expressionLabelValue = label;
        this.setMnemonicLabel(this._expressionLabel, label);
    }

    public void setTypeLabel(String label) {
        this._typeLabelValue = label;
        this.setMnemonicLabel(this._typeLabel, label);
    }

    public String getDefaultHelpProduct() {
        return this._expressionField.getDefaultHelpProduct();
    }

    public String getDefaultHelpMapID() {
        return this._expressionField.getDefaultHelpMapID();
    }

    public void setCanChangeType(boolean enable) {
    }

    public JLabel newMnemonicLabel(String item) {
        JLabel aLabel = new JLabel(item);
        this.setMnemonicLabel(aLabel, item);
        return aLabel;
    }

    public void setMnemonicLabel(JLabel aLabel, String item) {
        int index;
        if (aLabel == null) {
            return;
        }
        if (item == null) {
            return;
        }
        String text = Util.getLabelWithoutMnemonic(item);
        if (text != null) {
            aLabel.setText(text);
        }
        if ((index = Util.getDisplayedMnemonicIndex(item)) > -1) {
            int mnemonic = Util.getDisplayedMnemonic(item);
            aLabel.setDisplayedMnemonic(mnemonic);
            aLabel.setDisplayedMnemonicIndex(index);
        }
    }

    public boolean isValidationButtonVisible() {
        return this._expressionField.isValidationButtonVisible();
    }

    public void setValidationButtonVisible(boolean visible) {
        this._expressionField.setValidationButtonVisible(visible);
    }

    public ActionListener getValidateActionListener() {
        return this._validateActionListener;
    }

    public void setValidateActionListener(ActionListener listener) {
        this._expressionField.removeValidateActionListener(this._validateActionListener);
        this._validateActionListener = listener;
        if (listener != null) {
            this._expressionField.addValidateActionListener(this._validateActionListener);
        }
    }

    @Override
    @SASScope
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPanel();
        }
        return this.accessibleContext;
    }

    public JPanel getUserContentLabelPanel() {
        return this._userContentLabelPanel;
    }

    public JPanel getUserContentFieldPanel() {
        return this._userContentFieldPanel;
    }

    @SASScope
    private class ValidateActionListener
    implements ActionListener {
        private ValidateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (AdvancedCalculatedItemSelector.this._itemModel != null) {
                AdvancedCalculatedItemSelector parent = AdvancedCalculatedItemSelector.this;
                Throwable thrownFound = null;
                String messageFound = null;
                boolean validText = false;
                BasicWindowUtil.busyOn(AdvancedCalculatedItemSelector.this);
                try {
                    validText = AdvancedCalculatedItemSelector.this._itemModel.validateCalculation();
                    messageFound = AdvancedCalculatedItemSelector.this._itemModel.getLastInvalidCalculatedItemMessage();
                    thrownFound = AdvancedCalculatedItemSelector.this._itemModel.getLastInvalidExpressionException();
                }
                catch (Throwable e) {
                    thrownFound = e;
                }
                BasicWindowUtil.busyOff(AdvancedCalculatedItemSelector.this);
                if (!validText || messageFound != null || thrownFound != null) {
                    List list = BasicWindowUtil.exceptionToStringArray(messageFound, thrownFound);
                    String message = "";
                    for (int i = 0; i < list.size(); ++i) {
                        message = message + list.get(i) + (i + 1 < list.size() ? "\n" : "");
                    }
                    Component wrappedText = BasicWindowUtil.stringToWrappingTextComponent(message, 600);
                    if (!validText) {
                        JOptionPane.showMessageDialog(parent, wrappedText, AdvancedCalculatedItemSelector.this._expressionInvalidTitle, 0);
                    } else {
                        JOptionPane.showMessageDialog(parent, wrappedText, AdvancedCalculatedItemSelector.this._expressionWarningTitle, 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(parent, AdvancedCalculatedItemSelector.this._expressionOkMessage, AdvancedCalculatedItemSelector.this._expressionOkTitle, 1);
                }
            }
        }
    }

    @SASScope
    private class InnerFocusListener
    implements FocusListener {
        private InnerFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Object source = focusEvent.getSource();
            if (source == AdvancedCalculatedItemSelector.this._nameField || source == AdvancedCalculatedItemSelector.this._descriptionField || source == AdvancedCalculatedItemSelector.this._expressionField) {
                AdvancedCalculatedItemSelector.this.commitChangesToField((JComponent)source);
            } else {
                System.err.println("Uncaught Focus Lost event source=[" + source + "], event=" + focusEvent);
            }
        }
    }

    @SASScope
    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object source = actionEvent.getSource();
            if (source == AdvancedCalculatedItemSelector.this._typeField) {
                AdvancedCalculatedItemSelector.this.checkForUserChangingType();
            } else {
                System.err.println("Uncaught Action event source=[" + source + "], event=" + actionEvent);
            }
        }
    }

    @SASScope
    private class expressionNameAndType {
        public String _name = null;
        public int _type = 0;

        expressionNameAndType(String name, int type) {
            this._name = name;
            this._type = type;
        }

        public String toString() {
            return this._name;
        }
    }

    @SASScope
    protected class AccessibleJPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleJPanel() {
            super(AdvancedCalculatedItemSelector.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

