/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.calculateditems;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.swing.util.EnableHelpUtil;
import com.sas.swing.visuals.dataselectors.calculateditems.AdvancedCalculatedItemEditorInterface;
import com.sas.swing.visuals.dataselectors.calculateditems.AdvancedCalculatedItemSelector;
import com.sas.swing.visuals.dataselectors.calculateditems.BasicWindowUtil;
import com.sas.swing.visuals.dataselectors.calculateditems.MinimumResizeListener;
import com.sas.swing.visuals.dataselectors.calculateditems.RB;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

@SASScope(value="ALL")
public class AdvancedCalculatedItemEditDialog
extends JDialog
implements AdvancedCalculatedItemEditorInterface {
    public static final String RB_KEY = "AdvancedCalculatedItemEditDialog.";
    protected AdvancedCalculatedItemSelector m_advCalcPanel = null;
    protected CalculatedItemInterface m_calcItem = null;
    protected JButton bOK;
    protected JButton bCancel;
    protected JButton bHelp;
    protected boolean m_success = false;
    protected SymWindow aSymWindow;
    protected SymAction actionListener;
    protected JLabel m_existingPane = null;
    protected JPanel m_newPanel = null;
    protected String docsetId;
    protected int m_spacingDialogBoxMargin = 11;
    protected int m_spacingBetweenButtons = 6;
    protected int m_spacingLastInGroupBox = 11;
    protected String m_labelTitle = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "Title.txt");
    protected String m_labelName = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "AliasLabel.txt");
    protected String m_labelDescription = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "DescriptionLabel.txt");
    protected String m_labelExpression = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "ExpressionLabel.txt");
    protected String m_labelOkButton = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "Button.OK.txt");
    protected String m_labelCancelButton = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "Button.Cancel.txt");
    protected String m_labelHelpButton = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "Button.Help.txt");
    protected String m_errorMessageDialogTitle = RB.getStringResource("FilterItemEditorAdapter.Title.txt");
    protected String m_errorMessageNameRequired = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "ErrorMessage.NameRequired.txt");
    protected String m_errorMessageSyntaxInvalid = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "ErrorMessage.InvalidExpression.txt");
    protected String m_warningMessageIsItOkToSave = RB.getStringResource("AdvancedCalculatedItemEditDialog.", "WarningMessage.IsItOkToSave.txt");
    protected String _expressionOkTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationSucceededMessageBoxTitle.txt");
    protected String _expressionOkMessage = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationSucceededMessage.txt");
    protected String _expressionInvalidTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationFailedMessageBoxTitle.txt");
    protected String _expressionWarningTitle = RB.getStringResource("AdvancedCalculatedItemSelector.", "ValidationWarningMessageBoxTitle.txt");
    public boolean _reportToStdErr = false;
    protected MinimumResizeListener m_resizeListener = null;
    protected boolean _userSetMaxOutputObservations = false;
    protected int _maxMaxOutputObservations = -1;
    protected boolean _canSaveInvalidExpressions = true;
    protected boolean _isExpressionValid = false;

    public AdvancedCalculatedItemEditDialog(Frame parent, boolean modal, CalculatedItemInterface calcItem, String docsetId) {
        this(parent, modal);
        this.init(parent, modal, calcItem, docsetId);
    }

    protected AdvancedCalculatedItemEditDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    protected void init(Frame parent, boolean modal, CalculatedItemInterface calcItem, String docsetId) {
        this.docsetId = docsetId;
        this.m_advCalcPanel = new AdvancedCalculatedItemSelector();
        this.m_advCalcPanel.setNameLabel(this.m_labelName);
        this.m_advCalcPanel.setDescriptionLabel(this.m_labelDescription);
        this.m_advCalcPanel.setExpressionLabel(this.m_labelExpression);
        this.setCalculatedItem(calcItem);
        this.bOK = this.newNmemonicButton(this.m_labelOkButton);
        this.bCancel = this.newNmemonicButton(this.m_labelCancelButton);
        this.bHelp = this.newNmemonicButton(this.m_labelHelpButton);
        this._layoutWidgets();
        this.addAllListeners();
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.bOK);
    }

    protected JButton newNmemonicButton(String item) {
        JButton button = new JButton(Util.getLabelWithoutMnemonic(item));
        int index = Util.getDisplayedMnemonicIndex(item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic(item);
            button.setMnemonic(mnemonic);
            button.setDisplayedMnemonicIndex(index);
        }
        return button;
    }

    public void setNameLabel(String label) {
        this.m_labelName = label;
        this.m_advCalcPanel.setNameLabel(label);
    }

    @Override
    public void dispose() {
        this.removeAllListeners();
        super.dispose();
    }

    public void addAllListeners() {
        this.aSymWindow = new SymWindow();
        this.addWindowListener(this.aSymWindow);
        this.actionListener = new SymAction(this);
        this.bOK.addActionListener(this.actionListener);
        this.bCancel.addActionListener(this.actionListener);
        this.m_resizeListener = new MinimumResizeListener(this);
        ActionListener validateListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (AdvancedCalculatedItemEditDialog.this.m_calcItem != null) {
                    AdvancedCalculatedItemEditDialog parent = AdvancedCalculatedItemEditDialog.this;
                    Exception exceptionFound = null;
                    String messageFound = null;
                    boolean validText = false;
                    BasicWindowUtil.busyOn(AdvancedCalculatedItemEditDialog.this);
                    try {
                        AdvancedCalculatedItemEditDialog.this._isExpressionValid = validText = AdvancedCalculatedItemEditDialog.this.m_calcItem.validateCalculation();
                        messageFound = AdvancedCalculatedItemEditDialog.this.m_calcItem.getLastInvalidCalculatedItemMessage();
                        exceptionFound = AdvancedCalculatedItemEditDialog.this.m_calcItem.getLastInvalidExpressionException();
                    }
                    catch (Exception e) {
                        exceptionFound = e;
                    }
                    BasicWindowUtil.busyOff(AdvancedCalculatedItemEditDialog.this);
                    if (!validText || exceptionFound != null || messageFound != null) {
                        if (!validText && !AdvancedCalculatedItemEditDialog.this.isSaveInvalidExpressionsEnabled()) {
                            if (exceptionFound != null) {
                                AdvancedCalculatedItemEditDialog.this.reportAndDisplayError(exceptionFound, AdvancedCalculatedItemEditDialog.this._expressionInvalidTitle);
                            } else {
                                AdvancedCalculatedItemEditDialog.this.reportAndDisplayError(messageFound, AdvancedCalculatedItemEditDialog.this._expressionInvalidTitle);
                            }
                        } else if (exceptionFound != null) {
                            AdvancedCalculatedItemEditDialog.this.reportAndDisplayError(exceptionFound, AdvancedCalculatedItemEditDialog.this._expressionWarningTitle, 2);
                        } else {
                            AdvancedCalculatedItemEditDialog.this.reportAndDisplayError(messageFound, AdvancedCalculatedItemEditDialog.this._expressionWarningTitle, 2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(parent, AdvancedCalculatedItemEditDialog.this._expressionOkMessage, AdvancedCalculatedItemEditDialog.this._expressionOkTitle, 1);
                    }
                }
            }
        };
        this.m_advCalcPanel.setValidateActionListener(validateListener);
    }

    public void removeAllListeners() {
        this.removeAll();
        if (this.aSymWindow != null) {
            this.removeWindowListener(this.aSymWindow);
            this.aSymWindow = null;
        }
        if (this.actionListener != null) {
            this.bOK.removeActionListener(this.actionListener);
            this.bCancel.removeActionListener(this.actionListener);
            this.actionListener = null;
        }
        if (this.m_resizeListener != null) {
            this.m_resizeListener.dispose();
            this.m_resizeListener = null;
        }
    }

    protected void _layoutNewPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_newPanel.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(this.m_spacingDialogBoxMargin, this.m_spacingDialogBoxMargin, 0, this.m_spacingDialogBoxMargin);
        gridBagLayout.setConstraints(this.m_advCalcPanel, gbc);
        this.m_newPanel.add(this.m_advCalcPanel);
        JButton[] buttonArray = new JButton[]{this.bOK, this.bCancel, this.bHelp};
        BasicWindowUtil.makeButtonsUniform(buttonArray);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, this.m_spacingBetweenButtons, this.m_spacingLastInGroupBox));
        buttonPanel.add(this.bOK);
        buttonPanel.add(this.bCancel);
        buttonPanel.add(this.bHelp);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, this.m_spacingDialogBoxMargin, 0, this.m_spacingDialogBoxMargin);
        gridBagLayout.setConstraints(buttonPanel, gbc);
        this.m_newPanel.add(buttonPanel);
        this.pack();
    }

    protected void _layoutWidgets() {
        block2: {
            this.setTitle(this.m_labelTitle);
            BasicWindowUtil.busyOn(this);
            try {
                this.m_newPanel = new JPanel();
                this._layoutNewPanel();
                this.setContentPane(this.m_newPanel);
            }
            catch (Throwable t) {
                BasicWindowUtil.busyOff(this);
                if (this.m_calcItem == null) break block2;
                this.reportInternalError(t);
            }
        }
        this.setupHelpForCalcItemDialog();
        BasicWindowUtil.busyOff(this);
        this.addKeyListeners(this, new KeyHandler());
        this.pack();
    }

    protected void addKeyListeners(Container container, KeyHandler keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].addKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            this.addKeyListeners((Container)components[index], keyHandler);
        }
    }

    @Override
    public int getReturnValue() {
        if (this.m_success) {
            return 1;
        }
        return 2;
    }

    @Override
    public CalculatedItemInterface getCalculatedItem() {
        this.m_calcItem = this.m_advCalcPanel.getModel();
        return this.m_calcItem;
    }

    @Override
    public void setTypeEnabled(boolean enable) {
        boolean enabled = this.m_advCalcPanel.isEnabled();
        if (enabled == enable) {
            return;
        }
        this.m_advCalcPanel.setTypeEnabled(enable);
    }

    @Override
    public void setCalculatedItem(CalculatedItemInterface calcItem) {
        if (this._userSetMaxOutputObservations && calcItem != null) {
            calcItem.setMaxOutputObservations(this._maxMaxOutputObservations);
        }
        this.m_calcItem = calcItem;
        this.m_advCalcPanel.setModel(calcItem);
    }

    public String getRawText() {
        return this.m_advCalcPanel.getModel().getExpression();
    }

    protected void Dialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    protected void bOK_Action(ActionEvent event) {
        this._isExpressionValid = false;
        CalculatedItemInterface itemModel = this.m_advCalcPanel.getModel();
        if (itemModel == null) {
            return;
        }
        String name = itemModel.getLabel();
        if (name == null || name.trim().length() < 1) {
            this.reportAndDisplayError(this.m_errorMessageNameRequired, null, 2);
            return;
        }
        boolean valid = itemModel.validate(false);
        String msg = itemModel.getLastInvalidCalculatedItemMessage();
        if (!valid) {
            this.reportAndDisplayError(msg);
            return;
        }
        boolean okToContinue = true;
        AdvancedCalculatedItemEditDialog parent = this;
        Exception exceptionFound = null;
        String messageFound = null;
        boolean validText = false;
        BasicWindowUtil.busyOn(this);
        try {
            this._isExpressionValid = validText = this.m_calcItem.validate();
            messageFound = this.m_calcItem.getLastInvalidCalculatedItemMessage();
            exceptionFound = this.m_calcItem.getLastInvalidExpressionException();
        }
        catch (Exception e) {
            exceptionFound = e;
        }
        BasicWindowUtil.busyOff(this);
        if (!validText || messageFound != null || exceptionFound != null) {
            if (!this.isSaveInvalidExpressionsEnabled() && !validText) {
                if (exceptionFound != null) {
                    this.reportAndDisplayError(exceptionFound, this._expressionInvalidTitle);
                } else {
                    this.reportAndDisplayError(messageFound, this._expressionInvalidTitle);
                }
                okToContinue = false;
            } else {
                List list = BasicWindowUtil.exceptionToStringArray(messageFound, exceptionFound);
                list.add("");
                list.add(this.m_warningMessageIsItOkToSave);
                String msgout = "";
                for (int i = 0; i < list.size(); ++i) {
                    msgout = msgout + list.get(i) + "\n";
                }
                List errorList = BasicWindowUtil.listToWrappingTextComponents(list, 600);
                okToContinue = !validText ? this.reportAndCheckOkToContinue(msgout, this._expressionInvalidTitle) : this.reportAndCheckOkToContinue(msgout, this._expressionWarningTitle);
            }
        }
        if (!okToContinue) {
            return;
        }
        this.m_success = true;
        this.dispose();
    }

    protected void bCancel_Action(ActionEvent event) {
        this.m_success = false;
        this.dispose();
    }

    protected void setupHelpForCalcItemDialog() {
        this.bHelp.setVisible(false);
        if (this.getDocsetId() == null) {
            return;
        }
        String helpMapID = null;
        try {
            helpMapID = this.m_advCalcPanel.getDefaultHelpMapID();
            String helpSetProdName = this.m_advCalcPanel.getDefaultHelpProduct();
            EnableHelpUtil.enableHelpOnClick(this.bHelp, helpSetProdName, helpMapID, null);
            EnableHelpUtil.enableHelpKey(this.getContentPane(), helpSetProdName, helpMapID, null);
            this.bHelp.setVisible(true);
        }
        catch (Throwable e) {
            System.err.println("Could not find component help");
            this.reportInternalError(e);
            return;
        }
    }

    public String getDocsetId() {
        return this.docsetId;
    }

    public void setDocsetId(String docsetId) {
        this.docsetId = docsetId;
    }

    @Override
    public boolean reportAndCheckOkToContinue(String message) {
        return this.reportAndCheckOkToContinue(message, null);
    }

    @Override
    public boolean reportAndCheckOkToContinue(String message, String title) {
        if (title == null) {
            title = this.m_errorMessageDialogTitle;
        }
        Component wrappedText = BasicWindowUtil.stringToWrappingTextComponent(message, 600);
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(wrappedText);
        list.add(new JSeparator());
        int result = JOptionPane.showConfirmDialog(this, list.toArray(), title, 2, 2);
        boolean ok = result == 0;
        return ok;
    }

    @Override
    public void reportAndDisplayError(String message) {
        this.reportAndDisplayError(message, null);
    }

    @Override
    public void reportAndDisplayError(String message, String title) {
        this.reportAndDisplayError(message, null, 0);
    }

    public void reportAndDisplayError(String message, String title, int messageType) {
        if (title == null) {
            title = this.m_errorMessageDialogTitle;
        }
        if (this._reportToStdErr) {
            this.reportInternalError("Error - " + message);
        }
        Component wrappedText = BasicWindowUtil.stringToWrappingTextComponent(message, 600);
        JOptionPane.showMessageDialog(this, wrappedText, title, messageType);
    }

    @Override
    public void reportAndDisplayError(Exception e) {
        this.reportAndDisplayError(e, null);
    }

    @Override
    public void reportAndDisplayError(Exception e, String title) {
        this.reportAndDisplayError(e, title, 0);
    }

    public void reportAndDisplayError(Exception e, String title, int messageType) {
        if (title == null) {
            title = this.m_errorMessageDialogTitle;
        }
        List list = BasicWindowUtil.exceptionToStringArray(null, e);
        String message = "";
        for (int i = 0; i < list.size(); ++i) {
            message = message + list.get(i) + (i + 1 < list.size() ? "\n" : "");
        }
        if (this._reportToStdErr) {
            this.reportInternalError(e);
        }
        this.reportAndDisplayError(message, title, messageType);
    }

    public void reportInternalError(String message) {
        System.err.println(message);
    }

    public void reportInternalError(Throwable t) {
        t.printStackTrace();
    }

    @Override
    public boolean isValidationButtonVisible() {
        return this.m_advCalcPanel.isValidationButtonVisible();
    }

    @Override
    public void setValidationButtonVisible(boolean visible) {
        this.m_advCalcPanel.setValidationButtonVisible(visible);
    }

    @Override
    public ActionListener getValidateActionListener() {
        return this.m_advCalcPanel.getValidateActionListener();
    }

    @Override
    public void setValidateActionListener(ActionListener listener) {
        this.m_advCalcPanel.setValidateActionListener(listener);
    }

    @Override
    public int getMaxOutputObservations() {
        if (!this._userSetMaxOutputObservations && this.m_calcItem != null) {
            return this.m_calcItem.getMaxOutputObservations();
        }
        return this._maxMaxOutputObservations;
    }

    @Override
    public void setMaxOutputObservations(int max) {
        this._maxMaxOutputObservations = max;
        this._userSetMaxOutputObservations = true;
        if (this.m_calcItem != null) {
            this.m_calcItem.setMaxOutputObservations(max);
        }
    }

    @Override
    public boolean isSaveInvalidExpressionsEnabled() {
        return this._canSaveInvalidExpressions;
    }

    @Override
    public void setSaveInvalidExpressionsEnabled(boolean enable) {
        this._canSaveInvalidExpressions = enable;
    }

    @Override
    public boolean isExpressionValid() {
        return this._isExpressionValid;
    }

    @SASScope
    protected class SymWindow
    extends WindowAdapter {
        protected SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == AdvancedCalculatedItemEditDialog.this) {
                AdvancedCalculatedItemEditDialog.this.Dialog1_WindowClosing(event);
            }
        }
    }

    @SASScope
    protected class SymAction
    implements ActionListener {
        AdvancedCalculatedItemEditDialog _parent;

        public SymAction(AdvancedCalculatedItemEditDialog parent) {
            this._parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == this._parent.bOK) {
                this._parent.bOK_Action(event);
            } else if (object == this._parent.bCancel) {
                this._parent.bCancel_Action(event);
            }
        }
    }

    @SASScope
    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            Object source = event.getSource();
            if (event.getKeyCode() == 27) {
                AdvancedCalculatedItemEditDialog.this.bCancel_Action(null);
            } else if (event.getKeyCode() == 10) {
                AbstractButton button;
                if (source instanceof JComponent) {
                    AdvancedCalculatedItemEditDialog.this.m_advCalcPanel.commitChangesToField((JComponent)source);
                }
                if (source instanceof AbstractButton && (button = (AbstractButton)event.getSource()) != AdvancedCalculatedItemEditDialog.this.bOK && button.hasFocus()) {
                    button.doClick();
                    event.consume();
                }
            }
        }
    }
}

