/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dataselectors.RB;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

@SASScope(value="ALL")
public class Util {
    public static final String RB_KEY = "Util.";
    private static String _rankStatusWithTies = RB.getStringResource("Util.", "localizedRankStatusWithTies.fmt.txt");
    private static String _rankStatusWithoutTies = RB.getStringResource("Util.", "localizedRankStatusWithoutTies.fmt.txt");
    private static String _rankStatusByRankNameWithTies = RB.getStringResource("Util.", "localizedRankStatusByRankNameWithTies.fmt.txt");
    private static String _rankStatusByRankNameWithoutTies = RB.getStringResource("Util.", "localizedRankStatusByRankNameWithoutTies.fmt.txt");
    private static String _rankStatusByRankNameTiesDoNotApply = RB.getStringResource("Util.", "localizedRankStatusByRankNameTiesDoNotApply.fmt.txt");
    private static String _basedOnMeasureWithWhereClauses = RB.getStringResource("Util.", "localizedRankBasedOnMeasureWithWhereClauses.fmt.txt");
    private static String _basedOnMeasureWhereClause = RB.getStringResource("Util.", "localizedRankBasedOnMeasureWhereClause.fmt.txt");
    private static CommonLoggerInterface logger = LoggerRepository2.getLogger((String)Util.class.getPackage().getName(), (LoggerFactoryInterface)new Log4JFactory2());
    private static final int BOTTOM_MASK = 32;
    private static final int SUM_MASK = 8;
    private static final int PERCENT_MASK = 16;
    private static final int BASEDON_MASK = 4;
    private static final int NOTIES_MASK = 1;
    private static final int TIES_MASK = 2;
    private static final Map rankingDescriptionsMap = new HashMap();

    private static synchronized void setupRankingDescriptionsMap() {
        if (rankingDescriptionsMap.size() == 0) {
            rankingDescriptionsMap.put(new Integer(0), "Util.localizedRankStatus.top.count.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(1), "Util.localizedRankStatus.top.count.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(2), "Util.localizedRankStatus.top.count.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(4), "Util.localizedRankStatus.top.count.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(5), "Util.localizedRankStatus.top.count.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(6), "Util.localizedRankStatus.top.count.basedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(8), "Util.localizedRankStatus.top.sum.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(9), "Util.localizedRankStatus.top.sum.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(10), "Util.localizedRankStatus.top.sum.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(12), "Util.localizedRankStatus.top.sum.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(13), "Util.localizedRankStatus.top.sum.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(14), "Util.localizedRankStatus.top.sum.basedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(16), "Util.localizedRankStatus.top.percent.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(17), "Util.localizedRankStatus.top.percent.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(18), "Util.localizedRankStatus.top.percent.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(20), "Util.localizedRankStatus.top.percent.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(21), "Util.localizedRankStatus.top.percent.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(22), "Util.localizedRankStatus.top.percent.basedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(32), "Util.localizedRankStatus.bottom.count.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(33), "Util.localizedRankStatus.bottom.count.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(34), "Util.localizedRankStatus.bottom.count.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(36), "Util.localizedRankStatus.bottom.count.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(37), "Util.localizedRankStatus.bottom.count.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(38), "Util.localizedRankStatus.bottom.count.basedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(40), "Util.localizedRankStatus.bottom.sum.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(41), "Util.localizedRankStatus.bottom.sum.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(42), "Util.localizedRankStatus.bottom.sum.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(44), "Util.localizedRankStatus.bottom.sum.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(45), "Util.localizedRankStatus.bottom.sum.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(46), "Util.localizedRankStatus.bottom.sum.basedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(48), "Util.localizedRankStatus.bottom.percent.noBasedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(49), "Util.localizedRankStatus.bottom.percent.noBasedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(50), "Util.localizedRankStatus.bottom.percent.noBasedOn.ties.fmt.txt");
            rankingDescriptionsMap.put(new Integer(52), "Util.localizedRankStatus.bottom.percent.basedOn.tiesDoNotApply.fmt.txt");
            rankingDescriptionsMap.put(new Integer(53), "Util.localizedRankStatus.bottom.percent.basedOn.noTies.fmt.txt");
            rankingDescriptionsMap.put(new Integer(54), "Util.localizedRankStatus.bottom.percent.basedOn.ties.fmt.txt");
        }
    }

    public static ComboBoxModel getKeysComboModel(Map map) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                model.addElement((String)iterator.next());
            }
        } else if (logger.isWarnEnabled()) {
            Object[] arguments = new Object[]{"javax.swing.DefaultComboBoxModel"};
            String message = MessageFormat.format(RB.getStringResource("Util.getKeysComboModel_getValuesComboModel.receivedNullMap.fmt.log", Locale.getDefault()), arguments);
            logger.warn(message);
        }
        return model;
    }

    public static ComboBoxModel getValuesComboModel(Map map) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                model.addElement((String)iterator.next());
            }
        } else if (logger.isWarnEnabled()) {
            Object[] arguments = new Object[]{"javax.swing.DefaultComboBoxModel"};
            String message = MessageFormat.format(RB.getStringResource("Util.getKeysComboModel_getValuesComboModel.receivedNullMap.fmt.log", Locale.getDefault()), arguments);
            logger.warn(message);
        }
        return model;
    }

    public static String localizeRankStatus(String rankOrder, int rankValue, String rankType, boolean isIncludeTies, String byRankName) {
        return Util.localizeRankStatus(rankOrder, rankValue, rankType, isIncludeTies, byRankName, null);
    }

    public static String localizeRankStatus(String rankOrder, int rankValue, String rankType, boolean isIncludeTies, String byRankName, Locale locale) {
        Object[] arguments = null;
        String format = null;
        if (byRankName != null) {
            arguments = new Object[]{rankOrder, new Integer(rankValue), rankType, byRankName};
            if (isIncludeTies) {
                format = _rankStatusByRankNameWithTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusByRankNameWithTies.fmt.txt", locale);
                }
            } else {
                format = _rankStatusByRankNameWithoutTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusByRankNameWithoutTies.fmt.txt", locale);
                }
            }
        } else {
            arguments = new Object[]{rankOrder, new Integer(rankValue), rankType};
            if (isIncludeTies) {
                format = _rankStatusWithTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusWithTies.fmt.txt", locale);
                }
            } else {
                format = _rankStatusWithoutTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusWithoutTies.fmt.txt", locale);
                }
            }
        }
        String localizeRankStatus = MessageFormat.format(format, arguments);
        return localizeRankStatus;
    }

    public static String localizeRankStatus(String rankOrder, int rankValue, String rankType, boolean isIncludeTies) {
        return Util.localizeRankStatus(rankOrder, rankValue, rankType, isIncludeTies, null);
    }

    public static String localizeRankStatus(String rankOrder, int rankValue, String rankType, String isIncludeTies, String byRankName) {
        return Util.localizeRankStatus(rankOrder, rankValue, rankType, isIncludeTies, byRankName, null);
    }

    public static String localizeRankStatus(String rankOrder, int rankValue, String rankType, String isIncludeTies, String byRankName, Locale locale) {
        Object[] arguments = null;
        String format = null;
        if (byRankName != null && byRankName.length() > 0) {
            arguments = new Object[]{rankOrder, new Integer(rankValue), rankType, byRankName};
            if (isIncludeTies.equalsIgnoreCase("1")) {
                format = _rankStatusByRankNameWithTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusByRankNameWithTies.fmt.txt", locale);
                }
            } else if (isIncludeTies.equalsIgnoreCase("0")) {
                format = _rankStatusByRankNameWithoutTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusByRankNameWithoutTies.fmt.txt", locale);
                }
            } else {
                format = _rankStatusByRankNameTiesDoNotApply;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusByRankNameTiesDoNotApply.fmt.txt", locale);
                }
            }
        } else {
            arguments = new Object[]{rankOrder, new Integer(rankValue), rankType};
            if (isIncludeTies.equalsIgnoreCase("1")) {
                format = _rankStatusWithTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusWithTies.fmt.txt", locale);
                }
            } else {
                format = _rankStatusWithoutTies;
                if (locale != null) {
                    format = RB.getStringResource(RB_KEY, "localizedRankStatusWithoutTies.fmt.txt", locale);
                }
            }
        }
        String localizeRankStatus = MessageFormat.format(format, arguments);
        return localizeRankStatus;
    }

    @SASScope
    public static String getLocalizedRankStatus(String rankOrder, int rankValue, String rankType, String isIncludeTies, String byRankName, Locale locale) {
        String localizedRankStatus = null;
        if (!"T".equals(rankOrder) && !"B".equals(rankOrder)) {
            if (logger.isErrorEnabled()) {
                Object[] arguments = new Object[]{"rankOrder", "com.sas.dataselectors.ranking.RankingSelectorComponents.TOP_RANKING com.sas.dataselectors.ranking.RankingSelectorComponents.BOTTOM_RANKING", String.valueOf(localizedRankStatus)};
                String message = MessageFormat.format(RB.getStringResource("Util.getLocalizedRankStatus.invalidParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
                logger.error(message);
            }
            return localizedRankStatus;
        }
        if (rankValue < 0) {
            if (logger.isErrorEnabled()) {
                Object[] arguments = new Object[]{"rankValue", String.valueOf(localizedRankStatus)};
                String message = MessageFormat.format(RB.getStringResource("Util.getLocalizedRankStatus.notPositiveParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
                logger.error(message);
            }
            return localizedRankStatus;
        }
        if (!("C".equals(rankType) || "S".equals(rankType) || "P".equals(rankType))) {
            if (logger.isErrorEnabled()) {
                Object[] arguments = new Object[]{"rankType", "com.sas.dataselectors.ranking.RankingSelectorComponents.COUNT com.sas.dataselectors.ranking.RankingSelectorComponents.SUM com.sas.dataselectors.ranking.RankingSelectorComponents.PERCENT", String.valueOf(localizedRankStatus)};
                String message = MessageFormat.format(RB.getStringResource("Util.getLocalizedRankStatus.invalidParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
                logger.error(message);
            }
            return localizedRankStatus;
        }
        if (!("2".equals(isIncludeTies) || "0".equals(isIncludeTies) || "1".equals(isIncludeTies))) {
            if (logger.isErrorEnabled()) {
                Object[] arguments = new Object[]{"isIncludeTies", "com.sas.dataselectors.ranking.RankingSelectorComponents.TIES_NOT_APPLICABLE com.sas.dataselectors.ranking.RankingSelectorComponents.NOT_INCLUDE_TIES com.sas.dataselectors.ranking.RankingSelectorComponents.INCLUDE_TIES", String.valueOf(localizedRankStatus)};
                String message = MessageFormat.format(RB.getStringResource("Util.getLocalizedRankStatus.invalidParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
                logger.error(message);
            }
            return localizedRankStatus;
        }
        int flags = 0;
        Util.setupRankingDescriptionsMap();
        if ("B".equals(rankOrder)) {
            flags |= 0x20;
        }
        if ("S".equals(rankType)) {
            flags |= 8;
        } else if ("P".equals(rankType)) {
            flags |= 0x10;
        }
        if ("0".equals(isIncludeTies)) {
            flags |= 1;
        } else if ("1".equals(isIncludeTies)) {
            flags |= 2;
        }
        if (byRankName != null && byRankName.length() > 0) {
            flags |= 4;
        }
        String formatName = (String)rankingDescriptionsMap.get(new Integer(flags));
        String format = null;
        if (formatName != null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            format = RB.getStringResource(formatName, locale);
        }
        if (format != null) {
            Object[] arguments = new Object[]{new Integer(rankValue), byRankName};
            localizedRankStatus = MessageFormat.format(format, arguments);
        }
        return localizedRankStatus;
    }

    public static String localizeBasedOnMeasureDesc(String measureDesc, String[] whereClauses) {
        return Util.localizeBasedOnMeasureDesc(measureDesc, whereClauses, null);
    }

    public static String localizeBasedOnMeasureDesc(String measureDesc, String[] whereClauses, Locale locale) {
        String localizedBasedOnMeasureDesc = null;
        if (measureDesc != null && whereClauses != null) {
            Object[] arguments = null;
            arguments = new Object[6];
            arguments[0] = measureDesc;
            for (int i = 0; i < 5; ++i) {
                arguments[i + 1] = i < whereClauses.length ? whereClauses[i] : "";
            }
            String format = _basedOnMeasureWithWhereClauses;
            if (locale != null) {
                format = RB.getStringResource(RB_KEY, "localizedRankBasedOnMeasureWithWhereClauses.fmt.txt", locale);
            }
            localizedBasedOnMeasureDesc = MessageFormat.format(format, arguments);
        } else if (logger.isWarnEnabled()) {
            Object[] arguments = new Object[]{String.valueOf(localizedBasedOnMeasureDesc)};
            String message = MessageFormat.format(RB.getStringResource("Util.localizeBasedOnMeasureDesc.nullParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
            logger.warn(message);
        }
        return localizedBasedOnMeasureDesc;
    }

    public static String localizeWhereClause(String dataItemDescription, String whereClauseDescription) {
        return Util.localizeWhereClause(dataItemDescription, whereClauseDescription, null);
    }

    public static String localizeWhereClause(String dataItemDescription, String whereClauseDescription, Locale locale) {
        String localizedBasedOnMeasureWhereClause = null;
        if (dataItemDescription != null && whereClauseDescription != null) {
            Object[] arguments = new Object[]{dataItemDescription, whereClauseDescription};
            String format = _basedOnMeasureWhereClause;
            if (locale != null) {
                format = RB.getStringResource(RB_KEY, "localizedRankBasedOnMeasureWhereClause.fmt.txt", locale);
            }
            localizedBasedOnMeasureWhereClause = MessageFormat.format(format, arguments);
        } else if (logger.isWarnEnabled()) {
            Object[] arguments = new Object[]{String.valueOf(localizedBasedOnMeasureWhereClause)};
            String message = MessageFormat.format(RB.getStringResource("Util.localizeWhereClause.nullParameter.fmt.log", locale == null ? Locale.getDefault() : locale), arguments);
            logger.warn(message);
        }
        return localizedBasedOnMeasureWhereClause;
    }
}

