/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors;

import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.swing.visuals.PanelInterface;
import javax.swing.JComponent;

@SASScope(value="ALL")
public abstract class BaseSwingSelectorPanel
extends JComponent
implements PanelInterface,
DataSelectorInterface {
    protected boolean contentsValid = true;
    protected Object selectorModel;
    protected DynamicAttributeCommandInterface command;
    protected boolean wasCancelled = false;

    public void setCommand(DynamicAttributeCommandInterface newCommand) {
        if (newCommand != this.command) {
            DynamicAttributeCommandInterface old = this.command;
            this.command = newCommand;
            this.firePropertyChange("command", old, newCommand);
        }
    }

    public DynamicAttributeCommandInterface getCommand() {
        return this.command;
    }

    @Override
    public void onApply() {
        if (this.command instanceof BaseSelectorCommand) {
            ((BaseSelectorCommand)this.command).setMode("PROCESS");
            ((BaseSelectorCommand)this.command).execute(null);
        }
    }

    @Override
    public void onCancel() {
        if (this.command instanceof BaseSelectorCommand) {
            this.wasCancelled = true;
            ((BaseSelectorCommand)this.command).setMode("CANCEL");
            ((BaseSelectorCommand)this.command).execute(null);
        }
    }

    @Override
    public void onClose() {
        if (!this.wasCancelled && this.command instanceof BaseSelectorCommand) {
            ((BaseSelectorCommand)this.command).setMode("COMMIT");
            ((BaseSelectorCommand)this.command).execute(null);
        }
        this.wasCancelled = false;
    }

    @Override
    public String getDialogTitle() {
        if (this.command != null) {
            return this.command.getName();
        }
        return "";
    }

    @Override
    public String getTabTitle() {
        return this.getDialogTitle();
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public String getHelpID() {
        return null;
    }

    @Override
    public boolean isYesNo() {
        return false;
    }

    @Override
    public boolean isContentsValid() {
        return this.contentsValid;
    }

    @Override
    public void setContentsValid(boolean newValue) {
        if (newValue != this.contentsValid) {
            this.contentsValid = newValue;
            this.firePropertyChange("contentsValid", this.contentsValid ? Boolean.FALSE : Boolean.TRUE, this.contentsValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model) {
            Object old = this.selectorModel;
            this.selectorModel = model;
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    @Override
    public Object getSelectorModel() {
        return this.selectorModel;
    }
}

