/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.EditorFactory;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.text.Message;
import com.sas.util.DatePeriod;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

@SASScope
public class RangeEditor
extends JComponent
implements EditorInterface,
EditorListener,
SupportsGenericErrorHandlerInterface {
    public static final String RB_KEY = "RangeEditor.";
    private static final long serialVersionUID = 7377367939715052278L;
    private EditorInterface minEditor;
    private EditorInterface maxEditor;
    private boolean horizontalLayout;
    private String minText;
    private String maxText;
    private JLabel minLabel;
    private JLabel maxLabel;
    private Object lastValidMinValue;
    private Object lastValidMaxValue;
    private GenericErrorHandlerInterface errorHandler;
    protected boolean editingStarted;
    private boolean valueModified;
    protected boolean ignoreEvents;
    private boolean isNullAllowed;
    private static final int VALID = 0;
    private static final int ONLY_ONE_VALUE = 1;
    private static final int MIN_GREATER_MAX = 2;
    private static final int INVALID = 3;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;

    public RangeEditor(DataTypeInterface typeOfData, Locale locale) {
        this(typeOfData, false, locale);
    }

    public RangeEditor(DataTypeInterface typeOfData, boolean horizontalLayout, Locale locale) {
        this(typeOfData, RB.getStringResource(RB_KEY, "minLabel.txt", locale), RB.getStringResource(RB_KEY, "maxLabel.txt", locale), horizontalLayout, locale);
    }

    public RangeEditor(DataTypeInterface typeOfData, String minLabel, String maxLabel, Locale locale) {
        this(typeOfData, minLabel, maxLabel, false, locale);
    }

    public RangeEditor(DataTypeInterface typeOfData, String minLabel, String maxLabel, boolean horizontalLayout, Locale locale) {
        this.minEditor = EditorFactory.defaultInstance.getEditor(typeOfData, locale);
        this.maxEditor = EditorFactory.defaultInstance.getEditor(typeOfData, locale);
        this.minText = minLabel;
        this.maxText = maxLabel;
        this.horizontalLayout = horizontalLayout;
        this.setLocale(locale);
        this.init();
    }

    public RangeEditor(EditorInterface minEditor, EditorInterface maxEditor, Locale locale) {
        this(minEditor, maxEditor, false, locale);
    }

    public RangeEditor(EditorInterface minEditor, EditorInterface maxEditor, boolean horizontalLayout, Locale locale) {
        this(minEditor, maxEditor, RB.getStringResource(RB_KEY, "minLabel.txt", locale), RB.getStringResource(RB_KEY, "maxLabel.txt", locale), horizontalLayout, locale);
    }

    public RangeEditor(EditorInterface minEditor, EditorInterface maxEditor, String minLabel, String maxLabel, Locale locale) {
        this(minEditor, maxEditor, minLabel, maxLabel, false, locale);
    }

    public RangeEditor(EditorInterface minEditor, EditorInterface maxEditor, String minLabel, String maxLabel, boolean horizontalLayout, Locale locale) {
        this.minEditor = minEditor;
        this.maxEditor = maxEditor;
        this.minText = minLabel;
        this.maxText = maxLabel;
        this.horizontalLayout = horizontalLayout;
        this.setLocale(locale);
        this.init();
    }

    protected void init() {
        this.editingStarted = false;
        this.valueModified = false;
        this.isNullAllowed = false;
        this.errorHandler = new JOptionPaneErrorHandler(this);
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.minEditor != null) {
            this.minEditor.getEditorComponent().setEnabled(enabled);
        }
        if (this.maxEditor != null) {
            this.maxEditor.getEditorComponent().setEnabled(enabled);
        }
        if (this.minLabel != null) {
            this.minLabel.setEnabled(enabled);
        }
        if (this.maxLabel != null) {
            this.maxLabel.setEnabled(enabled);
        }
    }

    protected void createComponents() {
        this.minLabel = new JLabel(this.minText);
        this.maxLabel = new JLabel(this.maxText);
    }

    protected void layoutComponents() {
        AutoSizingGridLayout rangeLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        rangeLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(rangeLayout);
        if (this.horizontalLayout) {
            rangeLayout.setColumnSpacePartitioner(new ProportionalSpacePartitioner(new double[]{0.5, 0.5}, null, null, true));
            this.add(this.minLabel);
            this.add(this.maxLabel);
            this.add(this.minEditor.getEditorComponent());
            this.add(this.maxEditor.getEditorComponent());
        } else {
            rangeLayout.setColumns(1);
            rangeLayout.setRows(4);
            this.add(this.minLabel);
            this.add(this.minEditor.getEditorComponent());
            this.add(this.maxLabel);
            this.add(this.maxEditor.getEditorComponent());
        }
    }

    public void addListeners() {
        this.minEditor.addEditorListener(this);
        this.maxEditor.addEditorListener(this);
    }

    public void removeListeners() {
        this.minEditor.removeEditorListener(this);
        this.maxEditor.removeEditorListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(int errorCode) {
        boolean handlingError = false;
        if (this.getMinEditor() instanceof DatePicker && ((DatePicker)this.getMinEditor()).isHandlingError() || this.getMaxEditor() instanceof DatePicker && ((DatePicker)this.getMaxEditor()).isHandlingError()) {
            handlingError = true;
        } else if (this.getMinEditor() instanceof TextEditor && ((TextEditor)this.getMinEditor()).isHandlingError() || this.getMaxEditor() instanceof TextEditor && ((TextEditor)this.getMaxEditor()).isHandlingError()) {
            handlingError = true;
        }
        if (!handlingError && this.getGenericErrorHandler() != null) {
            if (errorCode == 2) {
                String errorMsg = RB.getStringResource(RB_KEY, "invalidRange.txt", this.getLocale());
                this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)errorMsg)), null);
            } else if (errorCode == 3) {
                String errorMsg = RB.getStringResource(RB_KEY, "invalidObject.txt", this.getLocale());
                this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)errorMsg)), null);
            } else if (errorCode == 1) {
                String errorMsg = RB.getStringResource(RB_KEY, "onlyOneValue.txt", this.getLocale());
                this.getGenericErrorHandler().handleError(this, new Message(Strings.padSingleQuotesForMessage((String)errorMsg)), null);
            }
        }
        try {
            this.ignoreEvents = true;
            this.minEditor.setValue(this.lastValidMinValue);
            this.maxEditor.setValue(this.lastValidMaxValue);
        }
        finally {
            this.ignoreEvents = false;
        }
    }

    private int isValueValid(Object value, boolean nullAllowed, boolean setLastValuesIfValid) {
        int ret = 0;
        if (value instanceof Object[] && ((Object[])value).length == 2) {
            Object o1 = ((Object[])value)[0];
            Object o2 = ((Object[])value)[1];
            if (o1 != null && o2 != null) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    int comparison;
                    Comparable c1 = (Comparable)o1;
                    Comparable c2 = (Comparable)o2;
                    if (c1 instanceof DatePeriod) {
                        c1 = ((DatePeriod)c1).getStartOfPeriod();
                    }
                    if (c2 instanceof DatePeriod) {
                        c2 = ((DatePeriod)c2).getEndOfPeriod();
                    }
                    ret = (comparison = c1.compareTo(c2)) <= 0 ? 0 : 2;
                }
                if (ret == 0 && setLastValuesIfValid) {
                    this.lastValidMinValue = o1;
                    this.lastValidMaxValue = o2;
                }
            } else {
                ret = nullAllowed || this.isNullAllowed() ? 0 : (o1 != null || o2 != null ? 1 : 3);
            }
        } else if (!this.isNullAllowed()) {
            ret = 3;
        }
        if (value == null) {
            ret = 0;
            if (setLastValuesIfValid) {
                this.lastValidMinValue = null;
                this.lastValidMaxValue = null;
            }
        }
        return ret;
    }

    @Override
    public Object getValue() {
        Object o1 = this.minEditor.getValue();
        Object o2 = this.maxEditor.getValue();
        if (o1 != null || o2 != null) {
            return new Object[]{o1, o2};
        }
        return null;
    }

    @Override
    public void setValue(Object anObject) {
        int error = this.isValueValid(anObject, false, true);
        if (error == 0) {
            try {
                this.ignoreEvents = true;
                this.minEditor.setValue(this.lastValidMinValue);
                this.maxEditor.setValue(this.lastValidMaxValue);
            }
            finally {
                this.ignoreEvents = false;
            }
        } else {
            this.handleError(error);
        }
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    @Override
    public void editingStarted(ChangeEvent e) {
        if (!this.editingStarted) {
            this.editingStarted = true;
            this.fireEditingStarted();
        }
    }

    @Override
    public void valueModified(ChangeEvent e) {
        if (!this.valueModified && this.isEditing()) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void valueChanged(ChangeEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        Object value = this.getValue();
        int error = this.isValueValid(value, true, true);
        if (error != 0) {
            this.handleError(error);
            return;
        }
        if (value instanceof Object[] && ((Object[])value).length == 2) {
            Object o1 = ((Object[])value)[0];
            Object o2 = ((Object[])value)[1];
            if (o1 != null && o2 != null) {
                this.fireValueChanged();
            }
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RangeEditor.this.isEditing()) {
                    int error = RangeEditor.this.isValueValid(RangeEditor.this.getValue(), false, true);
                    if (error != 0) {
                        RangeEditor.this.handleError(error);
                    }
                    RangeEditor.this.editingStarted = false;
                    RangeEditor.this.valueModified = false;
                    RangeEditor.this.fireEditingStopped();
                }
            }
        });
    }

    @Override
    public boolean isEditing() {
        return this.minEditor.isEditing() || this.maxEditor.isEditing();
    }

    @Override
    public void requestFocus() {
        this.minEditor.getEditorComponent().requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.minEditor.getEditorComponent() instanceof JComponent) {
            return ((JComponent)this.minEditor.getEditorComponent()).requestFocus(temporary);
        }
        return false;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.minEditor.getEditorComponent().requestFocusInWindow();
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public void setHorizontalLayout(boolean horizontalLayout) {
        if (this.horizontalLayout != horizontalLayout) {
            this.horizontalLayout = horizontalLayout;
            this.removeAll();
            this.layoutComponents();
            this.firePropertyChange("horizontalLayout", !horizontalLayout, horizontalLayout);
        }
    }

    public EditorInterface getMaxEditor() {
        return this.maxEditor;
    }

    public JLabel getMaxLabel() {
        return this.maxLabel;
    }

    public EditorInterface getMinEditor() {
        return this.minEditor;
    }

    public JLabel getMinLabel() {
        return this.minLabel;
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void setNullAllowed(boolean isNullAllowed) {
        if (this.isNullAllowed != isNullAllowed) {
            boolean oldValue = this.isNullAllowed;
            this.isNullAllowed = isNullAllowed;
            this.firePropertyChange("isNullAllowed", oldValue, this.isNullAllowed);
        }
    }
}

