/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.swing.util.DesktopUtil;
import com.sas.swing.visuals.Config;
import com.sas.swing.visuals.ConfigStateInterface;
import com.sas.swing.visuals.PanelInterface;
import com.sas.swing.visuals.PanelInterfaceV2;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.util.CommonButtons;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@SASScope(value="ALL")
@SubjectToChange
public class OptionsDialog
extends JDialog
implements LayoutConstants,
ActionListener {
    public static final String RB_KEY = "OptionsDialog.";
    private String helpID;
    private PanelInterface panel;
    private boolean wasCancelled;
    private Listener listener;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private int buttonLocation;
    protected int buttons;
    private String docsetId;
    private VetoableChangeListener vetoListener;
    private boolean mousePressed;
    private boolean ignoreWindowEvent;
    private boolean processingWindowEvent;

    public OptionsDialog(Frame parent, String title, boolean modal) {
        this(parent, title, modal, 3, 4);
    }

    @SASScope
    public OptionsDialog(Frame parent, String title, boolean modal, String docsetId) {
        this(parent, title, modal, 3, 4, docsetId);
    }

    public OptionsDialog(Frame f, String title, boolean modal, int buttons, int buttonLocation) {
        super(f, title, modal);
        this.init(buttons, buttonLocation, null);
    }

    @SASScope
    public OptionsDialog(Frame f, String title, boolean modal, int buttons, int buttonLocation, String docsetId) {
        super(f, title, modal);
        this.init(buttons, buttonLocation, docsetId);
    }

    public OptionsDialog(Frame parent, PanelInterface panel, boolean modal) {
        this(parent, panel, modal, 3, 4);
    }

    public OptionsDialog(Frame f, PanelInterface panel, boolean modal, int buttons, int buttonLocation) {
        this(f, (String)null, modal, buttons, buttonLocation);
        this.setPanel(panel);
    }

    @SASScope
    public OptionsDialog(Dialog owner, String title, boolean modal) {
        this(owner, title, modal, 3, 4);
    }

    @SASScope
    public OptionsDialog(Dialog owner, String title, boolean modal, int buttons, int buttonLocation) {
        super(owner, title, modal);
        this.init(buttons, buttonLocation, null);
    }

    @SASScope
    public OptionsDialog(Dialog owner, String title, boolean modal, int buttons, int buttonLocation, String docsetId) {
        super(owner, title, modal);
        this.init(buttons, buttonLocation, docsetId);
    }

    @SASScope
    public OptionsDialog(Dialog owner, PanelInterface panel, boolean modal) {
        this(owner, panel, modal, 3, 4);
    }

    @SASScope
    public OptionsDialog(Dialog owner, PanelInterface panel, boolean modal, int buttons, int buttonLocation) {
        this(owner, (String)null, modal, buttons, buttonLocation);
        this.setPanel(panel);
    }

    private void init(int buttons, int buttonLocation, String docsetId) {
        this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        this.listener = new Listener();
        this.enableEvents(64L);
        this.vetoListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (OptionsDialog.this.isShowing() && OptionsDialog.this.mousePressed) {
                    throw new PropertyVetoException("Cancel pressed", evt);
                }
            }
        };
        FocusManager.getCurrentManager().addVetoableChangeListener("focusOwner", this.vetoListener);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(10, 10));
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        this.mainPanel = new JPanel();
        contentPane.add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new BorderLayout());
        this.setButtonLocation(buttonLocation);
        this.setButtons(buttons);
        this.setDocsetId(docsetId);
    }

    public String getDocsetId() {
        return this.docsetId;
    }

    public void setDocsetId(String docsetId) {
        this.docsetId = docsetId;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setHelpID(String newValue) {
        this.helpID = newValue;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    void onYes() {
        this.onOK();
    }

    void onNo() {
        this.onCancel();
    }

    public void onApply() {
        if (this.panel != null) {
            this.panel.onApply();
        }
    }

    public void onCancel() {
        this.wasCancelled = true;
        if (this.panel != null) {
            this.panel.onCancel();
        }
        this.onClose();
    }

    public void onClose() {
        if (this.panel != null) {
            if (!this.wasCancelled() && !this.panel.isContentsValid()) {
                return;
            }
            this.panel.onClose();
        }
        if (!this.processingWindowEvent) {
            try {
                this.ignoreWindowEvent = true;
                WindowEvent e = new WindowEvent(this, 201);
                this.dispatchEvent(e);
            }
            finally {
                this.ignoreWindowEvent = false;
            }
        }
        this.setVisible(false);
    }

    public void onOK() {
        this.onApply();
        this.onClose();
    }

    public PanelInterface getPanel() {
        return this.panel;
    }

    public void setPanel(PanelInterface newValue) {
        PanelInterface oldValue = this.panel;
        this.panel = newValue;
        if (oldValue != null) {
            oldValue.getPanel().removePropertyChangeListener(this.listener);
        }
        if (this.panel == null) {
            if (oldValue != null) {
                this.getMainPanel().remove(oldValue.getPanel());
            }
        } else {
            this.panel.getPanel().addPropertyChangeListener(this.listener);
            this.getMainPanel().add((Component)this.panel.getPanel(), "Center");
            if (this.panel.getDialogTitle() != null) {
                this.setTitle(this.panel.getDialogTitle());
            }
            if (this.panel.getHelpID() != null) {
                this.setHelpID(this.panel.getHelpID());
            }
            this.updateButtonsForPanel();
        }
    }

    protected void updateButtonsForPanel() {
        if (this.getPanel() == null) {
            return;
        }
        boolean valid = this.getPanel().isContentsValid();
        if ((this.buttons & 1) != 0) {
            this.getButton(1).setEnabled(valid);
        }
        if ((this.buttons & 0x10) != 0) {
            this.getButton(16).setEnabled(valid);
        }
    }

    protected AbstractButton getButton(int id) {
        Component[] btnComps = this.buttonPanel.getComponents();
        int cnt = btnComps.length;
        for (int i = 0; i < cnt; ++i) {
            int iden;
            AbstractButton btn = (AbstractButton)btnComps[i];
            Object object = btn.getClientProperty("ID");
            if (object == null || !(object instanceof Integer) || (iden = ((Integer)object).intValue()) != id) continue;
            return btn;
        }
        return null;
    }

    public void onHelp() {
        String panelDocProduct;
        if (this.panel == null) {
            String helpID = this.getHelpID();
            if (this.getDocsetId() != null && helpID != null) {
                this.showJavaHelp(this.getDocsetId(), helpID);
            }
            return;
        }
        String string = panelDocProduct = this.panel instanceof PanelInterfaceV2 ? ((PanelInterfaceV2)this.panel).getHelpProduct() : null;
        if (!(this.panel instanceof ConfigStateInterface) || ((ConfigStateInterface)((Object)this.panel)).getConfig() == null) {
            String helpID = this.panel.getHelpID();
            if (helpID == null) {
                helpID = this.getHelpID();
            }
            if (helpID != null) {
                this.showJavaHelp(panelDocProduct, helpID);
            }
            return;
        }
        ConfigStateInterface configStatePanel = (ConfigStateInterface)((Object)this.panel);
        Config.Element state = ((ConfigStateInterface)((Object)this.panel)).getState();
        this.showJavaHelp(configStatePanel.getConfig().getHelpProduct(state, panelDocProduct), configStatePanel.getConfig().getHelpID(state, this.panel.getHelpID()));
    }

    private void showJavaHelp(String docProduct, String helpID) {
        if (docProduct == null) {
            return;
        }
        DesktopUtil.openHelpDoc(docProduct, helpID, "version", null);
    }

    public void setButtons(int newButtons) {
        if (this.buttons == newButtons) {
            return;
        }
        Component[] btnComps = this.buttonPanel.getComponents();
        int cnt = btnComps.length;
        for (int i = 0; i < cnt; ++i) {
            ((AbstractButton)btnComps[i]).removeActionListener(this.listener);
        }
        this.buttonPanel.removeAll();
        this.buttons = newButtons;
        if ((this.buttons & 0x1000) != 0) {
            return;
        }
        AbstractButton[] jButtons = this.createButtons(this.buttons);
        int cnt2 = jButtons.length;
        for (int i = 0; i < cnt2; ++i) {
            this.addButton(jButtons[i]);
            jButtons[i].addActionListener(this.listener);
        }
    }

    protected AbstractButton[] createButtons(int newButtons) {
        AbstractButton[] buttons = CommonButtons.createButtons(newButtons);
        for (int i = 0; i < buttons.length; ++i) {
            Object id = buttons[i].getClientProperty("ID");
            if (!(id instanceof Integer) || (Integer)id != 2) continue;
            buttons[i].getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((ButtonModel)e.getSource()).isPressed()) {
                        OptionsDialog.this.mousePressed = true;
                    } else {
                        OptionsDialog.this.mousePressed = false;
                        if (FocusManager.getCurrentManager().getFocusOwner() != null) {
                            FocusManager.getCurrentManager().getFocusOwner().requestFocus();
                        }
                    }
                }
            });
        }
        return buttons;
    }

    public int getButtonLocation() {
        return this.buttonLocation;
    }

    public void setButtonLocation(int newButtonLocation) {
        JPanel buttonPanelParent;
        if (this.buttonLocation == newButtonLocation) {
            return;
        }
        this.validateButtonLocation(newButtonLocation);
        if (this.buttonPanel == null) {
            buttonPanelParent = new JPanel(new BorderLayout());
            this.buttonPanel = new JPanel();
            buttonPanelParent.add((Component)this.buttonPanel, "East");
        } else {
            buttonPanelParent = (JPanel)this.buttonPanel.getParent();
        }
        if (4 == newButtonLocation) {
            buttonPanelParent.setLayout(new BorderLayout());
            buttonPanelParent.add((Component)this.buttonPanel, "East");
            this.getContentPane().add((Component)buttonPanelParent, "South");
            this.buttonPanel.setLayout(new GridLayout(1, 0, 7, 0));
        } else if (5 == newButtonLocation) {
            buttonPanelParent.setLayout(new FlowLayout());
            buttonPanelParent.add(this.buttonPanel);
            this.getContentPane().add((Component)buttonPanelParent, "South");
            this.buttonPanel.setLayout(new GridLayout(1, 0, 7, 0));
        } else if (2 == newButtonLocation) {
            buttonPanelParent.setLayout(new BorderLayout());
            buttonPanelParent.add((Component)this.buttonPanel, "East");
            this.getContentPane().add((Component)buttonPanelParent, "East");
            this.buttonPanel.setLayout(new AutoSizingGridLayout(0, 1, 0, 7, true, false, false));
        } else {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "invalidButtonLocation.txt"), (Object)new Integer(this.buttonLocation)));
        }
        this.buttonLocation = newButtonLocation;
    }

    private void validateButtonLocation(int location) {
        switch (location) {
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "unsupportedButtonLocation.txt"), (Object)new Integer(this.buttonLocation)));
            }
        }
    }

    public void addButton(AbstractButton b) {
        this.buttonPanel.add(b);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    private void buttonPressed(AbstractButton button) {
        if (button == null || !button.isEnabled()) {
            return;
        }
        String label = button.getText();
        Object id = button.getClientProperty("ID");
        if (id != null && id instanceof Integer) {
            int iden = (Integer)id;
            switch (iden) {
                case 1: {
                    this.onOK();
                    break;
                }
                case 16: {
                    this.onYes();
                    break;
                }
                case 32: {
                    this.onNo();
                    break;
                }
                case 2: {
                    this.onCancel();
                    break;
                }
                case 4: {
                    this.onApply();
                    break;
                }
                case 8: {
                    this.onHelp();
                    break;
                }
                case 64: {
                    this.onClose();
                }
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (!this.ignoreWindowEvent && event.getID() == 201) {
            try {
                this.processingWindowEvent = true;
                this.onCancel();
            }
            finally {
                this.processingWindowEvent = false;
            }
        }
        super.processWindowEvent(event);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.wasCancelled = false;
        }
        if (this.vetoListener != null) {
            if (visible && !this.isVisible()) {
                FocusManager.getCurrentManager().addVetoableChangeListener("focusOwner", this.vetoListener);
            } else if (!visible) {
                FocusManager.getCurrentManager().removeVetoableChangeListener("focusOwner", this.vetoListener);
            }
        }
        super.setVisible(visible);
    }

    @Override
    @SASScope
    public void dispose() {
        if (this.vetoListener != null) {
            FocusManager.getCurrentManager().removeVetoableChangeListener("focusOwner", this.vetoListener);
        }
    }

    @SASScope
    class Listener
    extends KeyAdapter
    implements ActionListener,
    ContainerListener,
    PropertyChangeListener {
        private transient KeyEvent _lastEvent;

        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof AbstractButton) {
                OptionsDialog.this.buttonPressed((AbstractButton)e.getSource());
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("contentsValid".equals(event.getPropertyName())) {
                OptionsDialog.this.updateButtonsForPanel();
            }
        }
    }
}

