/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.swing.visuals.LimitedPlainDocument;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LimitedTextField
extends JTextField {
    public LimitedTextField() {
    }

    public LimitedTextField(int columns) {
        super(columns);
    }

    public LimitedTextField(String text) {
        super(text);
    }

    public LimitedTextField(String text, int columns) {
        super(text, columns);
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitedPlainDocument();
    }

    public int getMaxCharacters() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            return ((LimitedPlainDocument)doc).getMaxCharacters();
        }
        return Integer.MAX_VALUE;
    }

    public void setMaxCharacters(int maxCharacters) {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            int length = doc.getLength();
            if (length > maxCharacters) {
                try {
                    ((LimitedPlainDocument)doc).remove(maxCharacters, length - maxCharacters);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ((LimitedPlainDocument)doc).setMaxCharacters(maxCharacters);
        }
    }

    public boolean isBeepEnabled() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            return ((LimitedPlainDocument)doc).isBeepEnabled();
        }
        return false;
    }

    public void setBeepEnabled(boolean beepEnabled) {
        Document doc = this.getDocument();
        if (doc instanceof LimitedPlainDocument) {
            ((LimitedPlainDocument)doc).setBeepEnabled(beepEnabled);
        }
    }
}

