/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.swing.Constants;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

@SASScope(value="ALL")
public class LabelView
extends JLabel
implements SwingConstants,
Constants {
    private static final String uiClassID = "LabelViewUI";
    protected int alignmentMode;
    protected boolean clipped;
    protected int orientation;
    protected boolean lineWrap;
    protected boolean wordWrap;
    protected int lineGap;
    protected Dimension preferredSpanSize;
    protected int tabSize;
    protected int leadingContentOffset;
    protected int topContentOffset;
    protected boolean replaceTab;
    protected boolean replaceNewline;
    public static final int INDIVIDUAL = 1;
    public static final int BLOCK = 2;
    public static final int SPAN_FILL = -101;
    private Component linkedComponent;
    private int minWrapWidth;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "orientation"}, {"Property editor class", "com.sas.beans.editors._SwingConstantsOrientationEditor"}}, {{"Name", "verticalAlignment"}, {"Property editor class", "com.sas.beans.editors._ConstantsVerticalAlignmentEditor"}}, {{"Name", "verticalTextPosition"}, {"Property editor class", "com.sas.beans.editors._ConstantsVerticalAlignmentEditor"}}, {{"Name", "horizontalAlignment"}, {"Property editor class", "com.sas.beans.editors._ConstantsHorizontalAlignmentEditor"}}, {{"Name", "horizontalTextPosition"}, {"Property editor class", "com.sas.beans.editors._ConstantsHorizontalAlignmentEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @SASScope
    public Component getLinkedComponent() {
        return this.linkedComponent;
    }

    @SASScope
    public void setLinkedComponent(Component linkedComponent) {
        this.linkedComponent = linkedComponent;
    }

    @SASScope
    public int getMinimumWrapWidth() {
        return this.minWrapWidth;
    }

    @SASScope
    public void setMinimumWrapWidth(int minWrapWidth) {
        this.minWrapWidth = minWrapWidth;
    }

    public LabelView(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initializeLocalVars();
    }

    public LabelView(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public LabelView(String text) {
        this(text, null, 10);
    }

    public LabelView(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public LabelView(Icon image) {
        this(null, image, 0);
    }

    public LabelView() {
        this("", null, 10);
    }

    @Override
    public void updateUI() {
        if (!UIManager.getDefaults().contains(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.BasicLabelViewUI");
        }
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void initializeLocalVars() {
        this.alignmentMode = 1;
        this.clipped = true;
        this.orientation = 0;
        this.lineWrap = true;
        this.wordWrap = true;
        this.lineGap = 0;
        this.preferredSpanSize = new Dimension(-1, -1);
        this.tabSize = 8;
        this.leadingContentOffset = 0;
        this.topContentOffset = 0;
        this.replaceTab = true;
        this.replaceNewline = true;
    }

    public int getAlignmentMode() {
        return this.alignmentMode;
    }

    public void setAlignmentMode(int newValue) {
        if (newValue != this.alignmentMode) {
            int oldValue = this.alignmentMode;
            this.alignmentMode = newValue;
            this.firePropertyChange("alignmentMode", oldValue, newValue);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isClipped() {
        return this.clipped;
    }

    public void setClipped(boolean newValue) {
        if (newValue != this.clipped) {
            boolean oldValue = this.clipped;
            this.clipped = newValue;
            this.firePropertyChange("clipped", oldValue, newValue);
            this.revalidate();
            this.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newValue) {
        if (newValue != this.orientation) {
            if (newValue == 0 || newValue == 1) {
                int oldValue = this.orientation;
                this.orientation = newValue;
                this.firePropertyChange("orientation", oldValue, newValue);
                this.revalidate();
                this.repaint();
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public int getGapBetweenLines() {
        return this.lineGap;
    }

    public void setGapBetweenLines(int newValue) {
        if (newValue != this.lineGap) {
            int oldValue = this.lineGap;
            this.lineGap = newValue;
            this.firePropertyChange("gapBetweenLines", oldValue, this.lineGap);
            this.revalidate();
            this.repaint();
        }
    }

    public int getLeadingContentOffset() {
        return this.leadingContentOffset;
    }

    public void setLeadingContentOffset(int newValue) {
        if (newValue != this.leadingContentOffset) {
            int oldValue = this.leadingContentOffset;
            this.leadingContentOffset = newValue;
            this.firePropertyChange("leadingContentOffset", oldValue, this.leadingContentOffset);
            this.revalidate();
            this.repaint();
        }
    }

    public int getTopContentOffset() {
        return this.topContentOffset;
    }

    public void setTopContentOffset(int newValue) {
        if (newValue != this.topContentOffset) {
            int oldValue = this.topContentOffset;
            this.topContentOffset = newValue;
            this.firePropertyChange("topContentOffset", oldValue, this.topContentOffset);
            this.revalidate();
            this.repaint();
        }
    }

    public void setLineWrap(boolean wrap) {
        if (this.lineWrap != wrap) {
            boolean old = this.lineWrap;
            this.lineWrap = wrap;
            this.firePropertyChange("lineWrap", old, this.lineWrap);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    public void setWrapStyleWord(boolean word) {
        if (this.wordWrap != word) {
            boolean old = this.wordWrap;
            this.wordWrap = word;
            this.firePropertyChange("wrapStyleWord", old, this.wordWrap);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getWrapStyleWord() {
        return this.wordWrap;
    }

    public void setPreferredSpanSize(Dimension newSize) {
        if (newSize.width != this.preferredSpanSize.width || newSize.height != this.preferredSpanSize.height) {
            Dimension oldValue = this.preferredSpanSize;
            this.preferredSpanSize = newSize;
            this.firePropertyChange("preferredSpanSize", oldValue, this.preferredSpanSize);
            this.revalidate();
            this.repaint();
        }
    }

    public Dimension getPreferredSpanSize() {
        return this.preferredSpanSize;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int newValue) {
        if (newValue != this.tabSize) {
            int oldValue = this.tabSize;
            this.tabSize = newValue;
            this.firePropertyChange("tabSize", oldValue, this.tabSize);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected int checkVerticalKey(int key, String message) {
        if (key == 1 || key == 0 || key == 3 || key == 5 || key == 6) {
            return key;
        }
        throw new IllegalArgumentException(message);
    }

    @Override
    protected int checkHorizontalKey(int key, String message) {
        if (key == 2 || key == 0 || key == 4 || key == 10 || key == 11 || key == 7 || key == 8 || key == 12 || key == 13) {
            return key;
        }
        throw new IllegalArgumentException(message);
    }

    @Override
    public int getVerticalAlignment() {
        return super.getVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(int alignment) {
        super.setVerticalAlignment(alignment);
    }

    @Override
    public int getHorizontalAlignment() {
        return super.getHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
    }

    @Override
    public int getVerticalTextPosition() {
        return super.getVerticalTextPosition();
    }

    @Override
    public void setVerticalTextPosition(int textPosition) {
        super.setVerticalTextPosition(textPosition);
    }

    @Override
    public int getHorizontalTextPosition() {
        return super.getHorizontalTextPosition();
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        super.setHorizontalTextPosition(textPosition);
    }

    @SASScope
    public boolean getReplaceTab() {
        return this.replaceTab;
    }

    @SASScope
    public void setReplaceTab(boolean replace) {
        this.replaceTab = replace;
    }

    @SASScope
    public boolean getReplaceNewline() {
        return this.replaceNewline;
    }

    @SASScope
    public void setReplaceNewline(boolean replace) {
        this.replaceNewline = replace;
    }
}

