/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.HyperlinkType;
import com.sas.models.Hyperlink;
import com.sas.models.HyperlinkInterface;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.EditorListener;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.TextEditor;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;

@SASScope
public class HyperlinkEditor
extends JComponent
implements EditorInterface,
EditorListener,
SupportsGenericErrorHandlerInterface {
    public static final String RB_KEY = "HyperlinkEditor.";
    private static final long serialVersionUID = 4157864562837578624L;
    private TextEditor linkEditor;
    private TextEditor labelEditor;
    private HyperlinkInterface link;
    private JLabel linkLabel;
    private JLabel labelLabel;
    private GenericErrorHandlerInterface errorHandler;
    private boolean editingStarted;
    private boolean valueModified;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;

    public HyperlinkEditor(Locale locale) {
        this.setLocale(locale);
        this.init();
    }

    protected void init() {
        this.editingStarted = false;
        this.valueModified = false;
        this.errorHandler = new JOptionPaneErrorHandler(this);
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.linkEditor != null) {
            this.linkEditor.setEnabled(enabled);
        }
        if (this.labelEditor != null) {
            this.labelEditor.setEnabled(enabled);
        }
        if (this.linkLabel != null) {
            this.linkLabel.setEnabled(enabled);
        }
        if (this.labelLabel != null) {
            this.labelLabel.setEnabled(enabled);
        }
    }

    protected void createComponents() {
        this.linkEditor = new TextEditor();
        this.labelEditor = new TextEditor();
        String linkText = RB.getStringResource(RB_KEY, "link.txt", this.getLocale());
        String labelText = RB.getStringResource(RB_KEY, "linkLabel.txt", this.getLocale());
        this.linkLabel = new JLabel(linkText);
        this.labelLabel = new JLabel(labelText);
    }

    protected void layoutComponents() {
        AutoSizingGridLayout rangeLayout = new AutoSizingGridLayout(2, 2, 5, 5, true, false, true);
        rangeLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(rangeLayout);
        rangeLayout.setColumns(1);
        rangeLayout.setRows(4);
        this.add(this.linkLabel);
        this.add(this.linkEditor);
        this.add(this.labelLabel);
        this.add(this.labelEditor);
    }

    public void addListeners() {
        this.linkEditor.addEditorListener(this);
        this.labelEditor.addEditorListener(this);
    }

    public void removeListeners() {
        this.linkEditor.removeEditorListener(this);
        this.labelEditor.removeEditorListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    private void handleError() {
        if (this.getGenericErrorHandler() != null) {
            this.getGenericErrorHandler().handleError(this, new Message(RB.getStringResource(RB_KEY, "invalidValue.ex.txt.fmt"), this.linkEditor.getValue()), null);
        }
    }

    @Override
    public Object getValue() {
        return this.link;
    }

    @Override
    public void setValue(Object anObject) {
        try {
            HyperlinkInterface newLink = (HyperlinkInterface)HyperlinkType.DEFAULT_INSTANCE.coerceValue(anObject, this.getLocale());
            if (!Util.equal((Object)newLink, (Object)this.link)) {
                this.link = newLink;
                if (this.link != null) {
                    this.linkEditor.setValue(this.link.getLinkLocation());
                    this.labelEditor.setValue(this.link.getLinkLabel(this.getLocale()));
                } else {
                    this.linkEditor.setValue("");
                    this.labelEditor.setValue("");
                }
                this.fireValueChanged();
            }
        }
        catch (IllegalArgumentException ex) {
            this.handleError();
        }
    }

    @Override
    public void addEditorListener(EditorListener listener) {
        this.listenerList.add(EditorListener.class, listener);
    }

    @Override
    public void removeEditorListener(EditorListener listener) {
        this.listenerList.remove(EditorListener.class, listener);
    }

    public EditorListener[] getEditorListeners() {
        return (EditorListener[])this.listenerList.getListeners(EditorListener.class);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).editingStarted(this.changeEvent);
        }
    }

    protected void fireValueModified() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueModified(this.changeEvent);
        }
    }

    protected void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((EditorListener)listeners[i + 1]).valueChanged(this.changeEvent);
        }
        this.valueModified = false;
    }

    @Override
    public void editingStarted(ChangeEvent e) {
        if (!this.editingStarted) {
            this.editingStarted = true;
            this.fireEditingStarted();
        }
    }

    @Override
    public void valueModified(ChangeEvent e) {
        if (!this.valueModified) {
            this.valueModified = true;
            this.fireValueModified();
        }
    }

    @Override
    public void valueChanged(ChangeEvent e) {
        String linkValue = (String)this.linkEditor.getValue();
        String labelValue = (String)this.labelEditor.getValue();
        if (!(linkValue != null && linkValue.trim().length() != 0 || labelValue != null && labelValue.trim().length() != 0)) {
            this.setValue(null);
        } else {
            this.setValue(new Hyperlink(linkValue, labelValue, this.getLocale()));
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (!this.isEditing()) {
            String linkValue = (String)this.linkEditor.getValue();
            String labelValue = (String)this.labelEditor.getValue();
            if (!(linkValue != null && linkValue.trim().length() != 0 || labelValue != null && labelValue.trim().length() != 0)) {
                this.setValue(null);
            } else {
                this.setValue(new Hyperlink(linkValue, labelValue, this.getLocale()));
            }
            this.editingStarted = false;
            this.valueModified = false;
            this.fireEditingStopped();
        }
    }

    @Override
    public boolean isEditing() {
        return this.linkEditor.isEditing() || this.labelEditor.isEditing();
    }

    @Override
    public void requestFocus() {
        this.linkEditor.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        return this.linkEditor.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.linkEditor.requestFocusInWindow();
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.errorHandler != errorHandler) {
            GenericErrorHandlerInterface oldValue = this.errorHandler;
            this.errorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", oldValue, this.errorHandler);
        }
    }
}

