/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.FullWidthTable;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.TableView;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@SASScope
class FullWidthColumnHeader
extends ColumnHeader {
    public FullWidthColumnHeader(TableColumnModel model) {
        super(model);
    }

    @Override
    protected int getPreferredHeaderWidthForColumn(int column) {
        int size = 0;
        if (this.isVisible()) {
            size = super.getPreferredHeaderWidthForColumn(column);
        }
        return size;
    }

    @Override
    public void sizeColumnsToFit() {
        int colCount;
        TableView table;
        if (this.getTable() instanceof TableView && (table = (TableView)this.getTable()) != null && ((FullWidthTable)table).isInitialized() && table.getAutoResizeMode() == 0 && table.getColumnAutoResizeMode() != 0 && (colCount = table.getColumnCount()) > 0) {
            int[] columns = new int[colCount];
            for (int i = 0; i < colCount; ++i) {
                columns[i] = i;
            }
            int[] sizes = this.calculatePreferredWidthForColumns(columns);
            for (int c = 0; c < colCount && c < sizes.length; ++c) {
                TableColumn column = this.getColumnModel().getColumn(c);
                if (!column.getResizable()) continue;
                column.setPreferredWidth(sizes[c]);
                column.setWidth(sizes[c]);
            }
            this.lastColumnSized = colCount - 1;
        }
    }
}

