/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.util.ValueItem;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.InternationalFormatter;

@SASScope
public class DataTypeFormatter
extends InternationalFormatter {
    private DataTypeInterface dataType;
    private Locale locale;

    public DataTypeFormatter(DataTypeInterface dataType) {
        this(dataType, null);
    }

    public DataTypeFormatter(DataTypeInterface dataType, Locale locale) {
        this.dataType = dataType;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        try {
            Object v = this.dataType.coerceValue((Object)string, this.locale);
            return v;
        }
        catch (Exception e) {
            ParseException ex = new ParseException(e.getMessage(), 0);
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        String s = null;
        if (value instanceof ValueItem) {
            s = ((ValueItem)value).getLabel();
        } else if (value != null) {
            Object v = this.dataType.coerceValue(value, this.locale);
            s = v instanceof MissingValues ? MissingValues.toDisplayString((MissingValues)((MissingValues)v), (Locale)this.locale) : this.dataType.getValueAsString(v, this.locale);
        }
        if (s == null) {
            s = "";
        }
        return s;
    }
}

