/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.ColorType;
import com.sas.swing.visuals.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboPopup;

@SASScope
public class ColorComboPopup
extends BasicComboPopup
implements ListSelectionListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -6025361001457251960L;
    public static final String RB_KEY = "ColorComboPopup.";
    private JLabel colorLabel;
    private JTextField colorValue;
    private ColorType colorType;
    private boolean ignoreFocusEvent;

    public ColorComboPopup(JComboBox combo) {
        super(combo);
    }

    @Override
    protected void configureList() {
        Border border = this.list.getBorder();
        super.configureList();
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(6);
        this.list.setBorder(border);
        this.list.setFocusable(true);
        InputMap im = this.list.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke space = KeyStroke.getKeyStroke(32, 0);
        im.put(enter, "enter");
        im.put(space, "enter");
        ActionMap am = this.list.getActionMap();
        am.put("enter", new EnterAction());
        this.colorType = ColorType.DEFAULT_INSTANCE;
        this.list.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 30);
    }

    @Override
    protected void configureScroller() {
        Border border = this.scroller.getBorder();
        super.configureScroller();
        this.scroller.setBorder(border);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.colorLabel = new JLabel(RB.getStringResource(RB_KEY, "colorValue.txt"));
        this.colorValue = new JTextField();
        this.colorValue.addActionListener(this);
        this.colorValue.addFocusListener(this);
        this.setColorText();
        this.setLayout(new AutoSizingGridLayout(-1, 1, 5, 5, true, false, false));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setFocusable(true);
        this.add(this.scroller);
        this.add(this.colorLabel);
        this.add(this.colorValue);
    }

    @Override
    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
        this.list.requestFocus();
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    private Point getPopupLocation() {
        Dimension popupSize = new Dimension(this.comboBox.getSize());
        Dimension prefSize = this.getPreferredSize();
        Dimension listSize = new Dimension(this.list.getPreferredSize());
        popupSize.width = Math.min(popupSize.width, prefSize.width);
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), prefSize.height);
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Point popupLocation = popupBounds.getLocation();
        Insets borderInsets = null;
        borderInsets = this.scroller.getBorder() != null ? this.scroller.getBorder().getBorderInsets(this.scroller) : LayoutConstants.EMPTY_INSETS;
        listSize.setSize(listSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        listSize.setSize(listSize.width + borderInsets.left + borderInsets.right, listSize.height + borderInsets.top + borderInsets.bottom);
        this.scroller.setMaximumSize(listSize);
        this.scroller.setPreferredSize(listSize);
        this.scroller.setMinimumSize(listSize);
        this.list.revalidate();
        return popupLocation;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setColorText();
    }

    private void setColorText() {
        Object value = this.list.getSelectedValue();
        if (value instanceof Color) {
            this.colorValue.setText(this.colorType.getValueAsString(value, this.comboBox.getLocale()).toUpperCase());
            this.list.getAccessibleContext().setAccessibleName(this.colorType.getValueAsString(value, this.comboBox.getLocale()));
        } else {
            this.colorValue.setText(null);
            this.list.getAccessibleContext().setAccessibleName(null);
        }
    }

    protected void setAccesibleNames() {
        Object value = this.list.getSelectedValue();
        this.list.getAccessibleContext().setAccessibleName(this.colorType.getValueAsString(value, this.comboBox.getLocale()));
    }

    private void setColorValueFromField(boolean togglePopup) {
        try {
            this.ignoreFocusEvent = true;
            Color c = (Color)this.colorType.coerceValue((Object)this.colorValue.getText(), this.comboBox.getLocale());
            if (this.comboBox.getModel() instanceof DefaultComboBoxModel && ((DefaultComboBoxModel)this.comboBox.getModel()).getIndexOf(c) == -1) {
                ((DefaultComboBoxModel)this.comboBox.getModel()).addElement(c);
            }
            this.comboBox.setSelectedItem(c);
            if (togglePopup) {
                this.togglePopup();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.comboBox, ex.getMessage());
            if (togglePopup) {
                this.show();
                this.colorValue.requestFocus();
                this.colorValue.selectAll();
            }
        }
        finally {
            this.ignoreFocusEvent = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setColorValueFromField(true);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this.ignoreFocusEvent) {
            this.setColorValueFromField(false);
        }
    }

    @SASScope
    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorComboPopup.this.comboBox.setSelectedItem(ColorComboPopup.this.list.getSelectedValue());
            ColorComboPopup.this.hide();
            ColorComboPopup.this.comboBox.requestFocus();
        }
    }
}

