/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CheckBoxListCellRenderer
extends JComponent
implements ListCellRenderer {
    protected JCheckBox checkBox;

    public CheckBoxListCellRenderer() {
        this.createCheckBox();
    }

    protected void createCheckBox() {
        this.setLayout(new GridLayout(1, 1));
        this.checkBox = new JCheckBox();
        this.checkBox.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.add(this.checkBox);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground;
        Color background;
        this.setOpaque(true);
        if (cellHasFocus) {
            background = list.getSelectionBackground();
            foreground = list.getSelectionForeground();
        } else {
            background = list.getBackground();
            foreground = list.getForeground();
        }
        this.setBackground(background);
        this.setForeground(foreground);
        this.checkBox.setBackground(background);
        this.checkBox.setForeground(foreground);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.checkBox.setEnabled(list.isEnabled());
        this.checkBox.setFont(list.getFont());
        this.checkBox.setSelected(isSelected);
        String s = value.toString();
        this.checkBox.setText(s);
        this.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, background));
        return this;
    }

    public void setBorderPaintedFlat(boolean b) {
        if (this.checkBox.isBorderPaintedFlat() != b) {
            this.checkBox.setBorderPaintedFlat(b);
        }
    }

    public boolean isBorderPaintedFlat() {
        return this.checkBox.isBorderPaintedFlat();
    }
}

