/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.CalendarDialog;
import com.sas.swing.visuals.CalendarPanel;
import com.sas.swing.visuals.RB;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;

@SASScope
public class CalendarLabel
extends JLabel {
    protected static final String RB_KEY = "CalendarLabel.";
    protected SimpleDateFormat displayDateFormat;
    protected JTextField linkedField;
    protected String dialogTitle;
    protected GregorianCalendar date;
    protected GregorianCalendar maxDate;
    protected GregorianCalendar minDate;
    protected Frame dialogFrame;
    protected static Color CALENDAR_FORECOLOR = new Color(0, 0, 127);

    public CalendarLabel() {
        this((Icon)null);
    }

    public CalendarLabel(Frame frame) {
        this((Icon)null);
        this.setDialogFrame(frame);
    }

    public CalendarLabel(Icon icon) {
        this(icon, null);
    }

    public CalendarLabel(Icon icon, JTextField linkField) {
        this(icon, linkField, RB.getStringResource(RB_KEY, "defaultTitle.txt"));
    }

    public CalendarLabel(Icon icon, JTextField linkField, String dialogTitle) {
        this(icon, linkField, dialogTitle, null);
    }

    public CalendarLabel(Icon icon, JTextField linkField, String dialogTitle, Frame frame) {
        super("");
        this.init();
        this.setIcon(icon);
        if (icon == null) {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setPreferredSize(new Dimension(20, 20));
        }
        this.linkedField = linkField;
        this.date = null;
        this.dialogTitle = dialogTitle;
        this.setDialogFrame(frame);
        this.initializeUI();
    }

    public void setDialogFrame(Frame frame) {
        this.dialogFrame = frame;
    }

    public Frame getDialogFrame() {
        return this.dialogFrame;
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    protected void init() {
        this.dialogFrame = null;
        this.displayDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
    }

    public void setLinkedField(JTextField linkedField) {
        this.linkedField = linkedField;
    }

    public GregorianCalendar getDate() {
        return this.date;
    }

    public void setDate(GregorianCalendar date) {
        if (date != null) {
            this.date = date;
            if (this.linkedField != null) {
                this.linkedField.setText(this.displayDateFormat.format(this.date.getTime()));
            }
        }
    }

    public boolean setDate(int day, int month, int year) {
        try {
            Date d = new SimpleDateFormat("dd/MM/yy").parse(day + "/" + (month + 1) + "/" + year);
            this.date = new GregorianCalendar();
            this.date.setTime(d);
        }
        catch (Exception e) {
            return false;
        }
        this.setDate(this.date);
        return true;
    }

    public boolean setDate(String date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            Date d = df.parse(date);
            this.date = new GregorianCalendar();
            this.date.setTime(d);
        }
        catch (Exception e) {
            return false;
        }
        this.setDate(this.date);
        return true;
    }

    public void setMaxDate(GregorianCalendar date) {
        if (this.minDate == null || this.minDate.before(date)) {
            this.maxDate = date;
        }
        if (this.date != null && this.date.after(date)) {
            this.setDate(date);
        }
    }

    public void setMinDate(GregorianCalendar date) {
        if (this.maxDate == null || this.maxDate.after(date)) {
            this.minDate = date;
        }
        if (this.date != null && this.date.before(date)) {
            this.setDate(date);
        }
    }

    public void setDisplayFormat(String format) {
        if (format == null) {
            this.setDisplayDateFormat(null);
        } else {
            this.setDisplayDateFormat(new SimpleDateFormat(format));
        }
    }

    public void setDisplayDateFormat(SimpleDateFormat format) {
        this.displayDateFormat = format == null ? (SimpleDateFormat)SimpleDateFormat.getDateInstance() : format;
    }

    protected void initializeUI() {
        this.setDate(this.date);
        this.setFont(new Font("Helvetica", 1, 12));
        this.setForeground(CALENDAR_FORECOLOR);
        this.setHorizontalAlignment(0);
        this.addListeners();
    }

    protected void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CalendarLabel.this.isEnabled()) {
                    CalendarLabel.this.showCalendarDialog(CalendarLabel.this.dialogFrame);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CalendarLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent event) {
                CalendarLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void showCalendarDialog(Frame owner) {
        CalendarPanel calendarPanel = new CalendarPanel();
        calendarPanel.setShowWeekdayHeaders(true);
        calendarPanel.showOKButton(true);
        Double dX = new Double(this.getLocationOnScreen().getX());
        Integer h = new Integer(this.getHeight());
        Double dY = new Double(this.getLocationOnScreen().getY() + h.doubleValue());
        CalendarDialog dialog = new CalendarDialog(owner, this.dialogTitle, calendarPanel);
        dialog.setLocation(dX.intValue(), dY.intValue());
        if (this.linkedField != null && !this.linkedField.getText().trim().equals("")) {
            try {
                Date d = this.displayDateFormat.parse(this.linkedField.getText());
                GregorianCalendar gd = new GregorianCalendar();
                gd.setTime(d);
                this.setDate(gd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.date != null) {
            calendarPanel.setSelectedDate(this.date);
        }
        if (this.displayDateFormat != null) {
            calendarPanel.setTodayDisplayFormat(this.displayDateFormat);
        }
        calendarPanel.setMaxDate(this.maxDate);
        calendarPanel.setMinDate(this.minDate);
        calendarPanel.goToSelectedDate();
        dialog.show();
        if (calendarPanel.okClicked()) {
            this.date = calendarPanel.getSelectedDate();
            this.setDate(this.date);
        }
    }
}

