/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class BasicButton
extends AbstractButton {
    private static final String uiClassID = "BasicButtonUI";

    public BasicButton() {
        this(null, null);
    }

    public BasicButton(Icon icon) {
        this(null, icon);
    }

    public BasicButton(String text) {
        this(text, null);
    }

    public BasicButton(Action a) {
        this();
        this.setAction(a);
    }

    public BasicButton(String text, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(text, icon);
    }

    @Override
    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "javax.swing.plaf.basic.BasicButtonUI");
        }
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        String[] types = new String[]{"MnemonicKey", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
        this.configurePropertiesFromAction(a, types);
        Boolean hide = (Boolean)this.getClientProperty("hideActionText");
        this.setText(a != null && (hide == null || hide != Boolean.TRUE) ? (String)a.getValue("Name") : null);
    }

    private void configurePropertiesFromAction(Action a, String[] types) {
        if (types == null) {
            String[] alltypes = new String[]{"MnemonicKey", "Name", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
            types = alltypes;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (type == null) continue;
            if (type.equals("MnemonicKey")) {
                Integer n = a == null ? null : (Integer)a.getValue(type);
                this.setMnemonic(n == null ? 0 : n);
                continue;
            }
            if (type.equals("Name")) {
                this.setText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ShortDescription")) {
                this.setToolTipText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (type.equals("SmallIcon")) {
                this.setIcon(a != null ? (Icon)a.getValue(type) : null);
                continue;
            }
            if (type.equals("ActionCommandKey")) {
                this.setActionCommand(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (!type.equals("enabled")) continue;
            this.setEnabled(a != null ? a.isEnabled() : true);
        }
    }
}

