/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ArrowIcon
implements Icon {
    protected int arrowDirection;
    protected boolean pressed;

    public ArrowIcon() {
        this(5);
    }

    public ArrowIcon(int direction) {
        this(direction, false);
    }

    public ArrowIcon(boolean pressed) {
        this(5, pressed);
    }

    public ArrowIcon(int direction, boolean pressed) {
        this.arrowDirection = direction;
        this.pressed = pressed;
    }

    public void setDirection(int newValue) {
        this.arrowDirection = newValue;
    }

    public int getDirection() {
        return this.arrowDirection;
    }

    public void setPressed(boolean newValue) {
        this.pressed = newValue;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintArrow(g, this.calculateArrowLayout(c), c.isEnabled());
    }

    @Override
    public int getIconWidth() {
        return 12;
    }

    @Override
    public int getIconHeight() {
        return 12;
    }

    private void paintArrow(Graphics g, Rectangle arrowBounds, boolean enabled) {
        Polygon arrow = new Polygon();
        if (this.pressed) {
            arrowBounds.translate(1, 1);
        }
        if (enabled) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.gray);
        }
        switch (this.arrowDirection) {
            case 1: {
                for (int i = 0; i < arrowBounds.height; ++i) {
                    g.drawLine(arrowBounds.x + arrowBounds.width / 2 - i, arrowBounds.y + i, arrowBounds.x + arrowBounds.width / 2 + i, arrowBounds.y + i);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < arrowBounds.height; ++i) {
                    g.drawLine(arrowBounds.x + i, arrowBounds.y + i, arrowBounds.x + arrowBounds.width - i - 1, arrowBounds.y + i);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < arrowBounds.width; ++i) {
                    g.drawLine(arrowBounds.x + i, arrowBounds.y + i, arrowBounds.x + i, arrowBounds.y + arrowBounds.height - i - 1);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < arrowBounds.width; ++i) {
                    g.drawLine(arrowBounds.x + arrowBounds.width - i, arrowBounds.y + i, arrowBounds.x + arrowBounds.width - i, arrowBounds.y + arrowBounds.height - i - 1);
                }
                break;
            }
        }
        if (this.pressed) {
            arrowBounds.translate(-1, -1);
        }
    }

    private Rectangle calculateArrowLayout(Component c) {
        Insets ins;
        Rectangle arrowRectangle = new Rectangle();
        Dimension buttonSize = c.getSize();
        if (c instanceof JComponent) {
            ins = ((JComponent)c).getInsets();
            buttonSize.width -= ins.left + ins.right;
            buttonSize.height -= ins.top + ins.bottom;
        } else if (c instanceof Container) {
            ins = ((Container)c).getInsets();
            buttonSize.width -= ins.left + ins.right;
            buttonSize.height -= ins.top + ins.bottom;
        }
        double widthMult = 0.5;
        double heightMult = 0.6666666666666666;
        if (this.arrowDirection == 1 || this.arrowDirection == 5) {
            int arrowHeight;
            int arrowBase;
            if (buttonSize.width < 10 || buttonSize.height < 6) {
                widthMult = 0.6666666666666666;
                heightMult = 0.75;
            }
            if ((arrowBase = (arrowHeight = (int)(heightMult * (double)buttonSize.height)) * 2 - 1) > (int)((double)buttonSize.width * widthMult)) {
                arrowBase = (int)(widthMult * (double)buttonSize.width);
                if (arrowBase % 2 == 0) {
                    ++arrowBase;
                }
                arrowHeight = arrowBase / 2 + 1;
            }
            arrowRectangle.x = c.getSize().width / 2 - (arrowBase / 2 + 1);
            arrowRectangle.y = c.getSize().height / 2 - (arrowHeight / 2 + 1);
            arrowRectangle.width = arrowBase;
            arrowRectangle.height = arrowHeight;
        } else {
            int arrowHeight;
            int arrowBase;
            if (buttonSize.height < 10 || buttonSize.width < 6) {
                widthMult = 0.6666666666666666;
                heightMult = 0.75;
            }
            if ((arrowBase = (arrowHeight = (int)(heightMult * (double)buttonSize.width)) * 2 - 1) > (int)((double)buttonSize.height * widthMult)) {
                arrowBase = (int)(widthMult * (double)buttonSize.height);
                if (arrowBase % 2 == 0) {
                    ++arrowBase;
                }
                arrowHeight = arrowBase / 2 + 1;
            }
            arrowRectangle.x = c.getSize().width / 2 - (arrowHeight / 2 + 1);
            arrowRectangle.y = c.getSize().height / 2 - (arrowBase / 2 + 1);
            arrowRectangle.width = arrowHeight;
            arrowRectangle.height = arrowBase;
        }
        return arrowRectangle;
    }
}

