/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.util;

import com.sas.codepolicy.SASScope;
import com.sas.swing.util.SASHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

@SASScope
public class SASMVAHelp
implements SASHelp {
    private static int port = 0;
    private String docset;
    private Locale locale;
    private Point location;
    private Dimension size;
    boolean showNavigation = true;
    Window parentWindow;

    private static void init() {
        String portString = System.getProperty("com.sas.swing.util.SASMVAHelp.port");
        if (portString == null) {
            return;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (Exception e) {
            System.err.println("-helpport value is incorrect.");
        }
    }

    public SASMVAHelp() {
        if (port == 0) {
            SASMVAHelp.init();
        }
        this.docset = null;
    }

    public SASMVAHelp(String docProduct) {
        if (port == 0) {
            SASMVAHelp.init();
        }
        this.docset = docProduct;
        this.locale = Locale.getDefault();
    }

    public SASMVAHelp(String docProduct, Locale appLocale) {
        if (port == 0) {
            SASMVAHelp.init();
        }
        this.docset = docProduct;
        this.locale = appLocale;
    }

    @Override
    public void showHelp(String docProduct, String file) {
        String url = "/" + docProduct + ".hlp/" + file + ".htm";
        try {
            Socket ipcSocket = new Socket("localhost", port);
            ipcSocket.setTcpNoDelay(true);
            OutputStream socketStream = ipcSocket.getOutputStream();
            byte[] urlBytes = url.getBytes("UTF-8");
            byte[] utf8Length = new byte[]{(byte)urlBytes.length};
            socketStream.write(utf8Length);
            socketStream.write(urlBytes);
            socketStream.flush();
            socketStream.close();
        }
        catch (Exception e) {
            System.err.println("Exception in showHelp: " + e);
            return;
        }
    }

    @Override
    public void showHelp(String file) {
        this.showHelp(this.docset, file);
    }

    @Override
    public void showContext(String docProd, String mapID) {
        this.showHelp(docProd, mapID);
    }

    @Override
    public void showContext(String mapID) {
        this.showHelp(mapID);
    }

    @Override
    public void getHelpInfo() {
        this.printHelpInfo(null);
    }

    @Override
    public void printHelpInfo(PrintStream stream) {
        if (stream == null) {
            stream = new PrintStream(System.out, true);
        }
        stream.println("");
        stream.println("Instance: com.sas.swing.util.SASMVAHelp");
        stream.println("IPC Port: " + Integer.toString(port));
        stream.println("");
    }

    @Override
    public void enableHelpKey(Component comp, String docProd, String id) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        MVAActionListener action = new MVAActionListener(docProd, id);
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.registerKeyboardAction(action, KeyStroke.getKeyStroke(156, 0), 1);
            jcomp.registerKeyboardAction(action, KeyStroke.getKeyStroke(112, 0), 1);
        } else {
            comp.addKeyListener(new MVAKeyListener(action));
        }
    }

    @Override
    public void enableContextOnClick(Component comp, String docProd, String id) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (docProd == null) {
            docProd = this.docset;
        }
        MVAActionListener action = new MVAActionListener(docProd, id);
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(action);
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).addActionListener(action);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void enableHelpOnClick(Component comp, String docProd, String file) throws IllegalArgumentException {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (docProd == null) {
            docProd = this.docset;
        }
        MVAActionListener action = new MVAActionListener(docProd, file);
        if (comp instanceof JButton) {
            ((JButton)comp).addActionListener(action);
        } else if (comp instanceof JMenuItem) {
            ((JMenuItem)comp).addActionListener(action);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setDocProduct(String docProductName) {
        this.docset = docProductName;
    }

    @Override
    public String getDocProduct() {
        return this.docset;
    }

    @Override
    public void setActivationWindow(Window window) {
        this.parentWindow = window;
    }

    @Override
    public Window getActivationWindow() {
        return this.parentWindow;
    }

    @Override
    public void setLocation(Point point) {
        this.location = point;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setSize(Dimension dim) {
        this.size = dim;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setViewDisplayed(boolean display) {
        this.showNavigation = display;
    }

    @Override
    public boolean isViewDisplayed() {
        return this.showNavigation;
    }

    @Override
    public void setDefaultClassLoader(ClassLoader loader) {
    }

    @Override
    public ClassLoader getDefaultClassLoader() {
        return null;
    }

    @Override
    public boolean isDocProductValid(String docProduct) {
        return true;
    }

    @SASScope
    private class MVAActionListener
    implements ActionListener {
        private SASMVAHelp mvaHelp;
        private String file;

        public MVAActionListener(String docProd, String filename) {
            if (docProd == null) {
                docProd = SASMVAHelp.this.docset;
            }
            this.mvaHelp = new SASMVAHelp(docProd);
            this.file = filename;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mvaHelp.showHelp(this.file);
        }
    }

    @SASScope
    private class MVAKeyListener
    implements KeyListener {
        private MVAActionListener action;

        public MVAKeyListener(MVAActionListener theAction) {
            this.action = theAction;
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 112 || code == 156) {
                this.action.actionPerformed(new ActionEvent(e.getComponent(), 1001, null));
            }
        }
    }
}

