/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.util;

import com.sas.swing.util.RB;
import com.sas.util.log.LoggerRepository2;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JOptionPane;

public class DesktopUtil {
    public static void openHelpDoc(String docsetId, String docsetTarget, String docsetVersion, String displayMes) {
        block12: {
            String myOS = System.getProperty("os.name").toLowerCase();
            Locale locale = null != Locale.getDefault() ? Locale.getDefault() : new Locale("en");
            String helpVersion = "version";
            String Url = "https://documentation.sas.com?docsetId=" + docsetId + "&docsetVersion=" + helpVersion + "&locale=" + locale + "&requestor=inapp";
            if (docsetTarget != null && docsetTarget.trim().length() > 0) {
                Url = "https://documentation.sas.com?docsetId=" + docsetId + "&docsetVersion=" + helpVersion + "&docsetTarget=" + docsetTarget + "&locale=" + locale + "&requestor=inapp";
            }
            try {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URL(Url).toURI());
                } else if (myOS.contains("mac")) {
                    DesktopUtil.execCommand("open " + Url);
                } else if (myOS.contains("nix") || myOS.contains("nux") || myOS.contains("aix") || myOS.contains("solaris") || myOS.contains("sunos")) {
                    if (!DesktopUtil.execCommand("kde-open " + Url) && !DesktopUtil.execCommand("gnome-open " + Url)) {
                        DesktopUtil.execCommand("xdg-open " + Url);
                    }
                } else if (myOS.contains("win")) {
                    DesktopUtil.execCommand("rundll32 url.dll,FileProtocolHandler " + Url);
                } else {
                    DesktopUtil.displayMessage(RB.getStringResource("Common.noOperatingSystem.txt"));
                }
            }
            catch (IOException | URISyntaxException e) {
                LoggerRepository2.getLogger((String)DesktopUtil.class.getName(), null).error("Failed to display the help document for docsetId: " + docsetId + " : " + e.getMessage());
                if (displayMes == null) break block12;
                DesktopUtil.displayMessage(displayMes, 0);
            }
        }
    }

    private static boolean execCommand(String command) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    return false;
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void displayMessage(String sMessage) {
        JOptionPane.showMessageDialog(null, sMessage, DesktopUtil.getDefaultTitle(2), 2);
    }

    private static void displayMessage(String sMessage, int eType) {
        JOptionPane.showMessageDialog(null, sMessage, DesktopUtil.getDefaultTitle(eType), eType);
    }

    private static String getDefaultTitle(int eType) {
        String sTitleRes;
        switch (eType) {
            case 2: {
                sTitleRes = "Common.warning.txt";
                break;
            }
            case 0: {
                sTitleRes = "Common.error.txt";
                break;
            }
            case -1: {
                return "";
            }
            default: {
                sTitleRes = "Common.information.txt";
            }
        }
        return RB.getStringResource(sTitleRes);
    }
}

