/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.swing.models.CollectionToTableModelAdapter;
import com.sas.table.MutableTableColumnsInterface;
import com.sas.util.ListFactory;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class ValueItemsToTableModelAdapter
extends CollectionToTableModelAdapter
implements MutableTableColumnsInterface {
    public static final String LABEL_COLUMN = "LABEL";
    public static final String VALUE_COLUMN = "VALUE";
    private SupportedSpecialValues specialValues;
    private List columnOrder;
    private Map columnNames;

    public ValueItemsToTableModelAdapter(Collection c) {
        super(c);
        if (this.columnOrder == null) {
            this.columnOrder = new ArrayList();
            this.columnOrder.add(LABEL_COLUMN);
        }
    }

    public ValueItemsToTableModelAdapter(Collection c, SupportedSpecialValues specialValues, Locale locale) {
        super(c);
        this.specialValues = specialValues;
        this.setSpecialValues(specialValues, locale);
    }

    public void setSpecialValues(SupportedSpecialValues specialValues, Locale locale) {
        this.specialValues = specialValues;
        if (this.model != null && specialValues != null && this.specialValues != null && this.isSpecialValuesAvailable(specialValues)) {
            ArrayList<ValueItem> tempCollection = new ArrayList<ValueItem>();
            if (specialValues.isAllSupported()) {
                tempCollection.add(new ValueItem((Object)SpecialValues.ALL.toString(locale), (Object)SpecialValues.ALL));
            }
            if (specialValues.isOtherSupported()) {
                tempCollection.add(new ValueItem((Object)SpecialValues.OTHER.toString(locale), (Object)SpecialValues.OTHER));
            }
            tempCollection.addAll(this.model);
            this.setModel(tempCollection);
        }
    }

    @Override
    public int getColumnCount() {
        if (this.columnOrder == null) {
            this.columnOrder = new ArrayList();
            this.columnOrder.add(LABEL_COLUMN);
        }
        return this.columnOrder.size();
    }

    public List getColumns() {
        return ListFactory.newList((Collection)this.columnOrder);
    }

    public void setColumns(List columns) {
        if (columns != null && !Util.equal((Object)columns, (Object)this.columnOrder)) {
            this.columnOrder = columns;
            this.fireTableStructureChanged();
        }
    }

    private String getNameForLocation(String location) {
        int index = location.lastIndexOf(47);
        if (index != -1 && (index = (location = location.substring(index + 1)).lastIndexOf(40)) != -1) {
            location = location.substring(0, index);
        }
        return location;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List columnOrder = this.getColumns();
        String type = LABEL_COLUMN;
        if (columnIndex < columnOrder.size()) {
            type = (String)columnOrder.get(columnIndex);
        }
        Object obj = super.getValueAt(rowIndex, 0);
        if (type == LABEL_COLUMN) {
            return obj;
        }
        if (columnIndex < columnOrder.size()) {
            if (obj instanceof ValueItem) {
                if (type == VALUE_COLUMN) {
                    Object valueObj = ((ValueItem)obj).getValue();
                    if (valueObj instanceof DataSourceColumnInterface) {
                        return this.getNameForLocation(((DataSourceColumnInterface)valueObj).getDataSource().getDataSourceLocation());
                    }
                    return valueObj;
                }
                Object att = ((ValueItem)obj).getAttribute(type);
                if (att instanceof Collection) {
                    Collection path = (Collection)att;
                    StringBuffer returnString = new StringBuffer();
                    if (path != null) {
                        Iterator iter = path.iterator();
                        while (iter.hasNext()) {
                            Object element = iter.next();
                            returnString.append("[");
                            returnString.append(element);
                            returnString.append("]");
                            if (!iter.hasNext()) continue;
                            returnString.append(".");
                        }
                    }
                    return returnString.toString();
                }
                return att;
            }
            return obj;
        }
        return obj;
    }

    private boolean isSpecialValuesAvailable(SupportedSpecialValues values) {
        return values != null && (values.isAllSupported() || values.isMissingValuesSupported() || values.isOtherSupported());
    }

    @Override
    public void setModel(Collection collection) {
        Collection oldModel = this.model;
        if (oldModel != collection) {
            this.model = collection;
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, this.model);
        }
    }

    public boolean containsSpecialValue() {
        for (Object obj : this.values) {
            if (!(obj instanceof ValueItem) || ((ValueItem)obj).getValue() != SpecialValues.OTHER && ((ValueItem)obj).getValue() != SpecialValues.ALL) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setColumnName(String columnName, int columnIndex) {
        if (this.columnNames == null) {
            this.columnNames = new HashMap();
        }
        Integer key = new Integer(columnIndex);
        String oldName = this.getColumnName(columnIndex);
        if (!Util.equal((Object)oldName, (Object)columnName)) {
            this.columnNames.put(key, columnName);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columnNames == null || !this.columnNames.containsKey(new Integer(columnIndex))) {
            return super.getColumnName(columnIndex);
        }
        return (String)this.columnNames.get(new Integer(columnIndex));
    }

    public String getValue(String label) {
        if (this.model != null) {
            for (ValueItem item : this.model) {
                if (!item.getLabel().equals(label)) continue;
                return item.getValue().toString();
            }
        }
        return null;
    }

    public void addRow(ValueItem item) {
        Collection oldModel = this.model;
        Collection items = this.model;
        items.add(item);
        this.refresh();
        this.spcs.firePropertyChange("model", oldModel, this.model);
        this.fireTableStructureChanged();
    }
}

