/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.event.SwingPropertyChangeSupport;

public class MapToListModelAdapter
extends AbstractListModel
implements PropertyChangeSource {
    protected List delegate;
    protected Map model;
    protected boolean showKeysOnly;
    protected SwingPropertyChangeSupport spcs;

    public MapToListModelAdapter() {
        this.delegate = new ArrayList();
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public MapToListModelAdapter(int size) {
        this.delegate = new ArrayList(size);
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    public MapToListModelAdapter(Map m) {
        this(m, false);
    }

    public MapToListModelAdapter(Map m, boolean showKeysOnly) {
        this.model = m;
        this.showKeysOnly = showKeysOnly;
        this.createDelegate();
        this.spcs = new SwingPropertyChangeSupport(this);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.delegate.get(i);
    }

    public void setModel(Map model) {
        Map oldModel = this.model;
        if (oldModel != model) {
            this.model = model;
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, model);
        }
    }

    public Map getModel() {
        return this.model;
    }

    public void setShowKeysOnly(boolean showKeysOnly) {
        boolean oldShowKeysOnly = this.showKeysOnly;
        if (oldShowKeysOnly != showKeysOnly) {
            this.showKeysOnly = showKeysOnly;
            this.refresh();
            this.spcs.firePropertyChange("showKeysOnly", oldShowKeysOnly, showKeysOnly);
        }
    }

    public boolean getShowKeysOnly() {
        return this.showKeysOnly;
    }

    protected void createDelegate() {
        this.delegate = this.getShowKeysOnly() ? new ArrayList(this.model.keySet()) : new ArrayList(this.model.entrySet());
    }

    public void refresh() {
        this.createDelegate();
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }
}

