/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.PropertyChangeSource;
import com.sas.codepolicy.SASScope;
import com.sas.models.itemlistmanager.MoveRowInterface;
import com.sas.swing.models.TableModelInsertRowSupport;
import com.sas.table.AccurateRowCountInterface;
import com.sas.table.DeleteRowInterface;
import com.sas.table.InsertRowInterface;
import com.sas.util.UncheckedException;
import com.sas.util.Util;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

@SASScope
public class CollectionToTableModelAdapter
extends AbstractTableModel
implements PropertyChangeSource,
InsertRowInterface,
DeleteRowInterface,
MoveRowInterface,
com.sas.models.itemlistmanager.InsertRowInterface,
com.sas.models.itemlistmanager.DeleteRowInterface,
AccurateRowCountInterface {
    protected List values;
    protected Collection model;
    protected String columnName;
    protected boolean tableEditable;
    protected SwingPropertyChangeSupport spcs = new SwingPropertyChangeSupport(this);
    protected TableModelInsertRowSupport helper = new TableModelInsertRowSupport();
    private boolean committingRow;

    public CollectionToTableModelAdapter(Collection c) {
        this.setModel(c);
        this.createDelegate();
    }

    @Override
    public int getRowCount() {
        int rowCount = this.values.size();
        if (this.helper.isUncommittedRowPresent()) {
            ++rowCount;
        }
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.helper.isUncommittedRowPresent()) {
            if (rowIndex == this.helper.getUncommittedRowNumber()) {
                return this.helper.getValueAt(columnIndex);
            }
            rowIndex = this.helper.getAdjustedRowNumber(rowIndex);
        }
        if (columnIndex == 0) {
            return this.values.get(rowIndex);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object oldValue;
        if (this.helper.isUncommittedRowPresent()) {
            if (rowIndex == this.helper.getUncommittedRowNumber()) {
                this.helper.setValueAt(aValue, columnIndex);
                return;
            }
            rowIndex = this.helper.getAdjustedRowNumber(rowIndex);
        }
        if (Util.unequal(oldValue = this.values.get(rowIndex), (Object)aValue)) {
            ((List)this.model).set(rowIndex, aValue);
            this.values.set(rowIndex, aValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isTableEditable() && (columnIndex == 0 || rowIndex == this.getUncommittedRowNumber());
    }

    public void setModel(Collection collection) {
        Collection oldModel = this.model;
        if (oldModel != collection) {
            this.model = collection;
            this.refresh();
            this.spcs.firePropertyChange("model", oldModel, this.model);
        }
    }

    public Collection getModel() {
        return this.model;
    }

    public void setColumnName(String columnName, int columnIndex) {
        String oldColumnName = columnName;
        if (Util.unequal((Object)oldColumnName, (Object)columnName)) {
            this.columnName = columnName;
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.columnName == null) {
            return super.getColumnName(columnIndex);
        }
        return this.columnName;
    }

    public boolean isTableEditable() {
        return this.tableEditable && this.model instanceof List;
    }

    public void setTableEditable(boolean editable) {
        if (this.tableEditable != editable) {
            this.tableEditable = editable;
            this.spcs.firePropertyChange("tableEditable", !editable, editable);
        }
    }

    protected void createDelegate() {
        this.values = this.model != null ? new ArrayList(this.model) : new ArrayList(0);
    }

    public void refresh() {
        this.createDelegate();
        this.fireTableDataChanged();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.spcs.removePropertyChangeListener(listener);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "model"}, {"Property editor class", "com.sas.beans.editors._InstanceEditor"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    @Override
    public int insertRow(int row) {
        return this.insertRow(null, row);
    }

    @Override
    public int insertRow(Object[] rowData, int row) {
        if (this.canInsertRow(row)) {
            Collection collection = this.getModel();
            if (row == -1) {
                if (rowData != null && rowData.length > 0) {
                    this.values.add(rowData[0]);
                    collection.add(rowData[0]);
                } else {
                    this.values.add(null);
                    collection.add(null);
                }
                row = this.values.size() - 1;
            } else if (rowData != null && rowData.length > 0) {
                this.values.add(row, rowData[0]);
                collection.add(rowData[0]);
            } else {
                this.values.add(row, null);
                collection.add(null);
            }
        } else {
            return -1;
        }
        this.fireTableRowsInserted(row, row);
        return row;
    }

    @Override
    public boolean canInsertRow(int row) {
        return this.isRowInsertionAllowed();
    }

    @Override
    public boolean canDeleteRow(int index) {
        return this.isRowDeletionAllowed();
    }

    public void insertUncommittedRow(int rowIndex) throws UncheckedException {
        if (this.isRowInsertionAllowed()) {
            this.helper.insertUncommittedRow((TableModel)this, rowIndex);
            rowIndex = this.getUncommittedRowNumber();
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitUncommittedRow() throws UncheckedException {
        try {
            Collection collection = this.getModel();
            this.committingRow = true;
            int rowIndex = this.getUncommittedRowNumber();
            Object[] temp = this.helper.commitUncommittedRow((TableModel)this);
            if (temp == null) {
                return;
            }
            if (rowIndex == -1) {
                this.values.add(temp[0]);
                collection.add(temp[0]);
            } else {
                this.values.add(rowIndex, temp[0]);
                collection.add(temp[0]);
            }
            this.fireTableDataChanged();
        }
        finally {
            this.committingRow = false;
        }
    }

    public void cancelUncommittedRow() throws UncheckedException {
        if (this.helper.isUncommittedRowPresent()) {
            int rowIndex = this.getUncommittedRowNumber();
            this.helper.cancelUncommittedRow((TableModel)this);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public boolean isUncommittedRowPresent() {
        return this.helper.isUncommittedRowPresent();
    }

    public int getUncommittedRowNumber() {
        return this.helper.getUncommittedRowNumber();
    }

    public boolean isRowInsertionAllowed() {
        return true;
    }

    public boolean isTableExtendOnly() {
        return false;
    }

    public boolean isRowUpdateAllowed() {
        return true;
    }

    @Override
    public void deleteRow(int rowIndex) {
        Object obj = this.values.get(rowIndex);
        this.getModel().remove(obj);
        this.values.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public boolean deleteAllRows() {
        boolean ret = false;
        if (this.isRowDeletionAllowed()) {
            int rc = this.getRowCount();
            this.values.clear();
            this.getModel().clear();
            this.fireTableRowsDeleted(0, rc - 1);
        }
        return ret;
    }

    public boolean isRowDeletionAllowed() {
        return true;
    }

    @Override
    public boolean isRowMovementAllowed() {
        return this.getModel() instanceof List;
    }

    @Override
    public boolean canMoveRow(int start, int end, int to) {
        return to >= 0 && to + (end - start) < this.getRowCount();
    }

    @Override
    public int moveRowRange(int start, int end, int to) {
        int last;
        int first;
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        CollectionToTableModelAdapter.rotate((List)this.getModel(), first, last + 1, shift);
        CollectionToTableModelAdapter.rotate(this.values, first, last + 1, shift);
        this.fireTableRowsUpdated(first, last);
        return to;
    }

    private static void rotate(List l, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = CollectionToTableModelAdapter.gcd(size, r);
        for (int i = 0; i < g; ++i) {
            int to = i;
            Object tmp = l.get(a + to);
            int from = (to + r) % size;
            while (from != i) {
                l.set(a + to, l.get(a + from));
                to = from;
                from = (to + r) % size;
            }
            l.set(a + to, tmp);
        }
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : CollectionToTableModelAdapter.gcd(j, i % j);
    }

    public boolean isAccurateRowCountAvailable() {
        return true;
    }
}

