/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.swing.adapters.RB;
import com.sas.swing.visuals.LabelView;
import com.sas.table.TableDataValidationInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class JTableClipboardAdapter
implements ActionListener {
    private String rowString;
    private String value;
    protected static Clipboard clipboard;
    protected StringSelection stringSelection;
    protected JTable table;
    private TransformInterface transform;
    protected static DateFormat df;
    public static final int VALIDATE_MODE = 0;
    public static final int UPDATE_MODE = 1;
    public static final String RB_KEY = "JTableClipboardAdapter.";

    public JTableClipboardAdapter(JTable table) {
        this.table = table;
        this.transform = new ObjectToStringTransform();
        ((ObjectToStringTransform)this.transform).setNullString("");
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        KeyStroke cut = KeyStroke.getKeyStroke(88, 2, false);
        table.registerKeyboardAction(this, "Copy", copy, 0);
        table.registerKeyboardAction(this, "Paste", paste, 0);
        table.registerKeyboardAction(this, "Cut", cut, 0);
    }

    protected static Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception ex) {
                clipboard = new Clipboard("Table Clipboard");
            }
        }
        return clipboard;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public void setTransform(TransformInterface newTransform) {
        if (this.transform != newTransform) {
            TransformInterface old = this.transform;
            this.transform = newTransform;
        }
    }

    public TransformInterface getTransform() {
        return this.transform;
    }

    public void copySelectedCells() {
        this.copyCellsToClipboard(false, null);
    }

    public void cutSelectedCells() {
        this.copyCellsToClipboard(true, null);
        this.table.repaint();
    }

    protected void copyCellsToClipboard(boolean replace, String replaceString) {
        int numCols = this.table.getSelectedColumnCount();
        int numRows = this.table.getSelectedRowCount();
        int[] rowsSelected = this.table.getSelectedRows();
        int[] colsSelected = this.table.getSelectedColumns();
        int colCount = this.table.getColumnCount();
        Class[] colClasses = new Class[colCount];
        for (int i = 0; i < colCount; ++i) {
            colClasses[i] = this.table.getModel().getColumnClass(i);
        }
        StringBuffer sbf = new StringBuffer();
        TableModel model = this.table.getModel();
        boolean isValid = true;
        if (replace && model instanceof TableDataValidationInterface) {
            isValid = this.validateOrCopyCellsToClipboard(replace, replaceString, sbf, numCols, numRows, rowsSelected, colsSelected, 0);
        }
        if (isValid) {
            this.validateOrCopyCellsToClipboard(replace, replaceString, sbf, numCols, numRows, rowsSelected, colsSelected, 1);
            this.stringSelection = new StringSelection(sbf.toString());
            JTableClipboardAdapter.getClipboard().setContents(this.stringSelection, this.stringSelection);
        }
    }

    private boolean validateOrCopyCellsToClipboard(boolean replace, String replaceString, StringBuffer sbf, int numCols, int numRows, int[] rowsSelected, int[] colsSelected, int validateUpdateMode) {
        boolean appendFlag;
        boolean flag = true;
        boolean bl = appendFlag = validateUpdateMode == 1;
        if (this.table.getCellSelectionEnabled()) {
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(rowsSelected[i], colsSelected[j])));
                    this.append(sbf, value, appendFlag);
                    if (replace && this.table.isCellEditable(rowsSelected[i], colsSelected[j]) && !(flag = this.setOrValidateValue(replaceString, rowsSelected[i], colsSelected[j], validateUpdateMode))) {
                        this.displayCutError(replaceString, rowsSelected[i], colsSelected[j]);
                        return flag;
                    }
                    if (j >= numCols - 1) continue;
                    this.append(sbf, "\t", appendFlag);
                }
                this.append(sbf, "\n", appendFlag);
            }
        } else if (this.table.getColumnSelectionAllowed()) {
            numRows = this.table.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(i, colsSelected[j])));
                    this.append(sbf, value, appendFlag);
                    if (replace && this.table.isCellEditable(i, colsSelected[j]) && !(flag = this.setOrValidateValue(replaceString, i, colsSelected[j], validateUpdateMode))) {
                        this.displayCutError(replaceString, i, colsSelected[j]);
                        return flag;
                    }
                    if (j >= numCols - 1) continue;
                    this.append(sbf, "\t", appendFlag);
                }
                this.append(sbf, "\n", appendFlag);
            }
        } else if (this.table.getRowSelectionAllowed()) {
            numCols = this.table.getColumnCount();
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    Object value = this.replaceNull(this.transform(this.table.getValueAt(rowsSelected[i], j)));
                    this.append(sbf, value, appendFlag);
                    if (replace && this.table.isCellEditable(rowsSelected[i], j) && !(flag = this.setOrValidateValue(replaceString, rowsSelected[i], j, validateUpdateMode))) {
                        this.displayCutError(replaceString, rowsSelected[i], j);
                        return flag;
                    }
                    if (j >= numCols - 1) continue;
                    this.append(sbf, "\t", appendFlag);
                }
                this.append(sbf, "\n", appendFlag);
            }
        } else {
            return false;
        }
        return flag;
    }

    protected void append(StringBuffer sbf, Object value, boolean appendFlag) {
        if (appendFlag) {
            sbf.append(value);
        }
    }

    protected boolean setOrValidateValue(Object value, int row, int col, int validateUpdateMode) {
        if (validateUpdateMode == 1) {
            this.table.setValueAt(value, row, col);
        } else if (validateUpdateMode == 0) {
            return ((TableDataValidationInterface)this.table.getModel()).validate(value, row, col);
        }
        return true;
    }

    protected Object transform(Object value) {
        if (this.transform != null) {
            try {
                return this.transform.transform(value);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return value;
    }

    protected Object replaceNull(Object value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void pasteSelectedCells() {
        int startRow = 0;
        int startCol = 0;
        int numRows = this.table.getRowCount();
        int numCols = this.table.getColumnCount();
        int[] rowsSelected = this.table.getSelectedRows();
        int[] colsSelected = this.table.getSelectedColumns();
        Class[] colClasses = new Class[numCols];
        for (int i = 0; i < numCols; ++i) {
            colClasses[i] = this.table.getModel().getColumnClass(i);
        }
        TableModel model = this.table.getModel();
        boolean isValid = true;
        if (model instanceof TableDataValidationInterface) {
            isValid = this.validateOrPasteClipboardToCells(startRow, startCol, numRows, numCols, rowsSelected, colsSelected, colClasses, 0);
        }
        if (isValid) {
            this.validateOrPasteClipboardToCells(startRow, startCol, numRows, numCols, rowsSelected, colsSelected, colClasses, 1);
        }
        this.table.repaint();
    }

    private boolean validateOrPasteClipboardToCells(int startRow, int startCol, int numRows, int numCols, int[] rowsSelected, int[] colsSelected, Class[] colClasses, int validateUpdateMode) {
        boolean flag;
        block33: {
            flag = true;
            if (this.table.getSelectedRowCount() > 0) {
                startRow = this.table.getSelectedRows()[0];
            }
            if (this.table.getSelectedColumnCount() > 0) {
                startCol = this.table.getSelectedColumns()[0];
            }
            if (this.table.getCellSelectionEnabled()) {
                if (this.table.getSelectedRowCount() > 1) {
                    numRows = this.table.getSelectedRowCount();
                }
                if (this.table.getSelectedColumnCount() > 1) {
                    numCols = this.table.getSelectedColumnCount();
                }
            } else if (this.table.getColumnSelectionAllowed()) {
                if (this.table.getSelectedColumnCount() > 1) {
                    numCols = this.table.getSelectedColumnCount();
                }
                startRow = 0;
            } else if (this.table.getRowSelectionAllowed()) {
                if (this.table.getSelectedRowCount() > 1) {
                    numRows = this.table.getSelectedRowCount();
                }
                startCol = 0;
            }
            try {
                Transferable transfer = JTableClipboardAdapter.getClipboard().getContents(this);
                if (!transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) break block33;
                String data = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                List clipboardGrid = JTableClipboardAdapter.parseContents(data);
                if (clipboardGrid.isEmpty()) {
                    return true;
                }
                int rowCount = clipboardGrid.size();
                int colCount = 1;
                for (int i = 0; i < rowCount; ++i) {
                    if (((List)clipboardGrid.get(i)).size() <= colCount) continue;
                    colCount = ((List)clipboardGrid.get(i)).size();
                }
                int iTemp = 0;
                int jTemp = 0;
                for (int rIdx = 0; rIdx < rowCount && rIdx < numRows; ++rIdx) {
                    List colList = (List)clipboardGrid.get(rIdx);
                    for (int cIdx = 0; cIdx < colCount && cIdx < numCols; ++cIdx) {
                        Object setValue;
                        String value = null;
                        value = cIdx < colList.size() ? colList.get(cIdx) : "";
                        if (this.table.getCellSelectionEnabled()) {
                            if (rIdx < rowsSelected.length) {
                                iTemp = rowsSelected[rIdx] - rIdx - startRow;
                            }
                            if (cIdx < colsSelected.length) {
                                jTemp = colsSelected[cIdx] - cIdx - startCol;
                            }
                        } else if (this.table.getRowSelectionAllowed()) {
                            if (rIdx < rowsSelected.length) {
                                iTemp = rowsSelected[rIdx] - rIdx - startRow;
                            }
                        } else if (this.table.getColumnSelectionAllowed() && cIdx < colsSelected.length) {
                            jTemp = colsSelected[cIdx] - cIdx - startCol;
                        }
                        if (startRow + rIdx + iTemp >= this.table.getRowCount() || startCol + cIdx + jTemp >= this.table.getColumnCount() || !this.table.isCellEditable(startRow + rIdx + iTemp, startCol + cIdx + jTemp)) continue;
                        int setRow = startRow + rIdx + iTemp;
                        int setCol = startCol + cIdx + jTemp;
                        if (this.getTransform() instanceof ObjectToStringTransform && value != null && value.equals(((ObjectToStringTransform)this.getTransform()).getDotString())) {
                            value = "";
                        }
                        if (BaseTransforms.defaultInstance.isTransformable(String.class, colClasses[setCol])) {
                            setValue = null;
                            try {
                                setValue = BaseTransforms.defaultInstance.transform((Object)value, colClasses[setCol]);
                            }
                            catch (Exception ex) {
                                flag = false;
                                this.displayPasteError(value, setRow, setCol);
                                return flag;
                            }
                            flag = this.setOrValidateValue(setValue, setRow, setCol, validateUpdateMode);
                            if (flag) continue;
                            this.displayPasteError(value, setRow, setCol);
                            return flag;
                        }
                        if (colClasses[setCol] == Date.class) {
                            setValue = null;
                            try {
                                setValue = df.parse(value);
                                flag = this.setOrValidateValue(setValue, setRow, setCol, validateUpdateMode);
                                if (!flag) {
                                    this.displayPasteError(value, setRow, setCol);
                                    return flag;
                                }
                            }
                            catch (ParseException ex) {
                                ex.printStackTrace();
                                flag = false;
                            }
                            continue;
                        }
                        flag = this.setOrValidateValue(value, setRow, setCol, validateUpdateMode);
                        if (flag) continue;
                        this.displayPasteError(value, setRow, setCol);
                        return flag;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return flag;
    }

    protected static List parseContents(String textGrid) {
        StringTokenizer rowTokens = new StringTokenizer(textGrid, "\n", true);
        ArrayList grid = new ArrayList(Strings.count((String)textGrid, (int)0, (int)-1, (char)'\n'));
        int rowTokenPos = 0;
        while (rowTokens.hasMoreTokens()) {
            ArrayList<String> valuesList = new ArrayList<String>();
            String textRow = rowTokens.nextToken();
            if (textRow.equals("\n")) {
                if (rowTokenPos == 0 && grid.size() == 0) {
                    grid.add(valuesList);
                }
                if (rowTokens.hasMoreTokens()) {
                    grid.add(valuesList);
                }
                ++rowTokenPos;
                continue;
            }
            StringTokenizer colTokens = new StringTokenizer(textRow, "\t", true);
            int colTokenPos = 0;
            while (colTokens.hasMoreTokens()) {
                String textValue = colTokens.nextToken();
                if (textValue.equals("\t")) {
                    if (colTokenPos == 0 && valuesList.size() == 0) {
                        valuesList.add("");
                    }
                    valuesList.add("");
                    ++colTokenPos;
                    continue;
                }
                if (textValue == null) {
                    textValue = "";
                }
                if (colTokenPos == 0) {
                    valuesList.add(textValue);
                    continue;
                }
                valuesList.set(colTokenPos, textValue);
            }
            if (rowTokenPos == 0) {
                grid.add(valuesList);
                continue;
            }
            grid.set(rowTokenPos, valuesList);
        }
        return grid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            this.copySelectedCells();
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            this.pasteSelectedCells();
        }
        if (e.getActionCommand().compareTo("Cut") == 0) {
            this.cutSelectedCells();
        }
    }

    protected void displayCutError(Object value, int row, int col) {
        this.showMessage("errorCuttingCell.txt", "errorCuttingValue.txt", value, row, col);
    }

    protected void displayPasteError(Object value, int row, int col) {
        this.showMessage("errorPastingCell.txt", "errorPastingValue.txt", value, row, col);
    }

    private void showMessage(String titleKey, String msgKey, Object value, int row, int col) {
        Message msg = new Message(RB.getStringResource(RB_KEY, msgKey), value, (Object)String.valueOf(row), (Object)String.valueOf(col), null);
        String title = RB.getStringResource(RB_KEY, titleKey);
        LabelView label = new LabelView();
        label.setReplaceNewline(false);
        label.setReplaceTab(false);
        label.setText(msg.toString());
        label.setPreferredSpanSize(new Dimension(Math.max(100, Toolkit.getDefaultToolkit().getScreenSize().width - 150), -1));
        JOptionPane.showMessageDialog(null, label, title, 0);
    }

    static {
        df = DateFormat.getDateTimeInstance();
    }
}

