/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.codepolicy.SASScope;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

@SASScope
public class EditNavigationalAction
extends AbstractAction {
    protected int dx;

    public EditNavigationalAction(int dx) {
        this.dx = dx;
    }

    protected Point getNextCellLocation(JTable table, int currentRow, int currentCol, int dx) {
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        int newRow = currentRow;
        int newColumn = currentCol + dx;
        if (newColumn < 0) {
            newColumn = columnCount - 1;
            newRow += dx;
        } else if (newColumn >= columnCount) {
            newColumn = 0;
            newRow += dx;
        }
        if (newRow >= rowCount) {
            newRow = 0;
        } else if (newRow < 0) {
            newRow = rowCount - 1;
        }
        return new Point(newRow, newColumn);
    }

    protected Point moveToEditableCell(JTable table, int currentRow, int currentCol, int dx, int currentCount) {
        int rowCount = table.getRowCount();
        if (currentCount >= rowCount) {
            return new Point(-1, -1);
        }
        ++currentCount;
        Point nextLoc = this.getNextCellLocation(table, currentRow, currentCol, dx);
        TableModel tableModel = table.getModel();
        if (tableModel.isCellEditable(nextLoc.x, table.convertColumnIndexToModel(nextLoc.y))) {
            return nextLoc;
        }
        return this.moveToEditableCell(table, nextLoc.x, nextLoc.y, dx, currentCount);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTable table = (JTable)e.getSource();
        ListSelectionModel rowSelectionModel = table.getSelectionModel();
        ListSelectionModel columnSelectionModel = table.getColumnModel().getSelectionModel();
        int anchorRow = rowSelectionModel.getAnchorSelectionIndex();
        int anchorColumn = columnSelectionModel.getAnchorSelectionIndex();
        if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
            return;
        }
        Point cell = this.moveToEditableCell(table, anchorRow, anchorColumn, this.dx, 0);
        if (cell.x < 0 || cell.y < 0) {
            cell = this.getNextCellLocation(table, anchorRow, anchorColumn, this.dx);
        }
        int selRowStart = rowSelectionModel.getMinSelectionIndex();
        int selRowEnd = rowSelectionModel.getMaxSelectionIndex();
        int selColStart = columnSelectionModel.getMinSelectionIndex();
        int selColEnd = columnSelectionModel.getMaxSelectionIndex();
        if (cell.x >= selRowStart && cell.x <= selRowEnd && cell.y >= selColStart && cell.y <= selColEnd) {
            table.changeSelection(cell.x, cell.y, true, true);
        } else {
            table.changeSelection(cell.x, cell.y, false, false);
        }
        final Point cell2 = cell;
        final JTable table2 = table;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component editorComp;
                if (table2.editCellAt(cell2.x, cell2.y) && (editorComp = table2.getEditorComponent()) != null) {
                    editorComp.requestFocus();
                }
            }
        });
    }
}

