/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.adapters;

import com.sas.codepolicy.SASScope;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@SASScope
public class ButtonRolloverAdapter
implements ChangeListener {
    protected boolean initRollover;
    protected AbstractButton button;

    public ButtonRolloverAdapter(AbstractButton btn) {
        this.setButton(btn);
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public void setButton(AbstractButton btn) {
        if (this.button != null) {
            this.button.getModel().removeChangeListener(this);
        }
        this.button = btn;
        this.initButton();
        if (this.button != null) {
            this.initRollover = this.button.getModel().isRollover();
            this.button.getModel().addChangeListener(this);
        }
    }

    protected void initButton() {
        if (this.button == null) {
            return;
        }
        this.button.setBorderPainted(false);
        this.button.setRolloverEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object eSource = evt.getSource();
        if (eSource instanceof ButtonModel && this.initRollover != this.button.getModel().isRollover()) {
            this.initRollover = this.button.getModel().isRollover();
            this.buttonRolloverChanged(this.initRollover);
        }
    }

    protected void buttonRolloverChanged(boolean rollover) {
        this.button.setBorderPainted(rollover);
    }
}

