/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTreeInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.tree.ExtendedNegationLogicInterface;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTree;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class SimpleFilterLogicTreeAdapter
implements SimpleFilterLogicTreeInterface,
ExtendedNegationLogicInterface {
    SimpleFilterLogicTree logicTree;
    TransformInterface inTransform;
    TransformInterface outTransform;
    Object rootFilterItem;

    @SASScope
    public SimpleFilterLogicTreeAdapter() {
        this(null, null, null);
    }

    public SimpleFilterLogicTreeAdapter(SimpleFilterLogicTree logic) {
        this(logic, null, null);
    }

    public SimpleFilterLogicTreeAdapter(SimpleFilterLogicTree logic, TransformInterface inTransform, TransformInterface outTransform) {
        if (logic == null) {
            logic = new SimpleFilterLogicTree();
        }
        this.logicTree = logic;
        this.inTransform = inTransform;
        this.outTransform = outTransform;
    }

    @Override
    public void addLeafAt(int index, FilterLogicTestNodeInterface leaf) {
        this.logicTree.addLeaf(index, leaf);
    }

    @Override
    public FilterLogicTestNodeInterface setLeafAt(int index, FilterLogicTestNodeInterface leaf) {
        return this.logicTree.setLeaf(index, leaf);
    }

    @Override
    public FilterLogicTestNodeInterface removeLeafAt(int index) {
        return this.logicTree.removeLeaf(index);
    }

    @Override
    public FilterLogicTestNodeInterface getLeafAt(int index) {
        return this.logicTree.getLeaf(index);
    }

    @Override
    public void refreshNodeList() {
        this.logicTree.refreshFilterList();
    }

    @Override
    public boolean areAllNodesUnderstood() {
        return true;
    }

    @Override
    public List getUnderstoodTestNodeList() {
        return this.logicTree.getFilterList();
    }

    @Override
    public Object getRootFilterItem() {
        return this.rootFilterItem;
    }

    @Override
    public boolean isLeafNegated(int index) {
        return this.logicTree.isLeafNegated(index);
    }

    @Override
    public void setLeafNegated(int index, boolean value) {
        this.logicTree.setLeafNegated(index, value);
    }

    @Override
    public String getLeafConditionalRelationType(int index) {
        ConditionalRelationType type = this.logicTree.getConditionalRelationType(index);
        if (type != null) {
            return type.toString();
        }
        return null;
    }

    @Override
    public void setLeafConditionalRelationType(int index, String value) {
        ConditionalRelationType type = ConditionalRelationType.findType(value);
        this.logicTree.setConditionalRelationType(index, type);
    }

    @Override
    public void splitGroup(int indexOfMember) {
        this.logicTree.splitOnMember(indexOfMember);
    }

    @Override
    public void groupLeaves(int startIndex, int endIndex) {
        this.logicTree.groupLeaves(startIndex, endIndex);
    }

    @Override
    public void moveLeafUp(int index) {
        this.logicTree.moveLeafUp(index);
        this.refreshNodeList();
    }

    @Override
    public void moveLeafDown(int index) {
        this.logicTree.moveLeafDown(index);
        this.refreshNodeList();
    }

    @Override
    public boolean isLeafGrouped(int index) {
        return this.logicTree.isLeafGrouped(index);
    }

    @Override
    public boolean canGroupLeaves(int firstIndex, int lastIndex) {
        return this.logicTree.canGroupLeaves(firstIndex, lastIndex);
    }

    @Override
    public void clear() {
        this.logicTree.clear();
        this.refreshNodeList();
    }

    @Override
    public boolean commitTree() {
        try {
            if (this.outTransform != null) {
                this.rootFilterItem = this.outTransform.transform((Object)this.logicTree);
                return true;
            }
        }
        catch (TransformException e) {
            this.rootFilterItem = null;
        }
        return false;
    }

    @Override
    public void cancel(Object initialFilter) {
        this.setFilterObject(initialFilter);
    }

    public void setFilterObject(Object filterObject) {
        this.rootFilterItem = filterObject;
        if (filterObject == null) {
            this.clear();
        } else {
            TreeNode newRoot = null;
            try {
                Object o = this.inTransform.transform(filterObject);
                if (o instanceof TreeModel) {
                    o = ((TreeModel)o).getRoot();
                }
                if (o instanceof TreeNode) {
                    newRoot = (TreeNode)o;
                }
            }
            catch (TransformException e) {
                newRoot = null;
            }
            this.logicTree.setRoot(newRoot);
        }
        this.logicTree.refreshFilterList();
    }

    @Override
    public SimpleFilterLogicTreeInterface copy() {
        return this.copy(false);
    }

    @Override
    public SimpleFilterLogicTreeInterface copy(boolean copyTestNodes) {
        FilterLogicTreeInterface newLogicTree = this.logicTree.copy();
        SimpleFilterLogicTree newTree = new SimpleFilterLogicTree(newLogicTree);
        return new SimpleFilterLogicTreeAdapter(newTree, this.inTransform, this.outTransform);
    }

    @Override
    public FilterLogicBaseNodeInterface getRoot() {
        Object root;
        if (this.logicTree != null && (root = this.logicTree.getRoot()) instanceof FilterLogicBaseNodeInterface) {
            return (FilterLogicBaseNodeInterface)root;
        }
        return null;
    }

    @Override
    public FilterLogicBaseNodeInterface setRoot(FilterLogicBaseNodeInterface root) {
        if (this.logicTree != null) {
            FilterLogicBaseNodeInterface oldRoot = this.getRoot();
            this.logicTree.setRoot(root);
            return oldRoot;
        }
        return null;
    }

    @Override
    public FilterItemInterface findMatchingFilterItem(Object itemObject) {
        throw new UnsupportedOperationException("FIXME!!!");
    }

    @Override
    public int getFirstLeafInGroup(int memberIndex) {
        throw new UnsupportedOperationException("FIXME!!!");
    }

    @Override
    public int getLastLeafInGroup(int memberIndex) {
        throw new UnsupportedOperationException("FIXME!!!");
    }

    public TransformInterface getInputTransform() {
        return this.inTransform;
    }

    public void setInputTransform(TransformInterface inTransform) {
        this.inTransform = inTransform;
    }

    public TransformInterface getOutputTransform() {
        return this.outTransform;
    }

    public void setOutputTransform(TransformInterface outTransform) {
        this.outTransform = outTransform;
    }

    public SimpleFilterLogicTree getLogicTree() {
        return this.logicTree;
    }

    public void setLogicTree(SimpleFilterLogicTree logicTree) {
        if (logicTree != this.logicTree) {
            if (logicTree == null) {
                logicTree = new SimpleFilterLogicTree();
            }
            this.logicTree = logicTree;
            this.refreshNodeList();
            this.rootFilterItem = null;
        }
    }

    @Override
    public void add(SimpleFilterLogicTreeInterface tree) {
        if (tree != null) {
            this.add(tree.getRoot());
        }
    }

    @Override
    public void add(FilterLogicBaseNodeInterface rootNode) {
        if (this.logicTree != null && rootNode != null) {
            this.logicTree.add(rootNode);
            this.refreshNodeList();
        }
    }

    @Override
    @SASScope
    public boolean canSetNegation(int index, boolean value) {
        return true;
    }
}

