/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.timebased.RB;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.timebased.TimeCondition;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.text.Message;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;

@SASScope
public class RelativeTimeFilterValueFormatter
extends Format {
    static final long serialVersionUID = 1L;
    protected Locale locale;
    protected TimeCondition condition;
    public static final RelativeTimeFilterValueFormatter defaultInstance = new RelativeTimeFilterValueFormatter();
    public static final int FIRST = 0;
    public static final int LAST = 1;
    public static String RB_KEY = "RelativeTimeFilterValueFormatter.";

    public RelativeTimeFilterValueFormatter() {
        this(Locale.getDefault());
    }

    public RelativeTimeFilterValueFormatter(Locale locale) {
        this.locale = locale;
        this.condition = TimeCondition.CONDITION_RANGE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setFilterCondition(TimeCondition condition) {
        this.condition = condition;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Object objectToFormat = obj;
        if (objectToFormat instanceof FilterValueInterface) {
            FilterValueInterface value = (FilterValueInterface)objectToFormat;
            objectToFormat = value.getUnformattedValue();
        }
        if (objectToFormat instanceof RelativeTimeFilterData) {
            RelativeTimeFilterData filterData = (RelativeTimeFilterData)objectToFormat;
            toAppendTo.append(this.getDescriptionForTimePeriod(filterData));
        } else if (objectToFormat instanceof OLAPTimeBasedFilterAdapterInterface) {
            OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)objectToFormat;
            String formattedString = "";
            String showOption = adapter.getShowOption();
            String periodType = adapter.getLocalizedPeriodType();
            String periodString = adapter.getPeriodType();
            int timeLevelType = adapter.getPeriodType(periodString);
            String firstPeriodText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel(timeLevelType, 0);
            String lastPeriodText = RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel(timeLevelType, 1);
            String pluralPeriodType = adapter.getLocalizedSelectLabelParameter();
            String numberOfPeriods = adapter.getNumberOfPeriods();
            String selectedStartingValueText = adapter.getSelectedStartingPeriodLabel();
            String selectedEndingValueText = adapter.getSelectedEndingPeriodLabel();
            String currentFirstPeriodText = adapter.getCurrentFirstPeriodLabel();
            String currentLastPeriodText = adapter.getCurrentLastPeriodLabel();
            boolean isPlural = false;
            try {
                int n = Integer.parseInt(numberOfPeriods);
                if (n > 1) {
                    isPlural = true;
                }
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
            if (showOption.equals("NPERIODS")) {
                String periodLabel = isPlural ? pluralPeriodType : periodType;
                String selectOption = adapter.getSelectOption();
                if ("STARTINGPERIOD".equals(selectOption)) {
                    if ("FIRSTPERIOD".equals(adapter.getStartingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_FIRST_PERIODS_RELATIVE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)numberOfPeriods, (Object)periodLabel, (Object)firstPeriodText, (Object)currentFirstPeriodText);
                    } else if ("SELECTEDPERIOD".equals(adapter.getStartingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_FIRST_PERIODS_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)numberOfPeriods, (Object)periodLabel, (Object)selectedStartingValueText);
                    }
                } else if ("ENDINGPERIOD".equals(selectOption)) {
                    if ("LASTPERIOD".equals(adapter.getEndingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_LAST_PERIODS_RELATIVE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)numberOfPeriods, (Object)periodLabel, (Object)lastPeriodText, (Object)currentLastPeriodText);
                    } else if ("SELECTEDPERIOD".equals(adapter.getEndingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_LAST_PERIODS_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)numberOfPeriods, (Object)periodLabel, (Object)selectedEndingValueText);
                    }
                } else {
                    String format = "{0} {1}";
                    formattedString = Message.format((String)format, (Object)numberOfPeriods, (Object)periodLabel);
                }
            } else if (showOption.equals("RANGE")) {
                if ("FIRSTPERIOD".equals(adapter.getStartingPeriodOption())) {
                    if ("LASTPERIOD".equals(adapter.getEndingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_RANGE_RELATIVE_TO_RELATIVE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)pluralPeriodType, (Object)firstPeriodText, (Object)currentFirstPeriodText, (Object)lastPeriodText, (Object)currentLastPeriodText);
                    } else {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_RANGE_RELATIVE_TO_ABSOLUTE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)pluralPeriodType, (Object)firstPeriodText, (Object)currentFirstPeriodText, (Object)selectedEndingValueText);
                    }
                } else if ("SELECTEDPERIOD".equals(adapter.getStartingPeriodOption())) {
                    if ("LASTPERIOD".equals(adapter.getEndingPeriodOption())) {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_RANGE_ABSOLUTE_TO_RELATIVE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)pluralPeriodType, (Object)selectedStartingValueText, (Object)lastPeriodText, (Object)currentLastPeriodText);
                    } else {
                        String format = com.sas.swing.models.RB.getStringResource("AppliedFiltersUtil.", "TIME_RANGE_ABSOLUTE_TO_ABSOLUTE_FILTER.fmt.txt", this.locale);
                        formattedString = Message.format((String)format, (Object)pluralPeriodType, (Object)selectedStartingValueText, (Object)selectedEndingValueText);
                    }
                }
            } else if (showOption.equals("ACROSS")) {
                // empty if block
            }
            toAppendTo.append(formattedString);
        }
        return toAppendTo;
    }

    protected String getDescriptionForTimePeriod(RelativeTimeFilterData filterData) {
        String desc = "";
        if (filterData != null && filterData.getPeriod() != null) {
            if (TimeCondition.CONDITION_LAST_N_PERIODS.equals(this.condition) || TimeCondition.CONDITION_NEXT_N_PERIODS.equals(this.condition)) {
                desc = filterData.getPeriod().getDescription(filterData.getMultiplier(), filterData.getPeriodType(), this.locale);
            } else {
                TimePeriod timePeriod = filterData.getPeriod();
                if (TimePeriod.PERIOD_N_PERIODS_AGO.equals(timePeriod) || TimePeriod.PERIOD_N_PERIODS_FROM_NOW.equals(timePeriod)) {
                    TimePeriodType periodType = filterData.getPeriodType();
                    int n = filterData.getMultiplier();
                    String periodTypeDescriptiveText = this.getDescriptionForTimePeriod(periodType, n);
                    String format = TimePeriod.PERIOD_N_PERIODS_AGO.equals(timePeriod) ? RB.getStringResource("Period.NPeriods.Ago.description.txt", this.locale) : RB.getStringResource("Period.NPeriods.FromNow.description.txt", this.locale);
                    desc = Message.format((String)format, (Object)new Integer(n), (Object)periodTypeDescriptiveText);
                } else if (filterData.getPeriod() != null) {
                    desc = filterData.getPeriod().getDescription(this.locale);
                }
            }
        }
        return desc;
    }

    protected String getDescriptionForTimePeriod(TimePeriodType periodType, int multiplier) {
        String periodDescription = "";
        periodDescription = multiplier == 1 ? periodType.getSingularDescription(this.locale) : periodType.getPluralDescription(this.locale);
        return periodDescription;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return source;
    }

    public static String getReadableTextForTimeLevel(int type, int firstOrLast) {
        Locale locale = Locale.getDefault();
        return RelativeTimeFilterValueFormatter.getReadableTextForTimeLevel(type, firstOrLast, locale);
    }

    public static String getReadableTextForTimeLevel(int type, int firstOrLast, Locale locale) {
        String text = "";
        switch (type) {
            case 1024: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstDay.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastDay.txt", locale);
                break;
            }
            case 64: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstHalfYear.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastHalfYear.txt", locale);
                break;
            }
            case 2048: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstHour.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastHour.txt", locale);
                break;
            }
            case 4096: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstMinute.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastMinute.txt", locale);
                break;
            }
            case 256: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstMonth.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastMonth.txt", locale);
                break;
            }
            case 128: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstQuarter.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastQuarter.txt", locale);
                break;
            }
            case 8192: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstSecond.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastSecond.txt", locale);
                break;
            }
            case 512: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstWeek.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastWeek.txt", locale);
                break;
            }
            case 32: {
                if (firstOrLast == 0) {
                    text = RB.getStringResource(RB_KEY, "firstYear.txt", locale);
                    break;
                }
                if (firstOrLast != 1) break;
                text = RB.getStringResource(RB_KEY, "lastYear.txt", locale);
            }
        }
        return text;
    }
}

