/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.RB;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeNodeInterface;
import com.sas.dataselectors.filters.tree.FilterReferenceNodeInterface;
import com.sas.dataselectors.filters.tree.LogicTreeToTextTransform;
import com.sas.dataselectors.filters.tree.LogicalConditionNodeInterface;
import com.sas.dataselectors.filters.tree.NotNodeInterface;
import com.sas.util.transforms.TransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class Util {
    public static final String RB_KEY = "Util.";
    public static String HTML_NBSP = "&nbsp;";
    public static String HTML_BREAK = "<br/>";
    public static String HTML_LEFT_PARENTHESIS = "(";
    public static String HTML_RIGHT_PARENTHESIS = ")";
    public static String TEXT_SPACE = " ";
    public static String TEXT_NEWLINE = System.getProperty("line.separator");
    public static String TEXT_LEFT_PARENTHESIS = "(";
    public static String TEXT_RIGHT_PARENTHESIS = ")";
    public static final int HTML = 0;
    public static final int TEXT = 1;
    public static final String FILTER_ITEM_MAP_ENTRY = "Text";
    public static final String VIRTUAL_FILTER_ITEM_MAP_ENTRY = "VirText";
    public static final String LOGICAL_CONDITION_MAP_ENTRY = "Cond";
    public static final String NESTING_MAP_ENTRY = "Nest";
    public static final String LOGICAL_NODE_MAP_ENTRY = "Node";

    public static String getFormattedExpressionString(SimpleFilterLogicTreeInterface tree, Locale locale, int outputType, int startSelection, int endSelection) {
        String result = null;
        if (tree != null) {
            LogicTreeToTextTransform transform = outputType == 0 ? LogicTreeToTextTransform.getHTMLFormattedTextTransform(locale) : LogicTreeToTextTransform.getFormattedTextTransform(locale);
            try {
                result = transform.transform(tree, startSelection, endSelection);
                if (result == null) {
                    result = "";
                }
            }
            catch (TransformException e) {
                result = null;
            }
        }
        return result;
    }

    public static String getFormattedExpressionString(List expressionList, int outputType, int startSelection, int endSelection) {
        Map endMap;
        int endIndent;
        Map startMap;
        int startIndent;
        String newline;
        String space;
        if (expressionList == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (outputType == 0) {
            space = HTML_NBSP;
            newline = HTML_BREAK;
        } else {
            space = TEXT_SPACE;
            newline = TEXT_NEWLINE;
        }
        int max = expressionList.size() - 1;
        int start = startSelection;
        int end = endSelection;
        if (start < 0) {
            start = 0;
        } else if (start > max) {
            start = max;
        }
        if (end < 0 || end > max) {
            end = max;
        }
        if (start > end) {
            int swap = start;
            start = end;
            end = swap;
        }
        if ((startIndent = ((Integer)(startMap = (Map)expressionList.get(start)).get(NESTING_MAP_ENTRY)).intValue()) > 0) {
            while (start > 0) {
                if ((startIndent = ((Integer)(startMap = (Map)expressionList.get(--start)).get(NESTING_MAP_ENTRY)).intValue()) != 0) continue;
                ++start;
                break;
            }
        }
        if ((endIndent = ((Integer)(endMap = (Map)expressionList.get(end)).get(NESTING_MAP_ENTRY)).intValue()) > 0) {
            while (end < max) {
                if ((endIndent = ((Integer)(endMap = (Map)expressionList.get(++end)).get(NESTING_MAP_ENTRY)).intValue()) != 0) continue;
                --end;
                break;
            }
        }
        int prevIndent = 0;
        for (int i = start; i < end; ++i) {
            Map currentFilter = (Map)expressionList.get(i);
            int currentIndent = (Integer)currentFilter.get(NESTING_MAP_ENTRY);
            int indent = currentIndent > prevIndent ? prevIndent : currentIndent;
            for (int j = 0; j < indent; ++j) {
                sb.append(space);
                sb.append(space);
            }
            sb.append((String)currentFilter.get(FILTER_ITEM_MAP_ENTRY));
            sb.append(newline);
            if (i <= end - 1) {
                Map nextFilter = (Map)expressionList.get(i + 1);
                int nextIndent = (Integer)nextFilter.get(NESTING_MAP_ENTRY);
                indent = currentIndent > nextIndent ? nextIndent : currentIndent;
                for (int j = 0; j < indent; ++j) {
                    sb.append(space);
                    sb.append(space);
                }
                sb.append((String)currentFilter.get(LOGICAL_CONDITION_MAP_ENTRY));
                sb.append(newline);
            }
            prevIndent = currentIndent;
        }
        Map lastFilter = (Map)expressionList.get(end);
        int lastIndent = (Integer)lastFilter.get(NESTING_MAP_ENTRY);
        int indent = lastIndent > prevIndent ? prevIndent : lastIndent;
        for (int j = 0; j < indent; ++j) {
            sb.append(space);
            sb.append(space);
        }
        sb.append((String)lastFilter.get(FILTER_ITEM_MAP_ENTRY));
        return sb.toString();
    }

    public static String getExpressionString(SimpleFilterLogicTreeInterface tree, int outputType, Locale locale) {
        String text = null;
        if (tree != null) {
            LogicTreeToTextTransform transform = outputType == 0 ? LogicTreeToTextTransform.getHTMLTextTransform(locale) : new LogicTreeToTextTransform(locale);
            try {
                text = (String)transform.transform(tree.getRoot());
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public static String getExpressionString(SimpleFilterLogicTreeInterface tree, int outputType) {
        return Util.getExpressionString(tree, outputType, null);
    }

    public static List getExpressionInfo(SimpleFilterLogicTreeInterface tree, int outputType, Locale locale, boolean virtualDisplay) {
        String rightParen;
        String leftParen;
        String newline;
        String space;
        if (tree == null) {
            return null;
        }
        if (tree.getRoot() == null) {
            return null;
        }
        String not = RB.getStringResource(RB_KEY, "Negate.Condition.aka.NOT.Label.txt", locale);
        String andStr = RB.getStringResource(RB_KEY, "Boolean.AND.Label.txt", locale);
        String orStr = RB.getStringResource(RB_KEY, "Boolean.OR.Label.txt", locale);
        if (outputType == 0) {
            space = TEXT_SPACE;
            newline = HTML_BREAK;
            leftParen = HTML_LEFT_PARENTHESIS;
            rightParen = HTML_RIGHT_PARENTHESIS;
        } else {
            space = TEXT_SPACE;
            newline = TEXT_NEWLINE;
            leftParen = TEXT_LEFT_PARENTHESIS;
            rightParen = TEXT_RIGHT_PARENTHESIS;
        }
        return Util.getExpressionInfo(tree, space, newline, leftParen, rightParen, not, andStr, orStr, virtualDisplay);
    }

    public static List getExpressionInfo(SimpleFilterLogicTreeInterface tree, int outputType) {
        return Util.getExpressionInfo(tree, outputType, null, false);
    }

    public static List getExpressionInfo(SimpleFilterLogicTreeInterface tree, String space, String newline, String leftParen, String rightParen, String not, String andStr, String orStr, boolean virtualDisplay) {
        if (tree == null) {
            return null;
        }
        if (tree.getRoot() == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        Util.formatTree(list, tree.getRoot(), 0, "", "", space, newline, leftParen, rightParen, not, andStr, orStr, virtualDisplay);
        return list;
    }

    private static Map formatNode(int nest, String leftPrefix, FilterLogicTestNodeInterface testNode, String rightSuffix) {
        StringBuffer sb = new StringBuffer();
        sb.append(leftPrefix);
        sb.append(testNode.toString());
        sb.append(rightSuffix);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(FILTER_ITEM_MAP_ENTRY, sb.toString());
        map.put(VIRTUAL_FILTER_ITEM_MAP_ENTRY, testNode.toString());
        map.put(NESTING_MAP_ENTRY, new Integer(nest));
        map.put(LOGICAL_CONDITION_MAP_ENTRY, "");
        map.put(LOGICAL_NODE_MAP_ENTRY, testNode);
        return map;
    }

    private static void formatTree(List list, SimpleFilterLogicTreeNodeInterface node, int nest, String leftPrefix, String rightSuffix, String space, String newline, String leftParen, String rightParen, String not, String andStr, String orStr) {
        if (node == null) {
            Map map = Util.formatNode(nest, leftPrefix, null, rightSuffix);
            list.add(map);
        } else {
            FilterLogicTestNodeInterface testNode = node.getTestNode();
            boolean isNegated = node.isNegated();
            if (testNode != null) {
                Map map = Util.formatNode(nest, leftPrefix, testNode, rightSuffix);
                list.add(map);
            } else {
                StringBuffer sbLeft = new StringBuffer();
                StringBuffer sbRight = new StringBuffer();
                int newNest = nest;
                sbLeft.append(leftPrefix);
                sbRight.append(rightSuffix);
                if (isNegated) {
                    sbLeft.append(not);
                    sbLeft.append(space);
                    sbLeft.append(leftParen);
                    sbLeft.append(space);
                    sbRight.insert(0, rightParen);
                    sbRight.insert(0, space);
                }
                String condition = node.getLogicalCondition();
                SimpleFilterLogicTreeNodeInterface leftNode = node.getLeftChild();
                SimpleFilterLogicTreeNodeInterface rightNode = node.getRightChild();
                SimpleFilterLogicTreeNodeInterface parentNode = node.getParent();
                if (condition == null) {
                    if (leftNode != null) {
                        Util.formatTree(list, leftNode, newNest, sbLeft.toString(), sbRight.toString(), space, newline, leftParen, rightParen, not, andStr, orStr);
                    }
                    if (rightNode != null) {
                        if (!isNegated) {
                            sbLeft.append(leftParen);
                            sbLeft.append(space);
                            sbRight.insert(0, rightParen);
                            sbRight.insert(0, space);
                        }
                        Util.formatTree(list, rightNode, ++newNest, sbLeft.toString(), sbRight.toString(), space, newline, leftParen, rightParen, not, andStr, orStr);
                    }
                } else {
                    FilterLogicTestNodeInterface rightTestNode;
                    if (isNegated && parentNode != null && parentNode.getLeftChild() == node) {
                        ++newNest;
                    }
                    Util.formatTree(list, leftNode, newNest, sbLeft.toString(), "", space, newline, leftParen, rightParen, not, andStr, orStr);
                    Map map = (Map)list.get(list.size() - 1);
                    if ("AND".equals(condition)) {
                        map.put(LOGICAL_CONDITION_MAP_ENTRY, andStr);
                    } else if ("OR".equals(condition)) {
                        map.put(LOGICAL_CONDITION_MAP_ENTRY, orStr);
                    }
                    sbLeft = new StringBuffer();
                    if (!(rightNode == null || (rightTestNode = rightNode.getTestNode()) != null || rightNode.getLogicalCondition() == null && rightNode.isNegated())) {
                        sbLeft.append(leftParen);
                        sbLeft.append(space);
                        sbRight.insert(0, rightParen);
                        sbRight.insert(0, space);
                        ++newNest;
                    }
                    Util.formatTree(list, rightNode, newNest, sbLeft.toString(), sbRight.toString(), space, newline, leftParen, rightParen, not, andStr, orStr);
                }
            }
        }
    }

    private static void formatTree(Collection list, FilterLogicBaseNodeInterface node, int nest, String prefix, String suffix, String space, String newline, String leftParen, String rightParen, String notStr, String andStr, String orStr, boolean virtualDisplay) {
        if (node instanceof FilterLogicTestNodeInterface) {
            FilterLogicTestNodeInterface testNode = (FilterLogicTestNodeInterface)node;
            Map map = Util.createNodeMap(testNode, nest, prefix, suffix, andStr, orStr);
            list.add(map);
        } else if (node instanceof NotNodeInterface) {
            NotNodeInterface notNode = (NotNodeInterface)node;
            node = notNode.getChildLogicNodeAt(0);
            StringBuffer pSb = new StringBuffer(prefix);
            pSb.append(notStr).append(space);
            StringBuffer sSb = new StringBuffer(suffix);
            if (!(node instanceof LogicalConditionNodeInterface)) {
                pSb.append(leftParen).append(space);
                sSb.append(space).append(rightParen);
            }
            Util.formatTree(list, node, nest + 1, pSb.toString(), sSb.toString(), space, newline, leftParen, rightParen, notStr, andStr, orStr, virtualDisplay);
        } else if (node instanceof LogicalConditionNodeInterface) {
            LogicalConditionNodeInterface conditionNode = (LogicalConditionNodeInterface)node;
            ConditionalRelationType relationship = conditionNode.getLogicalCondition();
            boolean addParens = true;
            if (!conditionNode.isExplicitlyCreated()) {
                if (virtualDisplay) {
                    addParens = false;
                } else if (conditionNode.getParentLogicNode() instanceof LogicalConditionNodeInterface) {
                    LogicalConditionNodeInterface parentLCN = (LogicalConditionNodeInterface)conditionNode.getParentLogicNode();
                    if (parentLCN.getLogicalCondition() == relationship) {
                        addParens = false;
                    }
                } else if (!virtualDisplay && nest <= 0) {
                    addParens = false;
                }
            }
            StringBuffer pSb = new StringBuffer(prefix);
            if (addParens) {
                pSb.append(leftParen).append(space);
            }
            StringBuffer sSb = new StringBuffer();
            int nextNest = addParens ? nest + 1 : nest;
            int size = conditionNode.getChildCount();
            for (int i = 0; i < size; ++i) {
                FilterLogicBaseNodeInterface child = conditionNode.getChildLogicNodeAt(i);
                if (i == size - 1) {
                    if (addParens) {
                        sSb.append(space).append(rightParen);
                    }
                    sSb.append(suffix);
                }
                Util.formatTree(list, child, nextNest, pSb.toString(), sSb.toString(), space, newline, leftParen, rightParen, notStr, andStr, orStr, virtualDisplay);
                pSb.setLength(0);
            }
        } else if (node instanceof FilterReferenceNodeInterface) {
            FilterReferenceNodeInterface refNode = (FilterReferenceNodeInterface)node;
            Map map = Util.createNodeMap(refNode, nest, prefix, suffix, andStr, orStr);
            list.add(map);
        } else if (node != null) {
            // empty if block
        }
    }

    private static LogicalConditionNodeInterface findParentLogicalConditionNode(FilterLogicBaseNodeInterface node) {
        LogicalConditionNodeInterface result = null;
        FilterLogicBaseNodeInterface last = node;
        for (FilterLogicBaseNodeInterface parent = node.getParentLogicNode(); parent != null; parent = parent.getParentLogicNode()) {
            int size;
            int index;
            if (parent instanceof LogicalConditionNodeInterface && (index = Util.getIndexOfChildInstance(parent, last)) < (size = parent.getChildCount()) - 1) {
                result = (LogicalConditionNodeInterface)parent;
                break;
            }
            last = parent;
        }
        return result;
    }

    private static Map createNodeMap(FilterLogicBaseNodeInterface node, int nest, String prefix, String suffix, String andStr, String orStr) {
        StringBuffer sb = new StringBuffer();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (node != null) {
            sb.append(node.toString());
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        LogicalConditionNodeInterface lcn = Util.findParentLogicalConditionNode(node);
        String lcn_entry = null;
        if (lcn == null) {
            lcn_entry = "";
        } else {
            ConditionalRelationType condType = lcn.getLogicalCondition();
            if (condType == ConditionalRelationType.AND) {
                lcn_entry = andStr != null ? andStr : condType.getLabel();
            } else if (condType == ConditionalRelationType.OR) {
                lcn_entry = orStr != null ? orStr : condType.getLabel();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(FILTER_ITEM_MAP_ENTRY, sb.toString());
        map.put(VIRTUAL_FILTER_ITEM_MAP_ENTRY, sb.toString());
        map.put(NESTING_MAP_ENTRY, new Integer(nest));
        map.put(LOGICAL_CONDITION_MAP_ENTRY, lcn_entry);
        map.put(LOGICAL_NODE_MAP_ENTRY, node);
        return map;
    }

    public static int getIndexOfChildInstance(TreeNode parent, TreeNode child) {
        int index = -1;
        int i = 0;
        Enumeration<? extends TreeNode> e = parent.children();
        while (e.hasMoreElements()) {
            TreeNode el = e.nextElement();
            if (child == el) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static boolean containsInstance(List list, Object o) {
        int index = Util.indexOfInstance(list, o);
        return index >= 0;
    }

    public static int indexOfInstance(List list, Object o) {
        int index = -1;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object test = list.get(i);
            if (o != test) continue;
            index = i;
            break;
        }
        return index;
    }
}

