/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.AbstractFilterLogicBaseNode;
import com.sas.dataselectors.filters.DefaultFilterCondition;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicEditableTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope(value="ALL")
public class DefaultFilterLogicTestNode
extends AbstractFilterLogicBaseNode
implements FilterLogicTestNodeInterface,
FilterLogicEditableTestNodeInterface {
    protected transient FilterItemInterface item = null;
    protected transient List qualifiers = null;
    protected transient FilterConditionInterface condition = null;
    protected transient List values = null;

    public DefaultFilterLogicTestNode() {
        this(null, null, null, null);
    }

    public DefaultFilterLogicTestNode(Object userObject) {
        super(userObject);
        this.item = null;
        this.qualifiers = null;
        this.condition = null;
        this.values = null;
    }

    public DefaultFilterLogicTestNode(FilterItemInterface item, List qualifiers, FilterConditionInterface condition, List values) {
        this.item = item;
        this.qualifiers = qualifiers;
        this.condition = condition;
        this.values = values;
    }

    public DefaultFilterLogicTestNode(FilterLogicTestNodeInterface duplicate) {
        super(duplicate);
        this.item = duplicate.getFilterItem();
        List qualifiers = duplicate.getFilterItemQualifiers();
        if (qualifiers != null && qualifiers.size() > 0) {
            this.qualifiers = new ArrayList(qualifiers);
        }
        this.condition = duplicate.getCondition();
        if (duplicate.getTestValuesList() != null) {
            this.values = new ArrayList(duplicate.getTestValuesList());
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                OLAPTimeBasedFilterAdapterInterface olapAdapter;
                OLAPTimeBasedFilterAdapterInterface olapAdapterClone;
                DefaultFilterValue filterValue;
                Object value = this.values.get(i);
                if (!(value instanceof DefaultFilterValue) || !((filterValue = (DefaultFilterValue)value).getData() instanceof OLAPTimeBasedFilterAdapterInterface) || (olapAdapterClone = (OLAPTimeBasedFilterAdapterInterface)(olapAdapter = (OLAPTimeBasedFilterAdapterInterface)filterValue.getData()).clone()) == null) continue;
                DefaultFilterValue newFilterValue = new DefaultFilterValue(olapAdapterClone, filterValue.getFormattedValue(), filterValue.getDataType(), filterValue.getFormat(), filterValue.getUnformattedValue());
                this.values.set(i, newFilterValue);
            }
        }
    }

    @Override
    public Object clone() {
        DefaultFilterLogicTestNode newNode = (DefaultFilterLogicTestNode)super.clone();
        newNode.item = this.item;
        newNode.condition = this.condition;
        newNode.qualifiers = this.qualifiers == null ? null : new ArrayList(this.qualifiers);
        newNode.values = this.values == null ? null : new ArrayList(this.values);
        return newNode;
    }

    @Override
    public String toString() {
        Object qualifier;
        FilterItemInterface item = this.getFilterItem();
        FilterConditionInterface cond = this.getCondition();
        List values = this.getTestValuesList();
        ArrayList qualifiers = this.getFilterItemQualifiers();
        String userLabel = null;
        String label = null;
        String name = this.getFilterLabel();
        String desc = this.getFilterDescription();
        if (name != null && name.length() > 0 || desc != null && desc.length() > 0) {
            userLabel = name == null || name.length() == 0 ? desc : (desc == null || desc.length() == 0 ? name : name + ": " + desc);
        }
        FilterItemInterface qualifierItem = null;
        Object qualifierPicked = null;
        if (qualifiers != null && qualifiers.size() > 0) {
            for (Object object : qualifiers) {
                Object qualiferObject;
                if (!(object instanceof FilterQualifierInterface) || !((qualiferObject = (qualifier = (FilterQualifierInterface)object).getQualifier()) instanceof FilterItemInterface)) continue;
                qualifierItem = (FilterItemInterface)qualiferObject;
                qualifierPicked = qualifier;
                break;
            }
        }
        if (qualifierItem != null) {
            label = item + " where " + DefaultFilterCondition.format(qualifierItem, cond, values);
            ArrayList qualifersLeft = new ArrayList(qualifiers);
            qualifersLeft.remove(qualifierPicked);
            qualifiers = qualifersLeft;
        } else {
            label = DefaultFilterCondition.format(item, cond, values);
        }
        if (qualifiers != null && qualifiers.size() > 0) {
            String tmp = "";
            Iterator iter = qualifiers.iterator();
            while (iter.hasNext()) {
                qualifier = iter.next();
                if (qualifier == null) {
                    qualifier = "";
                }
                String text = qualifier.toString();
                tmp = tmp.concat(text);
                if (!iter.hasNext()) continue;
                tmp = tmp.concat(",");
            }
            ArrayList<String> loader = new ArrayList<String>();
            loader.add(label);
            loader.add(tmp);
            String formatToUse = qualifiers.size() == 1 ? "{0} for {1}" : "{0} for ({1})";
            label = MessageFormat.format(formatToUse, loader.toArray());
        }
        if (userLabel != null) {
            if (label != null && !"".equals(label)) {
                return userLabel + " (" + label + ")";
            }
            return userLabel;
        }
        if (label != null) {
            return label;
        }
        return "";
    }

    @Override
    public FilterItemInterface getFilterItem() {
        return this.item;
    }

    @Override
    public List getFilterItemQualifiers() {
        return this.qualifiers;
    }

    @Override
    public FilterConditionInterface getCondition() {
        return this.condition;
    }

    @Override
    public List getTestValuesList() {
        return this.values;
    }

    @Override
    public void setFilterItem(FilterItemInterface item) {
        if (item != this.item) {
            FilterItemInterface oldValue = this.item;
            this.item = item;
            this.firePropertyChange("filterItem", oldValue, this.item);
        }
    }

    @Override
    public void setFilterItemQualifiers(List qualifiers) {
        if (qualifiers != this.qualifiers) {
            List oldValue = this.qualifiers;
            this.qualifiers = qualifiers;
            this.firePropertyChange("qualifiers", oldValue, this.qualifiers);
        }
    }

    @Override
    public void setCondition(FilterConditionInterface condition) {
        if (condition != this.condition) {
            FilterConditionInterface oldValue = this.condition;
            this.condition = condition;
            this.firePropertyChange("condition", oldValue, this.condition);
        }
    }

    @Override
    public void setTestValuesList(List values) {
        if (values != this.values) {
            List oldValue = this.values;
            this.values = values;
            this.firePropertyChange("testValues", oldValue, this.values);
        }
    }

    @Override
    public int getMaxChildren() {
        return 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterLogicTestNodeInterface) {
            FilterLogicTestNodeInterface other = (FilterLogicTestNodeInterface)obj;
            return this._equals(this.getFilterItem(), other.getFilterItem()) && this._equals(this.getCondition(), other.getCondition()) && this._equals(this.getFilterItemQualifiers(), other.getFilterItemQualifiers()) && this._equals(this.getTestValuesList(), other.getTestValuesList());
        }
        return super.equals(obj);
    }

    private boolean _equals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }
}

