/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.DefaultFilterConditionList;
import com.sas.dataselectors.filters.DefaultFilterItemList;
import com.sas.dataselectors.filters.DefaultFilterValueList;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterConditionListInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.util.ChainedExceptionInterface;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@SASScope(value="ALL")
public class DefaultFilterItem
implements FilterItemInterface {
    private transient Object _itemObject = null;
    private transient String _itemLabel = null;
    private transient boolean _qualifierRequired = false;
    private transient FilterQualifierListInterface _qualifiers = null;
    private transient FilterItemInterface _qualifiedItem = null;
    private transient boolean _subitemRequired = false;
    private transient FilterItemListInterface _subitems = null;
    private transient FilterConditionListInterface _itemConditions = null;
    private transient boolean _userValuesAllowed = false;
    private transient Object _itemPossibleValues = null;
    private transient Object _itemActualValues = null;
    private transient long _itemType = 3L;
    Format _formatter = null;

    public DefaultFilterItem() {
    }

    public DefaultFilterItem(String itemLabel) {
        this();
        this.setItemLabel(itemLabel);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues) {
        this();
        this.setItemLabel(itemLabel);
        this.setConditionList(itemConditions);
        this.setUserValueAllowed(allowUserValues);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, Object[] itemPossibleValues, Object[] itemActualValues) {
        this(itemLabel, itemConditions, allowUserValues);
        this.setPossibleValues(itemPossibleValues);
        this.setActualValues(itemActualValues);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, Object[] itemPossibleValues, Object[] itemActualValues, FilterItemListInterface itemSubitems, boolean subitemsRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues);
        this.setSubitemList(itemSubitems);
        this.setSubitemRequired(subitemsRequired);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, List itemPossibleValues, List itemActualValues) {
        this(itemLabel, itemConditions, allowUserValues);
        this.setPossibleValues(itemPossibleValues);
        this.setActualValues(itemActualValues);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, List itemPossibleValues, List itemActualValues, FilterItemListInterface itemSubitems, boolean subitemsRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues);
        this.setSubitemList(itemSubitems);
        this.setSubitemRequired(subitemsRequired);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, Object[] itemPossibleValues, Object[] itemActualValues, FilterQualifierListInterface itemQualfiers, boolean qualifiersRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues);
        this.setQualifierList(itemQualfiers);
        this.setQualifierRequired(qualifiersRequired);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, Object[] itemPossibleValues, Object[] itemActualValues, FilterQualifierListInterface itemQualfiers, boolean qualifiersRequired, FilterItemListInterface itemSubitems, boolean subitemsRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues, itemQualfiers, qualifiersRequired);
        this.setSubitemList(itemSubitems);
        this.setSubitemRequired(subitemsRequired);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, List itemPossibleValues, List itemActualValues, FilterQualifierListInterface itemQualfiers, boolean qualifiersRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues);
        this.setQualifierList(itemQualfiers);
        this.setQualifierRequired(qualifiersRequired);
    }

    public DefaultFilterItem(String itemLabel, FilterConditionListInterface itemConditions, boolean allowUserValues, List itemPossibleValues, List itemActualValues, FilterQualifierListInterface itemQualfiers, boolean qualifiersRequired, FilterItemListInterface itemSubitems, boolean subitemsRequired) {
        this(itemLabel, itemConditions, allowUserValues, itemPossibleValues, itemActualValues, itemQualfiers, qualifiersRequired);
        this.setSubitemList(itemSubitems);
        this.setSubitemRequired(subitemsRequired);
    }

    @Override
    public Object getItem() {
        return this._itemObject;
    }

    public void setItem(Object itemObject) {
        this._itemObject = itemObject;
    }

    @Override
    public String getItemLabel() {
        return this._itemLabel;
    }

    public void setItemLabel(String itemLabel) {
        this._itemLabel = itemLabel;
    }

    public String toString() {
        if (this._itemLabel != null) {
            return this._itemLabel;
        }
        if (this._itemObject != null) {
            return this._itemObject.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        boolean equalsValue = false;
        if (o instanceof FilterItemInterface) {
            FilterItemInterface other = (FilterItemInterface)o;
            if (this.getItem() == null) {
                if (other.getItem() == null) {
                    equalsValue = true;
                }
            } else if (this.getItem().equals(other.getItem())) {
                equalsValue = true;
            }
        }
        return equalsValue;
    }

    @Override
    public boolean isSubitemRequired() {
        return this._subitemRequired;
    }

    public void setSubitemRequired(boolean subitemRequired) {
        this._subitemRequired = subitemRequired;
    }

    @Override
    public FilterItemListInterface getSubitemList() {
        return this._subitems;
    }

    public void setSubitemList(FilterItemListInterface subitems) {
        this._subitems = subitems;
    }

    @Override
    public boolean isQualifierRequired() {
        return this._qualifierRequired;
    }

    public void setQualifierRequired(boolean qualifierRequired) {
        this._qualifierRequired = qualifierRequired;
    }

    @Override
    public FilterQualifierListInterface getQualifierList() {
        return this._qualifiers;
    }

    public void setQualifierList(FilterQualifierListInterface qualifiers) {
        this._qualifiers = qualifiers;
    }

    @Override
    public FilterConditionListInterface getConditionList() {
        return this._itemConditions;
    }

    public void setConditionList(FilterConditionListInterface itemConditions) {
        this._itemConditions = itemConditions;
    }

    @Override
    public boolean isUserValueAllowed() {
        return this._userValuesAllowed;
    }

    public void setUserValueAllowed(boolean allowed) {
        this._userValuesAllowed = allowed;
    }

    public void setPossibleValues(FilterValuesInterface valueInterface) {
        this._itemPossibleValues = valueInterface;
    }

    public void setPossibleValues(Object[] valuesArray) {
        this._itemPossibleValues = valuesArray == null ? null : Arrays.asList(valuesArray);
    }

    public void setPossibleValues(Collection valuesCollection) {
        this._itemPossibleValues = valuesCollection;
    }

    @Override
    public FilterValuesInterface getPossibleValues() {
        if (this._itemPossibleValues == null) {
            return null;
        }
        if (this._itemPossibleValues instanceof FilterValuesInterface) {
            return (FilterValuesInterface)this._itemPossibleValues;
        }
        if (this._itemPossibleValues instanceof Collection) {
            Collection valuesCollection = (Collection)this._itemPossibleValues;
            DefaultFilterValueList result = new DefaultFilterValueList(valuesCollection);
            return result;
        }
        return null;
    }

    public void setActualValues(FilterValuesInterface valueInterface) {
        this._itemActualValues = valueInterface;
    }

    public void setActualValues(Object[] valuesArray) {
        this._itemActualValues = valuesArray == null ? null : Arrays.asList(valuesArray);
    }

    public void setActualValues(Collection valuesCollection) {
        this._itemActualValues = valuesCollection;
    }

    @Override
    public FilterValuesInterface getActualValues() {
        if (this._itemActualValues == null) {
            return null;
        }
        if (this._itemActualValues instanceof FilterValuesInterface) {
            return (FilterValuesInterface)this._itemActualValues;
        }
        if (this._itemActualValues instanceof Collection) {
            Collection valuesCollection = (Collection)this._itemActualValues;
            DefaultFilterValueList result = new DefaultFilterValueList(valuesCollection);
            return result;
        }
        return null;
    }

    public void setSubitemList(FilterItemInterface[] subitemArray) {
        if (subitemArray.length > 0) {
            this.setSubitemList(Arrays.asList(subitemArray));
        } else {
            this.setSubitemList((FilterItemListInterface)null);
        }
    }

    public void setSubitemList(List subitemList) {
        ArrayList listOfItems = new ArrayList();
        for (Object obj : subitemList) {
            if (!(obj instanceof FilterItemInterface)) continue;
            listOfItems.add(obj);
        }
        DefaultFilterItemList itemList = new DefaultFilterItemList(listOfItems);
        this.setSubitemList(itemList);
    }

    public void setConditionList(FilterConditionInterface[] itemConditionArray) {
        if (itemConditionArray.length > 0) {
            this.setConditionList(Arrays.asList(itemConditionArray));
        } else {
            this.setConditionList((FilterConditionListInterface)null);
        }
    }

    public void setConditionList(List itemConditionList) {
        ArrayList listOfConditions = new ArrayList();
        for (Object obj : itemConditionList) {
            if (!(obj instanceof FilterConditionInterface)) continue;
            listOfConditions.add(obj);
        }
        DefaultFilterConditionList itemList = new DefaultFilterConditionList(listOfConditions);
        this.setConditionList(itemList);
    }

    @Override
    public long getItemType() {
        return this._itemType;
    }

    public void setItemType(long itemType) {
        this._itemType = itemType;
    }

    public void setUserValueFormatter(Format formatter) {
        this._formatter = formatter;
    }

    @Override
    public Format getUserValueFormatter() {
        return this._formatter;
    }

    @Override
    public Object createUserValue(String valueTyped) {
        Format fmt = this.getUserValueFormatter();
        if (fmt == null) {
            return new String(valueTyped);
        }
        try {
            Object tmp = fmt.parseObject(valueTyped);
            return tmp;
        }
        catch (ParseException e) {
            throw new ChainedIllegalArgumentException((Throwable)e);
        }
    }

    @Override
    public FilterItemInterface getQualifiedItem(List qualifiers) {
        return this._qualifiedItem;
    }

    public void setQualifiedItem(FilterItemInterface qualifiedItem) {
        this._qualifiedItem = qualifiedItem;
    }

    @SASScope
    private class ChainedIllegalArgumentException
    extends IllegalArgumentException
    implements ChainedExceptionInterface {
        Throwable _target;

        public ChainedIllegalArgumentException(Throwable target) {
            super(target.getMessage());
            this._target = null;
            this._target = target;
        }

        public Throwable getTargetException() {
            return this._target;
        }
    }
}

