/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.export;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.export.BaseExportSelectorAdapter;
import com.sas.dataselectors.export.OLAPExportSelectorInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;

@SASScope(value="ALL")
public class OLAPExportSelectorAdapter
extends BaseExportSelectorAdapter
implements OLAPExportSelectorInterface {
    protected boolean isRepeatRowLabels;

    public OLAPExportSelectorAdapter() {
        this.setIsRepeatRowLabels(true);
    }

    @Override
    public boolean isRepeatRowLabels() {
        return this.isRepeatRowLabels;
    }

    @Override
    public void setIsRepeatRowLabels(boolean isRepeatRowLabels) {
        this.isRepeatRowLabels = isRepeatRowLabels;
    }

    @Override
    @SASScope
    public int getMaxNrows() {
        int maxRows = 500000;
        if (this.dataModel instanceof OLAPDataSetInterface) {
            ResultSetMetadataInterface metadata = null;
            AxisInterface rowAxis = null;
            try {
                metadata = ((OLAPDataSetInterface)this.dataModel).getResultSetMetadata();
                if (metadata != null && (rowAxis = metadata.getAxis(1)) != null) {
                    maxRows = rowAxis.getTupleCount();
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return maxRows;
    }
}

