/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.export;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.export.BaseExportSelectorAdapter;
import com.sas.dataselectors.export.ExportSelectorInterface;
import com.sas.dataselectors.export.OLAPExportSelectorAdapter;
import com.sas.dataselectors.export.OLAPExportSelectorInterface;
import com.sas.dataselectors.export.RelationalExportSelectorAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ExportSelectorAdapterFactory {
    public static ExportSelectorInterface getRelationalAdapter(Object model) {
        RelationalExportSelectorAdapter adapter = null;
        if (model != null && model instanceof TableModel) {
            adapter = new RelationalExportSelectorAdapter();
            ((BaseExportSelectorAdapter)adapter).setDataModel(model);
        }
        return adapter;
    }

    public static OLAPExportSelectorInterface getOLAPAdapter(Object model) {
        OLAPExportSelectorAdapter adapter = null;
        if (model != null && model instanceof OLAPDataSetInterface) {
            adapter = new OLAPExportSelectorAdapter();
            ((BaseExportSelectorAdapter)adapter).setDataModel(model);
        }
        return adapter;
    }

    public static ExportSelectorInterface getAdapter(Object model) {
        BaseExportSelectorAdapter adapter = null;
        if (model != null) {
            if (model instanceof OLAPDataSetInterface) {
                adapter = new OLAPExportSelectorAdapter();
                ((BaseExportSelectorAdapter)adapter).setDataModel(model);
            } else if (model instanceof TableModel) {
                adapter = new RelationalExportSelectorAdapter();
                ((BaseExportSelectorAdapter)adapter).setDataModel(model);
            }
        }
        return adapter;
    }
}

