/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.models.TableModelInsertRowSupport;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.InsertRowInterface;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class InsertRowCommand
extends BaseCommand
implements ContentsChangedInterface,
CommandSupportedInterface {
    public static final String RB_KEY = "InsertRowCommand.";
    protected TableView table;
    protected int row;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;

    public InsertRowCommand() {
    }

    public InsertRowCommand(String name) {
        super(name);
    }

    public InsertRowCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    @Override
    public void execute(Object o) {
        if (this.actionClass == "com.sas.actionprovider.SwingAction") {
            this.getTable();
            if (this.table != null) {
                TableModel model = this.table.getModel();
                int index = this.row;
                if (model instanceof InsertRowInterface) {
                    ((InsertRowInterface)model).insertUncommittedRow(index);
                } else if (model instanceof DefaultTableModel) {
                    ((DefaultTableModel)model).insertRow(index, TableModelInsertRowSupport.getDefaultRowValues((TableModel)model));
                }
                if (this.table.getRowHeader() != null) {
                    int topHeldSize = this.table.getRowHeader().getHeldIndices(1).size();
                    int bottomHeldSize = this.table.getRowHeader().getHeldIndices(3).size();
                    int rowCount = this.table.getRowCount();
                    if (index < topHeldSize) {
                        index = topHeldSize;
                    }
                    if (index > rowCount - bottomHeldSize - 1) {
                        index = rowCount - bottomHeldSize - 1;
                    }
                }
                this.table.clearSelection();
                if (this.table.getColumnCount() > 0) {
                    this.table.changeSelection(index, 0, false, false);
                    this.table.editCellAt(index, 0);
                } else {
                    this.table.changeSelection(index, -1, false, false);
                }
            }
        }
    }

    @Override
    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    @Override
    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    @Override
    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        TableView table = (TableView)actionFilter.getAttribute("table");
        Integer insertRow = (Integer)actionFilter.getAttribute("row");
        if (insertRow == null || insertRow == Integer.MAX_VALUE) {
            return false;
        }
        if (table != null && insertRow >= 0) {
            if (table.getModel() instanceof InsertRowInterface) {
                return ((InsertRowInterface)table.getModel()).isRowInsertionAllowed() && !((InsertRowInterface)table.getModel()).isTableExtendOnly() && !((InsertRowInterface)table.getModel()).isUncommittedRowPresent();
            }
            if (table.getModel() instanceof DefaultTableModel) {
                return true;
            }
        }
        return false;
    }

    public void setTable(TableView table) {
        this.table = table;
    }

    public TableView getTable() {
        return this.table;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getRow() {
        return this.row;
    }
}

