/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.relational;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.swing.visuals.tableview.TableView;
import java.util.HashMap;

public class ClearCommand
extends BaseCommand
implements ContentsChangedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "ClearCommand.";
    protected TableView table;
    private String actionClass;
    private boolean contentsChanged;
    private HashMap eventInfo;
    private Object eventSource;

    public ClearCommand() {
    }

    public ClearCommand(String name) {
        super(name);
    }

    public ClearCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    @Override
    public void execute(Object o) {
        if (this.actionClass == "com.sas.actionprovider.SwingAction") {
            this.getTable();
            if (this.table != null) {
                this.clear(this.table);
            }
        }
    }

    @Override
    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    @Override
    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    @Override
    public Object getEventSource() {
        return this.eventSource;
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        TableView tv = (TableView)filter.getAttribute("table");
        if (tv != null && this.canClear(tv)) {
            return 0;
        }
        return 16;
    }

    private boolean canClear(TableView table) {
        boolean ret = false;
        int[][] cells = table.getSelectedCells();
        for (int i = 0; i < cells.length; ++i) {
            if (!table.isCellEditable(cells[i][0], cells[i][1])) {
                return false;
            }
            ret = true;
        }
        int[] rows = table.getSelectedRows();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < colCount; ++j) {
                if (!table.isCellEditable(rows[i], j)) {
                    return false;
                }
                ret = true;
            }
        }
        int[] cols = table.getSelectedColumns();
        int rowCount = table.getRowCount();
        for (int i = 0; i < cols.length; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                if (!table.isCellEditable(j, cols[i])) {
                    return false;
                }
                ret = true;
            }
        }
        return ret;
    }

    private void clear(TableView table) {
        int[][] cells = table.getSelectedCells();
        for (int i = 0; i < cells.length; ++i) {
            table.setValueAt(null, cells[i][0], cells[i][1]);
        }
        int[] rows = table.getSelectedRows();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < colCount; ++j) {
                table.setValueAt(null, rows[i], j);
            }
        }
        int[] cols = table.getSelectedColumns();
        int rowCount = table.getRowCount();
        for (int i = 0; i < cols.length; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                table.setValueAt(null, j, cols[i]);
            }
        }
    }

    public void setTable(TableView table) {
        this.table = table;
    }

    public TableView getTable() {
        return this.table;
    }
}

