/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.sort.SortSelectorInterface;
import com.sas.dataselectors.sort.SortSelectorModelFactory;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import java.io.IOException;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class SortSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    public SortSelectorCommand() {
    }

    public SortSelectorCommand(String name) {
        super(name);
    }

    public SortSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    @Override
    protected void commit(Object o) throws IOException {
        if (this.model instanceof SortableInterface) {
            try {
                SortSelectorInterface sortAdapter = (SortSelectorInterface)this.getSelectorModel();
                Object[] items = sortAdapter.getSortedItems();
                String[] columnNames = new String[items.length];
                for (int i = 0; i < items.length; ++i) {
                    columnNames[i] = items[i] instanceof SortedItem ? (String)((SortedItem)items[i]).getID() : items[i].toString();
                }
                ((SortableInterface)this.model).sort(columnNames, sortAdapter.getSortedDirections());
            }
            catch (SortException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
        super.commit(o);
    }

    @Override
    protected void show(Object o) {
        SortSelectorInterface sortAdapter = SortSelectorModelFactory.getAdapter((TableModel)this.getModel());
        this.setSelectorModel(sortAdapter);
        this.selector.setSelectorModel(sortAdapter);
        super.show(o);
    }

    @Override
    public void cancel(Object o) {
        super.cancel(o);
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object model = actionFilter.getAttribute("model");
        return model != null && model instanceof SortableInterface && ((SortableInterface)model).isSortAllowed();
    }
}

