/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.export.OLAPExportCommandV2Interface;
import com.sas.commands.export.RelationalExportCommandV2Interface;
import com.sas.commands.export.Util;
import com.sas.dataselectors.export.ExportColumnsInterface;
import com.sas.dataselectors.export.ExportHeadersFootersInterface;
import com.sas.dataselectors.export.ExportSelectorAdapterFactory;
import com.sas.dataselectors.export.ExportSelectorCommandFactory;
import com.sas.dataselectors.export.ExportSelectorInterface;
import com.sas.dataselectors.export.HTMLExportSelectorInterface;
import com.sas.dataselectors.export.OLAPExportSelectorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.BaseEntityValueInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ExportSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    private Object adapter = null;
    private ExportSelectorCommandFactory commandsFactory = null;
    private Object command = null;
    public String outputType;
    public String rows;
    int startRow;
    int endRow;
    public String formatted;
    public String repeatLabels;
    public String[] cssURL;
    public String[] cssMIMEType;
    public String[] cssMediaList;
    public String[] cssTitle;
    public String[] columns;
    public String whichColumns;
    public String[] headers;
    public String[] footers;
    private boolean isJSP;
    protected CommonLoggerInterface log;

    public ExportSelectorCommand() {
        this.initializeFlags();
        this.initializeCommandsFactory();
        this.log = LoggerRepository2.getLogger((String)ExportSelectorCommand.class.getPackage().getName(), null);
    }

    public ExportSelectorCommand(String name) {
        super(name);
        this.initializeFlags();
        this.initializeCommandsFactory();
        this.log = LoggerRepository2.getLogger((String)ExportSelectorCommand.class.getPackage().getName(), null);
    }

    public ExportSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.initializeCommandsFactory();
    }

    private void initializeFlags() {
        this.isJSP = true;
        this.outputType = "";
        this.rows = "";
        this.startRow = 0;
        this.endRow = -2;
        this.formatted = "0";
        this.repeatLabels = "0";
        this.columns = null;
        this.headers = null;
        this.footers = null;
        this.whichColumns = "";
    }

    private void initializeCommandsFactory() {
        this.commandsFactory = new ExportSelectorCommandFactory();
    }

    @Override
    protected void show(Object o) {
        this.adapter = ExportSelectorAdapterFactory.getAdapter(this.model);
        this.setSelectorModel(this.adapter);
        this.selector.setSelectorModel(this.adapter);
        if (this.adapter instanceof ExportColumnsInterface) {
            ((ExportColumnsInterface)this.adapter).setViewer(this.getAttribute("viewComponent"));
        }
        super.show(o);
    }

    @Override
    protected void commit(Object o) throws IOException {
        boolean repeatLabels;
        boolean isRawData;
        int nRows;
        block27: {
            block26: {
                this.adapter = this.selectorModel != null ? this.selectorModel : this.getSelector().getSelectorModel();
                if (this.isJSP) {
                    this.updateAdapter();
                }
                this.outputType = ((ExportSelectorInterface)this.adapter).getOutputType();
                this.startRow = ((ExportSelectorInterface)this.adapter).getStartRow();
                nRows = ((ExportSelectorInterface)this.adapter).getNRows();
                isRawData = !((ExportSelectorInterface)this.adapter).isFormattedData();
                repeatLabels = true;
                if (this.model instanceof OLAPDataSetInterface) {
                    repeatLabels = ((OLAPExportSelectorInterface)this.adapter).isRepeatRowLabels();
                }
                ClassLoader loader = this.getAttribute("selector").getClass().getClassLoader();
                this.command = this.model instanceof OLAPDataSetInterface ? this.commandsFactory.getOLAPCommand(this.outputType, loader) : this.commandsFactory.getRelationalCommand(this.outputType, loader);
                try {
                    ((BaseEntityValueInterface)this.command).setAttribute("response", this.getAttribute("response"));
                    ((BaseEntityValueInterface)this.command).setAttribute("model", this.getAttribute("model"));
                    ((BaseEntityValueInterface)this.command).setAttribute("request", this.getAttribute("request"));
                    ((BaseEntityValueInterface)this.command).setAttribute("locale", this.getAttribute("locale"));
                    ((BaseEntityValueInterface)this.command).setAttribute("HTMLExport_QueryConnector", this.getAttribute("HTMLExport_QueryConnector"));
                    ((BaseEntityValueInterface)this.command).setAttribute("Use_ds", this.getAttribute("Use_ds"));
                    if ("HTML".equals(this.outputType) || "WHTML".equals(this.outputType)) {
                        ((BaseEntityValueInterface)this.command).setAttribute("cssInfo", (Object)((HTMLExportSelectorInterface)this.adapter).getCSSInfo());
                        ((BaseEntityValueInterface)this.command).setAttribute("styleDefinitions", this.getAttribute("styleDefinitions"));
                        ((BaseEntityValueInterface)this.command).setAttribute("viewComponent", this.getAttribute("viewComponent"));
                    }
                    if ("XLSX".equals(this.outputType) && this.containsAttributeNamed("autosizeColumnHeaders")) {
                        ((BaseEntityValueInterface)this.command).setAttribute("autosizeColumnHeaders", this.getAttribute("autosizeColumnHeaders"));
                    }
                }
                catch (AttributeSetException ase) {
                    if (!this.log.isWarnEnabled()) break block26;
                    this.log.warn(ase.getMessage((Locale)this.getAttribute("locale")));
                }
            }
            String charset = null;
            String contentType = null;
            String contentDisposition = null;
            if ("CSV".equals(this.outputType)) {
                charset = Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
                contentType = Util.DEFAULT_CSV_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("CSV");
            } else if ("TSV".equals(this.outputType)) {
                charset = Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
                contentType = Util.DEFAULT_TSV_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("TSV");
            } else if ("XML".equals(this.outputType)) {
                charset = Util.CHARSET_FOR_NON_HTML_EXPORT_TO_EXCEL;
                contentType = Util.DEFAULT_EXCEL_XML_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("XML");
            } else if ("HTML".equals(this.outputType)) {
                contentType = Util.DEFAULT_EXCEL_HTML_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("HTML");
                charset = (String)this.getAttribute("charset");
                charset = charset != null ? charset : Util.DEFAULT_CHARSET_FOR_HTML_EXPORT_TO_EXCEL;
            } else if ("WHTML".equals(this.outputType)) {
                contentType = Util.DEFAULT_WORD_HTML_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("WHTML");
                charset = (String)this.getAttribute("charset");
                charset = charset != null ? charset : Util.DEFAULT_CHARSET_FOR_HTML_EXPORT_TO_EXCEL;
            } else if ("XLSX".equals(this.outputType)) {
                contentType = Util.DEFAULT_XLSX_CONTENT_TYPE;
                contentDisposition = Util.getDefaultContentDisposition("XLSX");
                charset = (String)this.getAttribute("charset");
                charset = charset != null ? charset : Util.DEFAULT_CHARSET_FOR_HTML_EXPORT_TO_EXCEL;
            }
            try {
                if (charset != null) {
                    ((BaseEntityValueInterface)this.command).setAttribute("charset", (Object)charset);
                }
                if (contentType != null) {
                    ((BaseEntityValueInterface)this.command).setAttribute("content_type", (Object)contentType);
                }
                if (contentDisposition != null) {
                    ((BaseEntityValueInterface)this.command).setAttribute("content_disposition", (Object)contentDisposition);
                }
            }
            catch (AttributeSetException e) {
                if (!this.log.isWarnEnabled()) break block27;
                this.log.warn(e.getMessage((Locale)this.getAttribute("locale")));
            }
        }
        if (this.model instanceof OLAPDataSetInterface) {
            ((OLAPExportCommandV2Interface)this.command).execute(this.startRow, nRows, isRawData, repeatLabels, this.headers, this.footers);
        } else {
            int[] columnsToExportIndexes = null;
            if (this.getWhichColumns().equals("S")) {
                columnsToExportIndexes = this.convertStringArrayToIntArray(this.columns);
            }
            if (this.getWhichColumns().equals("D") && this.adapter instanceof ExportColumnsInterface) {
                columnsToExportIndexes = ((ExportColumnsInterface)this.adapter).getCurrentlyDisplayedColumnIndexes();
            }
            ((RelationalExportCommandV2Interface)this.command).execute(this.startRow, nRows, isRawData, columnsToExportIndexes, this.headers, this.footers);
        }
        this.initializeFlags();
        super.commit(o);
    }

    private int[] convertStringArrayToIntArray(String[] stringValues) {
        int[] intValues = null;
        if (stringValues != null) {
            int nValues = stringValues.length;
            intValues = new int[nValues];
            for (int i = 0; i < nValues; ++i) {
                intValues[i] = Integer.parseInt(stringValues[i]);
            }
        }
        return intValues;
    }

    private void updateAdapter() {
        if (this.adapter != null) {
            ((ExportSelectorInterface)this.adapter).setOutputType(this.outputType);
            ((ExportSelectorInterface)this.adapter).setIncludeRows(this.rows);
            ((ExportSelectorInterface)this.adapter).setFromRowCount(this.startRow);
            ((ExportSelectorInterface)this.adapter).setToRowCount(this.endRow);
            ((ExportSelectorInterface)this.adapter).setIsFormattedData("1".equals(this.formatted));
            if (this.adapter instanceof ExportHeadersFootersInterface) {
                ((ExportHeadersFootersInterface)this.adapter).setHeaders(this.headers);
                ((ExportHeadersFootersInterface)this.adapter).setFooters(this.footers);
            }
            if (this.model instanceof OLAPDataSetInterface) {
                ((OLAPExportSelectorInterface)this.adapter).setIsRepeatRowLabels("1".equals(this.repeatLabels));
            }
            ((HTMLExportSelectorInterface)this.adapter).setCssMediaList(this.getCssMediaList());
            ((HTMLExportSelectorInterface)this.adapter).setCssMIMEType(this.getCssMIMEType());
            ((HTMLExportSelectorInterface)this.adapter).setCssTitle(this.getCssTitle());
            ((HTMLExportSelectorInterface)this.adapter).setCssURL(this.getCssURL());
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object dataModel = actionFilter.getAttribute("model");
        return dataModel instanceof TableModel || dataModel instanceof OLAPDataSetInterface;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String value) {
        this.isJSP = true;
        this.outputType = value;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String value) {
        this.isJSP = true;
        this.rows = value;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int value) {
        this.isJSP = true;
        this.startRow = value;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int value) {
        this.isJSP = true;
        this.endRow = value;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public void setFormatted(String value) {
        this.isJSP = true;
        this.formatted = value;
    }

    public String getRepeatLabels() {
        return this.repeatLabels;
    }

    public void setRepeatLabels(String value) {
        this.isJSP = true;
        this.repeatLabels = value;
    }

    public String[] getCssURL() {
        return this.cssURL;
    }

    public void setCssURL(String[] value) {
        this.isJSP = true;
        this.cssURL = this.decode(value);
    }

    public String[] getCssMIMEType() {
        return this.cssMIMEType;
    }

    public void setCssMIMEType(String[] value) {
        this.isJSP = true;
        this.cssMIMEType = this.decode(value);
    }

    public String[] getCssMediaList() {
        return this.cssMediaList;
    }

    public void setCssMediaList(String[] value) {
        this.isJSP = true;
        this.cssMediaList = this.decode(value);
    }

    public String[] getCssTitle() {
        return this.cssTitle;
    }

    public void setCssTitle(String[] value) {
        this.isJSP = true;
        this.cssTitle = this.decode(value);
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setWhichColumns(String value) {
        this.whichColumns = value;
    }

    public String getWhichColumns() {
        return this.whichColumns;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public String[] getFooters() {
        return this.footers;
    }

    public void setFooters(String[] footers) {
        this.footers = footers;
    }

    private String[] decode(String[] value) {
        if (value != null) {
            int n = value.length;
            for (int i = 0; i < n; ++i) {
                try {
                    value[i] = URLDecoder.decode(value[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return value;
    }
}

