/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.tableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.strategies.relational.SwingRelationalActionStrategyFactory;
import com.sas.actionprovider.support.DynamicActionCountInterface;
import com.sas.actionprovider.support.tableview.BaseTableViewSupport;
import com.sas.actionprovider.support.tableview.RB;
import com.sas.actionprovider.support.tableview.SwingRelationalActionTypeKeysInterface;
import com.sas.actionprovider.support.tableview.SwingTableViewAreaInterface;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.swing.visuals.tableview.actions.AddRowAction;
import com.sas.swing.visuals.tableview.actions.DeleteRowAction;
import com.sas.swing.visuals.tableview.actions.MoveColumnAction;
import com.sas.swing.visuals.tableview.actions.SelectorAction;
import com.sas.swing.visuals.tableview.actions.SortAction;
import com.sas.swing.visuals.tableview.actions.TableViewAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SwingTableViewSupport
extends BaseTableViewSupport
implements DynamicActionCountInterface,
SwingRelationalActionTypeKeysInterface,
SwingTableViewAreaInterface {
    public SwingTableViewSupport(Class actionClass) {
        super(actionClass);
    }

    @Override
    protected void registerDynamicValueInfo() {
        super.registerDynamicValueInfo();
        this.addDynamicValueInfo("TITLE_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("ROW_HEADER_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("COLUMN_HEADER_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("DATA_CELL_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "column", null, null, "modelColumn", false);
        this.addDynamicValueInfo("EDIT_COLUMN_AREA", "column", null, null, "modelColumn", false);
    }

    @Override
    public int getActionCount(ActionSupportFilter actionFilter, String actionType) {
        if (actionType == "SHOW_COLUMN_ACTION") {
            TableView table = (TableView)actionFilter.getAttribute("table");
            if (table != null) {
                return table.getHiddenColumns().size();
            }
            return 0;
        }
        if (actionType == "RELEASE_COLUMN_ACTION") {
            TableView table = (TableView)actionFilter.getAttribute("table");
            int selectedColumn = (Integer)actionFilter.getAttribute("column");
            if (table != null && table.getColumnCount() > selectedColumn) {
                if (selectedColumn != -1 && table.getColumnHeader().isHeld(table.convertColumnIndexToModel(selectedColumn))) {
                    return table.getColumnHeader().getHeldIndices().size() - 1;
                }
                return table.getColumnHeader().getHeldIndices().size();
            }
            return 0;
        }
        if (actionType == "RELEASE_SELECTED_COLUMN_ACTION") {
            TableView table = (TableView)actionFilter.getAttribute("table");
            int selectedColumn = (Integer)actionFilter.getAttribute("column");
            if (table != null && table.getColumnCount() > selectedColumn && selectedColumn != -1 && table.getColumnHeader().isHeld(table.convertColumnIndexToModel(selectedColumn))) {
                return 1;
            }
            return 0;
        }
        if (actionType == "RELEASE_ROW_ACTION") {
            TableView table = (TableView)actionFilter.getAttribute("table");
            int selectedRow = (Integer)actionFilter.getAttribute("row");
            if (table != null) {
                if (selectedRow != -1 && table.getRowHeader().isHeld(table.convertRowIndexToModel(selectedRow))) {
                    return table.getRowHeader().getHeldIndices().size() - 1;
                }
                return table.getRowHeader().getHeldIndices().size();
            }
            return 0;
        }
        if (actionType == "RELEASE_SELECTED_ROW_ACTION") {
            TableView table = (TableView)actionFilter.getAttribute("table");
            int selectedRow = (Integer)actionFilter.getAttribute("row");
            if (table != null && selectedRow != -1 && table.getRowHeader().isHeld(table.convertRowIndexToModel(selectedRow))) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    @Override
    protected void createDefaultActions() {
        super.createDefaultActions();
        this.addAreaType("TOOLBAR_AREA");
        this.registerToolBarActions("TOOLBAR_AREA");
        this.setActionOrderList(this.getToolBarOrderList(2), null, "TOOLBAR_AREA");
        this.registerHeaderActions("ROW_HEADER_AREA");
        this.setActionOrderList(this.getHeaderOrderList(0), null, "ROW_HEADER_AREA");
        this.registerHeaderActions("COLUMN_HEADER_AREA");
        this.setActionOrderList(this.getHeaderOrderList(1), null, "COLUMN_HEADER_AREA");
        this.registerDataCellActions("DATA_CELL_AREA");
        this.setActionOrderList(this.getDataCellOrderList(0), null, "DATA_CELL_AREA");
        this.registerDragColumnActions("DRAG_COLUMN_AREA");
    }

    protected void registerToolBarActions(String areaType) {
        this.createAndRegisterAction(areaType, "SORT_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "ADVANCED_FILTER_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "DATAITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "TOTALS_ACTION");
        this.createAndRegisterAction(areaType, "PERCENT_CALCULATIONS_SELECTOR_ACTION");
    }

    protected void registerHeaderActions(String areaType) {
        this.createAndRegisterAction(areaType, "CLEAR_ACTION");
        this.createAndRegisterAction(areaType, "COPY_ACTION");
        this.createAndRegisterAction(areaType, "CUT_ACTION");
        this.createAndRegisterAction(areaType, "PASTE_ACTION");
        this.createAndRegisterAction(areaType, "EXPORT_TO_EXCEL_ACTION");
        this.createAndRegisterAction(areaType, "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "ADVANCED_FILTER_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "DATAITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "TOTALS_ACTION");
        this.createAndRegisterAction(areaType, "PERCENT_CALCULATIONS_SELECTOR_ACTION");
        if (areaType.equals("ROW_HEADER_AREA")) {
            this.createAndRegisterAction(areaType, "HOLD_ROW_TOP_ACTION");
            this.createAndRegisterAction(areaType, "HOLD_ROW_BOTTOM_ACTION");
            this.createAndRegisterAction(areaType, "HOLD_ROW_MENU_ACTION");
            this.createAndRegisterAction(areaType, "ADD_ROW_ACTION");
            this.createAndRegisterAction(areaType, "CANCEL_ROW_INSERT_ACTION");
            this.createAndRegisterAction(areaType, "COMMIT_INSERTED_ROW_ACTION");
            this.createAndRegisterAction(areaType, "DELETE_ROW_ACTION");
            this.createAndRegisterAction(areaType, "INSERT_ROW_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_ALL_ROWS_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_ROW_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_SELECTED_ROW_ACTION");
        } else {
            this.createAndRegisterAction(areaType, "HIDE_COLUMN_ACTION");
            this.createAndRegisterAction(areaType, "HOLD_COLUMN_LEFT_ACTION");
            this.createAndRegisterAction(areaType, "HOLD_COLUMN_RIGHT_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_ALL_COLUMNS_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_COLUMN_ACTION");
            this.createAndRegisterAction(areaType, "RELEASE_SELECTED_COLUMN_ACTION");
            this.createAndRegisterAction(areaType, "SHOW_ALL_COLUMNS_ACTION");
            this.createAndRegisterAction(areaType, "SHOW_COLUMN_ACTION");
            this.createAndRegisterAction(areaType, "MOVE_COLUMN_MENU_ACTION");
            this.createAndRegisterAction(areaType, "MOVE_COLUMN_LEFT_ACTION");
            this.createAndRegisterAction(areaType, "MOVE_COLUMN_RIGHT_ACTION");
            this.createAndRegisterAction(areaType, "CLEAR_SORT_ACTION");
            this.createAndRegisterAction(areaType, "SORT_COLUMN_ASCENDING_ACTION");
            this.createAndRegisterAction(areaType, "SORT_COLUMN_DESCENDING_ACTION");
            this.createAndRegisterAction(areaType, "SORT_SELECTOR_ACTION");
        }
    }

    protected void registerDataCellActions(String areaType) {
        this.createAndRegisterAction(areaType, "CLEAR_ACTION");
        this.createAndRegisterAction(areaType, "COPY_ACTION");
        this.createAndRegisterAction(areaType, "CUT_ACTION");
        this.createAndRegisterAction(areaType, "PASTE_ACTION");
        this.createAndRegisterAction(areaType, "HIDE_COLUMN_ACTION");
        this.createAndRegisterAction(areaType, "HOLD_COLUMN_LEFT_ACTION");
        this.createAndRegisterAction(areaType, "HOLD_COLUMN_RIGHT_ACTION");
        this.createAndRegisterAction(areaType, "HOLD_ROW_TOP_ACTION");
        this.createAndRegisterAction(areaType, "HOLD_ROW_BOTTOM_ACTION");
        this.createAndRegisterAction(areaType, "HOLD_ROW_MENU_ACTION");
        this.createAndRegisterAction(areaType, "ADD_ROW_ACTION");
        this.createAndRegisterAction(areaType, "CANCEL_ROW_INSERT_ACTION");
        this.createAndRegisterAction(areaType, "COMMIT_INSERTED_ROW_ACTION");
        this.createAndRegisterAction(areaType, "DELETE_ROW_ACTION");
        this.createAndRegisterAction(areaType, "INSERT_ROW_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_ALL_COLUMNS_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_ALL_ROWS_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_COLUMN_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_SELECTED_COLUMN_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_ROW_ACTION");
        this.createAndRegisterAction(areaType, "RELEASE_SELECTED_ROW_ACTION");
        this.createAndRegisterAction(areaType, "SHOW_ALL_COLUMNS_ACTION");
        this.createAndRegisterAction(areaType, "SHOW_COLUMN_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_MENU_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_LEFT_ACTION");
        this.createAndRegisterAction(areaType, "MOVE_COLUMN_RIGHT_ACTION");
        this.createAndRegisterAction(areaType, "EXPORT_TO_EXCEL_ACTION");
        this.createAndRegisterAction(areaType, "CLEAR_SORT_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_ASCENDING_ACTION");
        this.createAndRegisterAction(areaType, "SORT_COLUMN_DESCENDING_ACTION");
        this.createAndRegisterAction(areaType, "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "SORT_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "ADVANCED_FILTER_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "DATAITEM_SELECTOR_ACTION");
        this.createAndRegisterAction(areaType, "TOTALS_ACTION");
        this.createAndRegisterAction(areaType, "PERCENT_CALCULATIONS_SELECTOR_ACTION");
    }

    protected void registerDragColumnActions(String areaType) {
        this.createAndRegisterAction(areaType, "DRAG_COLUMN_ACTION");
    }

    protected ActionOrderList getDataCellOrderList(int type) {
        ActionOrderList dataCellOrderList = new ActionOrderList("ROOT_NAME", 22);
        dataCellOrderList.setEnabledIfEmpty(false);
        dataCellOrderList.add("CUT_ACTION");
        dataCellOrderList.add("COPY_ACTION");
        dataCellOrderList.add("PASTE_ACTION");
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add("CLEAR_ACTION");
        dataCellOrderList.add(this.getEditTableOrderList(type));
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add(this.getSortOrderList(type));
        dataCellOrderList.add(this.getMoveColumnOrderList(type));
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add("HIDE_COLUMN_ACTION");
        dataCellOrderList.add(this.getShowOrderList(type));
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add(this.getHoldColumnOrderList(type));
        dataCellOrderList.add(this.getReleaseColumnOrderList(type));
        dataCellOrderList.add(this.getHoldRowOrderList(type));
        dataCellOrderList.add(this.getReleaseRowOrderList(type));
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        dataCellOrderList.add("ADVANCED_FILTER_SELECTOR_ACTION");
        dataCellOrderList.add("DATAITEM_SELECTOR_ACTION");
        dataCellOrderList.add("TOTALS_ACTION");
        dataCellOrderList.add("PERCENT_CALCULATIONS_SELECTOR_ACTION");
        dataCellOrderList.add(ActionList.SEPARATOR);
        dataCellOrderList.add("EXPORT_TO_EXCEL_ACTION");
        return dataCellOrderList;
    }

    protected ActionOrderList getToolBarOrderList(int type) {
        ActionOrderList toolbarOrderList = new ActionOrderList("ROOT_NAME", 20);
        toolbarOrderList.setEnabledIfEmpty(false);
        toolbarOrderList.add("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        toolbarOrderList.add("SORT_SELECTOR_ACTION");
        toolbarOrderList.add("ADVANCED_FILTER_SELECTOR_ACTION");
        toolbarOrderList.add("DATAITEM_SELECTOR_ACTION");
        toolbarOrderList.add("TOTALS_ACTION");
        toolbarOrderList.add("PERCENT_CALCULATIONS_SELECTOR_ACTION");
        return toolbarOrderList;
    }

    protected ActionOrderList getHeaderOrderList(int type) {
        ActionOrderList headerOrderList = new ActionOrderList("ROOT_NAME", 19);
        headerOrderList.setEnabledIfEmpty(false);
        headerOrderList.add("CUT_ACTION");
        headerOrderList.add("COPY_ACTION");
        headerOrderList.add("PASTE_ACTION");
        headerOrderList.add(ActionList.SEPARATOR);
        headerOrderList.add("CLEAR_ACTION");
        if (type == 0) {
            headerOrderList.add(this.getEditTableOrderList(type));
            headerOrderList.add(ActionList.SEPARATOR);
            headerOrderList.add(this.getHoldRowOrderList(type));
            headerOrderList.add(this.getReleaseRowOrderList(type));
        } else if (type == 1) {
            headerOrderList.add(ActionList.SEPARATOR);
            headerOrderList.add(this.getSortOrderList(type));
            headerOrderList.add(this.getMoveColumnOrderList(type));
            headerOrderList.add(ActionList.SEPARATOR);
            headerOrderList.add("HIDE_COLUMN_ACTION");
            headerOrderList.add(this.getShowOrderList(type));
            headerOrderList.add(ActionList.SEPARATOR);
            headerOrderList.add(this.getHoldColumnOrderList(type));
            headerOrderList.add(this.getReleaseColumnOrderList(type));
        }
        headerOrderList.add(ActionList.SEPARATOR);
        headerOrderList.add("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION");
        headerOrderList.add("ADVANCED_FILTER_SELECTOR_ACTION");
        headerOrderList.add("DATAITEM_SELECTOR_ACTION");
        headerOrderList.add("TOTALS_ACTION");
        headerOrderList.add("PERCENT_CALCULATIONS_SELECTOR_ACTION");
        headerOrderList.add(ActionList.SEPARATOR);
        headerOrderList.add("EXPORT_TO_EXCEL_ACTION");
        return headerOrderList;
    }

    private ActionOrderList getSortOrderList(int type) {
        ActionOrderList sortOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "sortLabel.txt"), 4);
        sortOrderList.setEnabledIfEmpty(false);
        sortOrderList.add("SORT_COLUMN_ASCENDING_ACTION");
        sortOrderList.add("SORT_COLUMN_DESCENDING_ACTION");
        sortOrderList.add("CLEAR_SORT_ACTION");
        sortOrderList.add("SORT_SELECTOR_ACTION");
        return sortOrderList;
    }

    private ActionOrderList getMoveColumnOrderList(int type) {
        ActionOrderList moveColumnOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "moveColumnLabel.txt"), 2);
        moveColumnOrderList.setEnabledIfEmpty(false);
        moveColumnOrderList.setActionType("MOVE_COLUMN_MENU_ACTION");
        moveColumnOrderList.add("MOVE_COLUMN_LEFT_ACTION");
        moveColumnOrderList.add("MOVE_COLUMN_RIGHT_ACTION");
        return moveColumnOrderList;
    }

    private ActionOrderList getEditTableOrderList(int type) {
        ActionOrderList editTableOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "editTableLabel.txt"), 2);
        editTableOrderList.setEnabledIfEmpty(false);
        editTableOrderList.add("ADD_ROW_ACTION");
        editTableOrderList.add("INSERT_ROW_ACTION");
        editTableOrderList.add("COMMIT_INSERTED_ROW_ACTION");
        editTableOrderList.add("CANCEL_ROW_INSERT_ACTION");
        editTableOrderList.add("DELETE_ROW_ACTION");
        return editTableOrderList;
    }

    private ActionOrderList getShowOrderList(int type) {
        ActionOrderList showOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "showColumnLabel.txt"), 3);
        showOrderList.setEnabledIfEmpty(false);
        showOrderList.add("SHOW_COLUMN_ACTION");
        showOrderList.add(ActionList.SEPARATOR);
        showOrderList.add("SHOW_ALL_COLUMNS_ACTION");
        return showOrderList;
    }

    private ActionOrderList getHoldRowOrderList(int type) {
        ActionOrderList holdRowOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "holdRowLabel.txt"), 2);
        holdRowOrderList.setEnabledIfEmpty(false);
        holdRowOrderList.setActionType("HOLD_ROW_MENU_ACTION");
        holdRowOrderList.add("HOLD_ROW_TOP_ACTION");
        holdRowOrderList.add("HOLD_ROW_BOTTOM_ACTION");
        return holdRowOrderList;
    }

    private ActionOrderList getHoldColumnOrderList(int type) {
        ActionOrderList holdColumnOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "holdColumnLabel.txt"), 2);
        holdColumnOrderList.setEnabledIfEmpty(false);
        holdColumnOrderList.add("HOLD_COLUMN_LEFT_ACTION");
        holdColumnOrderList.add("HOLD_COLUMN_RIGHT_ACTION");
        return holdColumnOrderList;
    }

    private ActionOrderList getReleaseRowOrderList(int type) {
        ActionOrderList releaseRowOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "releaseRowLabel.txt"), 4);
        releaseRowOrderList.setEnabledIfEmpty(false);
        releaseRowOrderList.add("RELEASE_SELECTED_ROW_ACTION");
        releaseRowOrderList.add(ActionList.SEPARATOR);
        releaseRowOrderList.add("RELEASE_ROW_ACTION");
        releaseRowOrderList.add(ActionList.SEPARATOR);
        releaseRowOrderList.add("RELEASE_ALL_ROWS_ACTION");
        return releaseRowOrderList;
    }

    private ActionOrderList getReleaseColumnOrderList(int type) {
        ActionOrderList releaseColumnOrderList = new ActionOrderList(RB.getStringResource("BaseTableViewSupport.", "releaseColumnLabel.txt"), 4);
        releaseColumnOrderList.setEnabledIfEmpty(false);
        releaseColumnOrderList.add("RELEASE_SELECTED_COLUMN_ACTION");
        releaseColumnOrderList.add(ActionList.SEPARATOR);
        releaseColumnOrderList.add("RELEASE_COLUMN_ACTION");
        releaseColumnOrderList.add(ActionList.SEPARATOR);
        releaseColumnOrderList.add("RELEASE_ALL_COLUMNS_ACTION");
        return releaseColumnOrderList;
    }

    @Override
    public BaseAction newActionInstance(String areaType, String actionType) {
        BaseAction action = null;
        Class _actionClass = this.getActionClass();
        if (_actionClass != null) {
            try {
                action = actionType == "DELETE_ROW_ACTION" ? (BaseAction)DeleteRowAction.class.newInstance() : (actionType == "ADD_ROW_ACTION" ? (BaseAction)AddRowAction.class.newInstance() : (actionType == "MOVE_COLUMN_LEFT_ACTION" || actionType == "MOVE_COLUMN_RIGHT_ACTION" ? (BaseAction)MoveColumnAction.class.newInstance() : (actionType == "CLEAR_SORT_ACTION" || actionType == "SORT_COLUMN_ASCENDING_ACTION" || actionType == "SORT_COLUMN_DESCENDING_ACTION" ? (BaseAction)SortAction.class.newInstance() : (actionType == "SORT_SELECTOR_ACTION" || actionType == "ADVANCED_FILTER_SELECTOR_ACTION" || actionType == "DATAITEM_SELECTOR_ACTION" || actionType == "TOTALS_ACTION" || actionType == "SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION" || actionType == "PERCENT_CALCULATIONS_SELECTOR_ACTION" ? (BaseAction)SelectorAction.class.newInstance() : (BaseAction)TableViewAction.class.newInstance()))));
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            ActionStrategyInterface asi = SwingRelationalActionStrategyFactory.getActionStrategy(areaType, actionType, true);
            if (asi == null) {
                return null;
            }
            action.setActionStrategy(asi);
            action.setActionType(actionType);
            asi.initializeAction(action, areaType, this.getLocale());
        }
        return action;
    }

    @Override
    protected Map getActionScopeAttributeMap(String actionType, ActionSupportFilter filter) {
        HashMap actionScopeAttributeMap = ActionProviderMapPool.getMap();
        return actionScopeAttributeMap;
    }

    @Override
    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap areaScopeAttributeMap = ActionProviderMapPool.getMap();
        return areaScopeAttributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean validArea(Area area, ActionSupportFilter filter) {
        String type = null;
        if (area != null && (type = area.getType()) != null) {
            List values = null;
            if (!type.equals(filter.getAreaType())) {
                return false;
            }
            values = area.getValues();
            if (values == null || values.size() <= 0) {
                return true;
            }
            if (type == "COLUMN_HEADER_AREA") {
                Object c;
                TableModel model = (TableModel)filter.getAttribute("model");
                Integer modelColumnNumber = (Integer)filter.getAttribute("modelColumn");
                String columnName = null;
                if (model != null && modelColumnNumber != null && modelColumnNumber >= 0) {
                    columnName = TableViewUtil.getColumnName(model, modelColumnNumber);
                }
                TableView table = (TableView)filter.getAttribute("table");
                Integer viewerColumnNumber = (Integer)filter.getAttribute("column");
                String columnIdentifier = null;
                if (table != null && viewerColumnNumber != null) {
                    c = table.getColumnModel().getColumn(viewerColumnNumber - 1);
                    columnIdentifier = ((TableColumn)c).getIdentifier().toString();
                }
                if (columnName != null || columnIdentifier != null) {
                    c = values;
                    synchronized (c) {
                        for (String areaValue : values) {
                            if (areaValue == null || !areaValue.equals(columnName) && !areaValue.equals(columnIdentifier)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            if (type == "DATA_CELL_AREA") {
                TableModel model = (TableModel)filter.getAttribute("model");
                Integer modelColumnNumber = (Integer)filter.getAttribute("modelColumn");
                String columnName = null;
                if (model != null && modelColumnNumber != null && modelColumnNumber >= 0) {
                    columnName = TableViewUtil.getColumnName(model, modelColumnNumber);
                }
                TableView table = (TableView)filter.getAttribute("table");
                Integer viewerColumnNumber = (Integer)filter.getAttribute("column");
                String columnIdentifier = null;
                if (table != null && viewerColumnNumber != null) {
                    TableColumn c = table.getColumnModel().getColumn(viewerColumnNumber - 1);
                    columnIdentifier = c.getIdentifier().toString();
                }
                if (columnName != null || columnIdentifier != null) {
                    List list = values;
                    synchronized (list) {
                        for (String areaValue : values) {
                            if (areaValue == null || !areaValue.equals(columnName) && !areaValue.equals(columnIdentifier)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            if (type == "TITLE_AREA") {
                return true;
            }
            if (type == "ROW_HEADER_AREA") {
                return true;
            }
            return type == "TOOLBAR_AREA";
        }
        return true;
    }
}

