/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.RB;
import com.sas.actionprovider.SwingAction;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedSource;
import com.sas.util.Classes;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

@SASScope(value="ALL")
public class SwingActionProvider
extends BaseActionProvider
implements ContentsChangedSource {
    static final String RB_KEY = "SwingActionProvider.";
    private Class swingActionClass = SwingAction.class;

    public SwingActionProvider() {
        this.setActionClass(SwingAction.class);
        this.initSupportClassNames();
    }

    @Override
    @SASScope
    public void addSupportClass(String supportTypeKey, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (supportTypeKey == null || supportTypeKey.length() <= 0 || className == null || className.length() <= 0) {
            return;
        }
        Class supportClass = null;
        BaseActionProviderSupport support = null;
        supportClass = Classes.loadClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Object)this);
        if (supportClass == null) {
            return;
        }
        support = (BaseActionProviderSupport)supportClass.newInstance();
        if (support == null || !(support instanceof BaseActionProviderSupport)) {
            return;
        }
        this.getAllSupportClassNamesMap().put(supportTypeKey, className);
    }

    private void initSupportClassNames() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("SwingSupportClasses.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getDefaultSupportClassNamesMap().putAll(properties);
        this.getAllSupportClassNamesMap().putAll(properties);
    }

    @Override
    @SASScope
    protected Class getSupportClass(String supportType) {
        if (supportType == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullSupportType.txt"));
        }
        Map supportClassesMap = this.getSupportClassesMap();
        Class supportClass = (Class)supportClassesMap.get(supportType);
        if (supportClass == null) {
            String supportClassName = (String)this.getAllSupportClassNamesMap().get(supportType);
            if (supportClassName != null) {
                try {
                    supportClass = Classes.loadClass((String)supportClassName, (ClassLoader)Thread.currentThread().getContextClassLoader(), (Object)this);
                    supportClassesMap.put(supportType, supportClass);
                }
                catch (ClassNotFoundException cnfex) {
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "supportNotFound.txt"));
                }
            } else {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidSupportKey.txt", this.getLocale()));
            }
        }
        return supportClass;
    }

    public void fireContentsChanged(ActionProviderEvent event) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.contentsChanged((ContentsChangedEvent)event);
        }
    }
}

