/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.ActionAttributeDescriptor;
import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionStatusKeysInterface;
import com.sas.actionprovider.AttributeTypeFactory;
import com.sas.actionprovider.BaseActionProvider;
import com.sas.actionprovider.SupplementalPropertyKeysInterface;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.CompositeDynamicAttributeCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.BaseEntity;
import com.sas.swing.util.Action;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.TransformException;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.SwingPropertyChangeSupport;

@SASScope(value="ALL")
public abstract class BaseAction
extends BaseEntity
implements Action,
ActionStatusKeysInterface,
SupplementalPropertyKeysInterface {
    @SASScope
    protected SwingPropertyChangeSupport changeSupport;
    private boolean enabled;
    private boolean allDescriptorsLoaded;
    private DynamicAttributeCommandInterface command;
    private String actionType;
    private boolean custom;
    private BaseActionProvider actionProvider;
    private ActionProviderViewInterface viewer;
    private List attributeDescriptors;
    private static Set interfaceKeysList = Collections.synchronizedSet(new HashSet(32, 1.0f));
    private static AttributeTypeFactoryInterface attributeTypeFactory;
    private boolean active;
    private int returnStatus;
    private ActionStrategyInterface actionStrategy;
    private String id;
    static final String RB_KEY = "BaseAction.";

    public BaseAction() {
        this(null);
    }

    public BaseAction(DynamicAttributeCommandInterface command) {
        this.setCommand(command);
        this.setEnabled(true);
        this.setActive(true);
        this.setReturnStatus(0);
        this.setCustom(true);
    }

    @SASScope
    public Collection listActionKeys() {
        return interfaceKeysList;
    }

    @SASScope
    public BaseActionProvider getActionProvider() {
        return this.actionProvider;
    }

    @SASScope
    public void setActionProvider(BaseActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public DynamicAttributeCommandInterface getCommand() {
        return this.command;
    }

    public void setCommand(DynamicAttributeCommandInterface command) {
        this.command = command;
    }

    @SASScope
    public ActionProviderViewInterface getViewer() {
        return this.viewer;
    }

    @SASScope
    public void setViewer(ActionProviderViewInterface viewer) {
        this.viewer = viewer;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void setReturnStatus(int returnStatus) {
        this.returnStatus = returnStatus;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @SASScope
    public boolean isEnabled() {
        return this.enabled;
    }

    @SASScope
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public Object getValue(String attributeName) {
        if (this.containsAttributeNamed(attributeName)) {
            return this.getAttribute(attributeName);
        }
        return null;
    }

    public void putValue(String attributeName, Object attributeValue) {
        try {
            this.setAttribute(attributeName, attributeValue);
        }
        catch (AttributeSetException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected boolean setAttribute(String attributeName, Map propertyDescriptors, Object[] args) throws AttributeSetException {
        boolean returnValue = super.setAttribute(attributeName, propertyDescriptors, args);
        AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName);
        return returnValue;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void actionPerformed(ActionEvent event) {
        DynamicAttributeCommandInterface command = this.getCommand();
        if (command != null) {
            this.applyCommandAttributes(command);
            this.executeCommand(command);
            this.fireEvent(command);
        }
    }

    public void performAction() {
        this.actionPerformed(null);
    }

    protected void applyCommandAttributes(DynamicAttributeCommandInterface command) {
        if (command != null) {
            if (command instanceof CompositeDynamicAttributeCommand) {
                this.applyCompositeCommandAttributes((CompositeDynamicAttributeCommand)command);
            } else {
                this.applySingleCommandAttributes(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeCommandAttributes(CompositeDynamicAttributeCommand command) {
        Collection commandAttributeNames = command.getCommandAttributeNames();
        if (commandAttributeNames != null) {
            Collection collection = commandAttributeNames;
            synchronized (collection) {
                for (String attributeName : commandAttributeNames) {
                    Object attributeValue;
                    if (attributeName == null || (attributeValue = this.getValue(attributeName)) == null) continue;
                    try {
                        command.setAttribute(attributeName, attributeValue);
                    }
                    catch (AttributeSetException attributeSetException) {}
                }
            }
        }
    }

    private void applySingleCommandAttributes(DynamicAttributeCommandInterface command) {
        if (command != null) {
            Class<?> commandClass = command.getClass();
            BeanInfo beanInfo = null;
            try {
                beanInfo = Introspector.getBeanInfo(commandClass);
            }
            catch (IntrospectionException e) {
                return;
            }
            PropertyDescriptor[] pd = null;
            if (beanInfo != null) {
                pd = beanInfo.getPropertyDescriptors();
                if (pd == null) {
                    return;
                }
            } else {
                return;
            }
            int length = Array.getLength(pd);
            BaseTransforms stringTransform = new BaseTransforms(BaseAction.class, "StringTransformRegistry.config");
            for (int i = 0; i < length; ++i) {
                Class<?> attributeTypeClass;
                Object attributeValue;
                String attributeName = pd[i].getName();
                if (attributeName == null || (attributeValue = this.getValue(attributeName)) == null) continue;
                if (attributeValue instanceof String && (attributeTypeClass = pd[i].getPropertyType()) != null) {
                    try {
                        attributeValue = stringTransform.transform(attributeValue, attributeTypeClass);
                    }
                    catch (TransformException te) {
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                try {
                    command.setAttribute(attributeName, attributeValue);
                    continue;
                }
                catch (AttributeSetException attributeSetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void executeCommand(DynamicAttributeCommandInterface command) {
        if (command.isExecutable()) {
            if (command instanceof CompositeDynamicAttributeCommand) {
                int rc = ((CompositeDynamicAttributeCommand)command).apply(null);
                if (rc == 1) {
                    command.undo();
                }
            } else {
                command.execute(null);
            }
        }
    }

    @SASScope
    public boolean isActive() {
        return this.active;
    }

    @SASScope
    public void setActive(boolean active) {
        this.active = active;
    }

    public ActionStrategyInterface getActionStrategy() {
        return this.actionStrategy;
    }

    public void setActionStrategy(ActionStrategyInterface actionStrategy) {
        this.actionStrategy = actionStrategy;
    }

    protected void fireEvent(DynamicAttributeCommandInterface command) {
        if (command instanceof ContentsChangedInterface && this.actionProvider != null && this.actionProvider instanceof SwingActionProvider && ((ContentsChangedInterface)((Object)command)).isContentsChanged()) {
            ((SwingActionProvider)this.actionProvider).fireContentsChanged(new ActionProviderEvent(((ContentsChangedInterface)((Object)command)).getEventSource(), ((ContentsChangedInterface)((Object)command)).getEventInfo()));
        }
    }

    public AttributeDescriptorInterface getAttributeDescriptor(String attributeName) throws NoSuchElementException {
        AttributeDescriptorInterface returnValue = null;
        List adis = this._getAttributeDescriptors();
        int size = adis.size();
        for (int i = 0; i < size; ++i) {
            AttributeDescriptorInterface adi = (AttributeDescriptorInterface)adis.get(i);
            if (!adi.getName().equals(attributeName)) continue;
            returnValue = adi;
            i = size;
        }
        if (returnValue != null) {
            return returnValue;
        }
        if (this.getPropertyDescriptors().containsKey(attributeName)) {
            ActionAttributeDescriptor aad = new ActionAttributeDescriptor(attributeName);
            aad.setDynamic(false);
            aad.setCommand(false);
            returnValue = aad;
        } else if (((Map)this.getDelegate()).containsKey(attributeName)) {
            returnValue = new ActionAttributeDescriptor(attributeName);
        } else {
            throw new NoSuchElementException(attributeName);
        }
        adis.add(returnValue);
        return returnValue;
    }

    private synchronized List _getAttributeDescriptors() {
        if (this.attributeDescriptors == null) {
            this.attributeDescriptors = new ArrayList();
        }
        return this.attributeDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDescriptorInterface[] getAttributeDescriptors() {
        List adiList = this._getAttributeDescriptors();
        if (!this.allDescriptorsLoaded) {
            Map propertyDescriptors;
            Map map = propertyDescriptors = this.getPropertyDescriptors();
            synchronized (map) {
                for (String attributeName : propertyDescriptors.keySet()) {
                    if (adiList.contains(attributeName)) continue;
                    ActionAttributeDescriptor aad = new ActionAttributeDescriptor(attributeName);
                    aad.setDynamic(false);
                    aad.setCommand(false);
                    adiList.add(aad);
                }
            }
            this.allDescriptorsLoaded = true;
        }
        return adiList.toArray(new AttributeDescriptorInterface[adiList.size()]);
    }

    @SASScope
    public synchronized void removeAttribute(String attributeName) {
        super.removeAttribute(attributeName);
        if (this.attributeDescriptors == null) {
            return;
        }
        int numDescriptors = this.attributeDescriptors.size();
        for (int i = 0; i < numDescriptors; ++i) {
            AttributeDescriptorInterface adi = (AttributeDescriptorInterface)this.attributeDescriptors.get(i);
            if (!adi.getName().equals(attributeName)) continue;
            this.attributeDescriptors.remove(i);
            return;
        }
    }

    @SASScope
    public List getCurrentAttributeDescriptors() {
        return this._getAttributeDescriptors();
    }

    @SASScope
    public void setCurrentAttributeDescriptors(List adis) {
        if (adis == null) {
            return;
        }
        List descriptors = this._getAttributeDescriptors();
        descriptors.clear();
        int size = adis.size();
        for (int i = 0; i < size; ++i) {
            descriptors.add(adis.get(i));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BaseAction clone = (BaseAction)super.clone();
        clone.attributeDescriptors = (List)((ArrayList)this._getAttributeDescriptors()).clone();
        return clone;
    }

    @SASScope
    public void reset() {
        super.reset();
        this.enabled = true;
        this.active = true;
        this.returnStatus = 0;
        this.custom = true;
        this.changeSupport = null;
        this.command = null;
        this.actionType = null;
        this.actionProvider = null;
        this.viewer = null;
        this.attributeDescriptors.clear();
        this.allDescriptorsLoaded = false;
        this.actionStrategy = null;
        this.id = null;
    }

    @SASScope
    public static void moveAttributes(BaseAction source, BaseAction target) {
        target.setEnabled(source.isEnabled());
        target.setActive(source.isActive());
        target.setReturnStatus(source.getReturnStatus());
        target.setCustom(source.isCustom());
        target.setCommand(source.getCommand());
        target.setActionType(source.getActionType());
        target.setActionStrategy(source.getActionStrategy());
        target.setCurrentAttributeDescriptors(source.getCurrentAttributeDescriptors());
        target.setId(source.getId());
        ((Map)target.getDelegate()).putAll((Map)source.getDelegate());
    }

    @SASScope
    public static AttributeTypeFactoryInterface getAttributeTypeFactory() {
        if (attributeTypeFactory == null) {
            attributeTypeFactory = new AttributeTypeFactory();
        }
        return attributeTypeFactory;
    }

    @SASScope
    public String getId() {
        return this.id;
    }

    @SASScope
    public void setId(String id) {
        this.id = id;
    }

    static {
        interfaceKeysList.add("AcceleratorKey");
        interfaceKeysList.add("ActionCommandKey");
        interfaceKeysList.add("Default");
        interfaceKeysList.add("LongDescription");
        interfaceKeysList.add("MnemonicKey");
        interfaceKeysList.add("Name");
        interfaceKeysList.add("ShortDescription");
        interfaceKeysList.add("SmallIcon");
        interfaceKeysList.add("Label");
        interfaceKeysList.add("SmallIconName");
        interfaceKeysList.add("SmallDisabledIcon");
        interfaceKeysList.add("SmallDisabledIconName");
        interfaceKeysList.add("ShortDisabledDescription");
        interfaceKeysList.add("LargeIcon");
        interfaceKeysList.add("LargeIconName");
        interfaceKeysList.add("LargeDisabledIcon");
        interfaceKeysList.add("LargeDisabledIconName");
        interfaceKeysList.add("LongDescription");
        interfaceKeysList.add("LongDisabledDescription");
        interfaceKeysList.add("RolloverIconName");
        interfaceKeysList.add("Type");
        interfaceKeysList.add("TextAlignment");
        interfaceKeysList.add("ImageKey");
        interfaceKeysList.add("DisabledImageKey");
        interfaceKeysList.add("RolloverImageKey");
        interfaceKeysList.add("GroupName");
        interfaceKeysList.add("CommandClass");
        interfaceKeysList.add("URL");
        interfaceKeysList.add("AlternateText");
        interfaceKeysList.add("Target");
        interfaceKeysList.add("LongDisabledDescription");
        interfaceKeysList.add("StyleMap");
        interfaceKeysList.add("MnemonicIndex");
    }
}

