/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.RB;
import com.sas.codepolicy.SASScope;
import com.sas.swing.util.ActionList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

@SASScope(value="ALL")
public class ActionOrderList
extends Vector {
    @SASScope
    public static final String ROOT_NAME = "ROOT_NAME";
    static final String RB_KEY = "ActionOrderList.";
    private String name;
    private Locale locale;
    private String actionType;
    private boolean enabledIfEmpty;
    private Map rootRenderInfoMap;

    public ActionOrderList() {
        this((String)null);
    }

    public ActionOrderList(String name) {
        this(name, 5);
    }

    public ActionOrderList(String name, int initialCapacity) {
        super(initialCapacity);
        this.setName(name);
        this.setEnabledIfEmpty(true);
    }

    @SASScope
    public static ActionOrderList copy(ActionOrderList source) {
        if (source == null) {
            return null;
        }
        ActionOrderList target = new ActionOrderList();
        target.setActionType(source.getActionType());
        target.setLocale(source.getLocale());
        target.setName(source.getName());
        target.setEnabledIfEmpty(source.isEnabledIfEmpty());
        Map map = source.getRootRenderInfoMap();
        if (map != null) {
            target.setRootRenderInfoMap(new HashMap(map));
        }
        if (source.isEmpty()) {
            return target;
        }
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            Object o = source.get(i);
            if (o instanceof ActionOrderList) {
                target.add(ActionOrderList.copy((ActionOrderList)o));
                continue;
            }
            target.add(o);
        }
        return target;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabledIfEmpty() {
        return this.enabledIfEmpty;
    }

    public void setEnabledIfEmpty(boolean enabledIfEmpty) {
        this.enabledIfEmpty = enabledIfEmpty;
    }

    @SASScope
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @SASScope
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Override
    public void add(int index, Object element) {
        if (!this.isValidElement(element)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
        }
        super.add(index, element);
    }

    @Override
    public boolean add(Object element) {
        if (this.isValidElement(element)) {
            return super.add(element);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        if (this.isValidCollection(collection)) {
            return super.addAll(collection);
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
    }

    @Override
    public boolean addAll(int index, Collection collection) {
        if (this.isValidCollection(collection)) {
            return super.addAll(index, collection);
        }
        throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
    }

    public void addElement(Object element) {
        if (!this.isValidElement(element)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
        }
        super.addElement(element);
    }

    @Override
    public boolean contains(Object element) {
        if (!(element instanceof String) && element != ActionList.SEPARATOR) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.txt", this.getLocale()));
        }
        if (element.equals(this.getActionType())) {
            return true;
        }
        if (super.contains(element)) {
            return true;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object temp = this.get(i);
            if (!(temp instanceof ActionOrderList) || !((ActionOrderList)temp).contains(element)) continue;
            return true;
        }
        return false;
    }

    @SASScope
    protected boolean isValidElement(Object element) {
        return element instanceof String || element instanceof ActionOrderList || element == ActionList.SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected boolean isValidCollection(Collection collection) {
        if (collection != null) {
            Collection collection2 = collection;
            synchronized (collection2) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.isValidElement(iterator.next())) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public void setRootRenderInfoMap(Map rootRenderInfoMap) {
        this.rootRenderInfoMap = rootRenderInfoMap;
    }

    public Map getRootRenderInfoMap() {
        return this.rootRenderInfoMap;
    }

    @SASScope
    public void dump() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object temp = this.get(i);
            if (temp instanceof ActionOrderList) {
                System.out.println("***Beginning of nested listed named " + ((ActionOrderList)temp).getName());
                ((ActionOrderList)temp).dump();
                System.out.println("***End of nested listed named " + ((ActionOrderList)temp).getName());
                continue;
            }
            if (temp instanceof String) {
                System.out.println("action with actionType = " + (String)temp);
                continue;
            }
            if (temp == ActionList.SEPARATOR) {
                System.out.println("SEPARATOR");
                continue;
            }
            System.out.println("    !!!!!!Unknown Type!!!!!!!! ");
        }
    }

    @SASScope
    public boolean removeAll(Object element, boolean recurse) {
        Vector<Object> collectionArg = new Vector<Object>();
        collectionArg.add(element);
        boolean elementRemoved = this.removeAll(collectionArg);
        if (!recurse) {
            return elementRemoved;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object temp = this.get(i);
            if (!(temp instanceof ActionOrderList) || !((ActionOrderList)temp).removeAll(element, true)) continue;
            elementRemoved = true;
        }
        return elementRemoved;
    }
}

