/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.makefolder;

import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.batch.metadata.makefolder.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.text.Message;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class MakeFolder
extends LocalServicesBatchUtility2 {
    public static final String OPTION_MAKE_FULL_PATH = "makeFullPath";
    public static final String OPTION_DESCRIPTION = "desc";
    private String folderPath = null;
    private String parentFolderPath = null;
    private String folderName = null;
    private boolean makeFullPath = false;
    private String folderDescription = null;

    public MakeFolder() {
        this.utilityName = "sas-make-folder";
    }

    public static int makeFolder(LocalServicesBatchUtility2 parent, String folderPath, boolean makeFullPath) throws Exception {
        return MakeFolder.makeFolder(parent, folderPath, makeFullPath, null);
    }

    public static int makeFolder(LocalServicesBatchUtility2 parent, String folderPath, boolean makeFullPath, String folderDescription) throws Exception {
        MakeFolder make = new MakeFolder();
        make.setParent(parent);
        make.setFolderPath(folderPath);
        make.setMakeFullPath(makeFullPath);
        make.setFolderDescription(folderDescription);
        int rc = make.execute();
        return rc;
    }

    public void setFolderPath(String folderPath) {
        Pattern pattern = Pattern.compile("^(/(.*?/)*)([^/]+)/?$");
        Matcher matcher = pattern.matcher(folderPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(RB.getStringResource("MakeFolder.InvalidFolderPath.log"));
        }
        this.folderPath = folderPath;
        this.parentFolderPath = matcher.group(1);
        this.folderName = matcher.group(3);
    }

    public void setMakeFullPath(boolean makeFullPath) {
        this.makeFullPath = makeFullPath;
    }

    public void setFolderDescription(String folderDescription) {
        this.folderDescription = folderDescription;
    }

    public int execute() throws Exception {
        if (this.folderPath == null) {
            this.logger.error(RB.getStringResource("MakeFolder.NoFolderPath.log"));
            this.returnCode = 8;
            return this.returnCode;
        }
        try {
            this.initialize();
            this.makeTheFolder();
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    private void makeTheFolder() throws Exception {
        FolderInterface parentFolder = null;
        RootFolderInterface rootFolder = this.metadataServer.getRootFolder();
        PathUrl parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), this.parentFolderPath);
        parentFolder = (FolderInterface)this.metadataServer.getObjectByPath(parentFolderUrl);
        if (parentFolder == null && this.makeFullPath) {
            String previousFolderPath = this.folderPath;
            this.setFolderPath(this.parentFolderPath);
            this.makeTheFolder();
            this.setFolderPath(previousFolderPath);
            parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), this.parentFolderPath);
            parentFolder = (FolderInterface)this.metadataServer.getObjectByPath(parentFolderUrl);
        }
        if (parentFolder == null) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.ParentFolderDoesNotExist.fmt.log", (Object)this.parentFolderPath));
            this.returnCode = 8;
        } else if (parentFolder.getSubfolder(this.folderName) != null) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.FolderAlreadyExists.fmt.log", (Object)this.folderPath));
            this.returnCode = 0;
        } else {
            FolderInterface newFolder = parentFolder.makeSubfolder(this.folderName);
            if (newFolder != null) {
                newFolder.setDescription(this.folderDescription);
                newFolder.update();
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MakeFolder.FolderCreated.fmt.log", (Object)this.folderPath));
                this.returnCode = 0;
            }
        }
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_MAKE_FULL_PATH, RB.getStringResource("MakeFolder.CreateIntermediateFolders.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_DESCRIPTION, true, RB.getStringResource("MakeFolder.Description.txt"));
        option.setArgName(RB.getStringResource("MakeFolder.Description.ArgName.txt"));
        option.setRequired(false);
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        this.setMakeFullPath(this.commandLine.hasOption(OPTION_MAKE_FULL_PATH));
        if (this.commandLine.hasOption(OPTION_DESCRIPTION)) {
            this.setFolderDescription(this.commandLine.getOptionValue(OPTION_DESCRIPTION));
        }
        if ((remainingArgs = this.commandLine.getArgs()).length != 1) {
            this.displayHelp();
            return false;
        }
        this.setFolderPath(remainingArgs[0]);
        return true;
    }

    public static void main(String[] args) {
        MakeFolder make = new MakeFolder();
        make.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("MakeFolder.HelpUsage.txt")});
    }
}

