/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.deleteobjects;

import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.batch.metadata.deleteobjects.ConfigPropertiesInstaller;
import com.sas.batch.metadata.deleteobjects.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class DeleteObjects
extends LocalServicesBatchUtility2 {
    public static final String OPTION_DELETE_CONTENTS = "deleteContents";
    private boolean deleteFolderContents = false;
    private List<String> objectPaths = null;
    private String productID = null;
    private String productKey = null;

    public DeleteObjects() {
        this.utilityName = "sas-delete-objects";
    }

    public DeleteObjects(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public DeleteObjects(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    public static int deleteObject(LocalServicesBatchUtility2 parent, String object, boolean deleteFolderContents) throws Exception {
        DeleteObjects del = new DeleteObjects();
        del.setParent(parent);
        del.setObjects(object);
        del.setDeleteFolderContents(deleteFolderContents);
        int rc = del.execute();
        del.terminate();
        return rc;
    }

    public void setObjects(String objectPath) {
        this.objectPaths = new ArrayList<String>(1);
        this.objectPaths.add(objectPath);
    }

    public void setObjects(List<String> objectPaths) {
        this.objectPaths = objectPaths;
    }

    public void setConfigurationProductID(String prodID) {
        this.productID = prodID;
    }

    public void setConfigurationProductKey(String prodKey) {
        this.productKey = prodKey;
    }

    public boolean isDeleteFolderContents() {
        return this.deleteFolderContents;
    }

    public void setDeleteFolderContents(boolean deleteFolderContents) {
        this.deleteFolderContents = deleteFolderContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        if (this.objectPaths == null && this.productID == null) {
            this.logger.error(RB.getStringResource("DeleteObjects.NoObjectsToDelete.log"));
            return 8;
        }
        try {
            this.initialize();
            if (this.productID != null) {
                this.returnCode |= this.readConfigurationProperties();
            }
            for (PathUrl path : this.sortObjectPaths()) {
                MetadataInterface object;
                String objectPath = path.getAbsolutePath();
                if (path.getType().equals("Folder")) {
                    objectPath = path.getDisplayPath();
                }
                if ((object = this.metadataServer.getObjectByPath(path)) == null) {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteObjects.ObjectDoesNotExist.fmt.log", (Object)objectPath));
                    if (this.returnCode >= 4) continue;
                    this.returnCode = 4;
                    continue;
                }
                this.deleteObject(object);
                if (object.isDeleted()) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteObjects.DeleteSucceeded.fmt.log", (Object)objectPath));
                    continue;
                }
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteObjects.DeleteFailed.fmt.log", (Object)objectPath));
                if (this.returnCode >= 8) continue;
                this.returnCode = 8;
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    private void deleteObject(MetadataInterface object) throws ServiceException {
        try {
            FolderInterface folder;
            String objectPath = object.getPathUrl().getAbsolutePath();
            if (object instanceof FolderInterface && !(folder = (FolderInterface)object).isEmpty()) {
                if (this.deleteFolderContents) {
                    List children = folder.getChildren();
                    for (MetadataInterface child : children) {
                        this.deleteObject(child);
                    }
                } else {
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteObjects.FolderNotEmpty.fmt.log", (Object)objectPath));
                    if (this.returnCode < 4) {
                        this.returnCode = 4;
                    }
                }
                if (!folder.isEmpty()) {
                    return;
                }
            }
            try {
                object.delete();
            }
            catch (ServiceException e) {
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteObjects.DeleteFailed.fmt.log", (Object)objectPath));
                if (this.returnCode < 8) {
                    this.returnCode = 8;
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private int readConfigurationProperties() throws Exception {
        this.objectPaths = new ArrayList<String>();
        ConfigPropertiesInstaller props = new ConfigPropertiesInstaller(this.productID, this.metadataServer, this.logger);
        int rc = props.loadConfigurationProperties(this.objectPaths, this.productKey);
        return rc;
    }

    private List<PathUrl> sortObjectPaths() throws ServiceException, RemoteException {
        ArrayList<PathUrl> sortedPaths = new ArrayList<PathUrl>();
        if (this.objectPaths == null) {
            return sortedPaths;
        }
        for (String objectPath : this.objectPaths) {
            PathUrl path;
            if (objectPath == null || objectPath.length() == 0) continue;
            if (!objectPath.endsWith("/") && !objectPath.endsWith(")")) {
                objectPath = objectPath + "/";
            }
            if ((path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.metadataServer, (String)objectPath)).getType() == null) {
                path.setType("Folder");
            }
            sortedPaths.add(path);
        }
        if (sortedPaths.size() > 1) {
            Collections.sort(sortedPaths, new PathSorter());
        }
        return sortedPaths;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_DELETE_CONTENTS, RB.getStringResource("DeleteObjects.Options.DeleteContents.Desc.txt"));
        commandLineOptions.addOption(option);
        if (!forHelpText) {
            commandLineOptions.addOption(ConfigPropertiesInstaller.getProductIDOption());
            commandLineOptions.addOption(ConfigPropertiesInstaller.getProductKeyOption());
        }
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption("configProductID")) {
            this.productID = this.commandLine.getOptionValue("configProductID");
        }
        if (this.commandLine.hasOption("configProductKey")) {
            this.productKey = this.commandLine.getOptionValue("configProductKey");
        }
        if (this.productID == null) {
            this.setDeleteFolderContents(this.commandLine.hasOption(OPTION_DELETE_CONTENTS));
            List remainingArgs = this.commandLine.getArgList();
            if (remainingArgs.size() == 0) {
                this.displayHelp();
                return false;
            }
            this.setObjects(remainingArgs);
        }
        return true;
    }

    public static void main(String[] args) {
        DeleteObjects utility = new DeleteObjects();
        utility.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("DeleteObjects.HelpUsage.txt")});
    }

    private class PathSorter
    implements Comparator<PathUrl> {
        private PathSorter() {
        }

        @Override
        public int compare(PathUrl path1, PathUrl path2) {
            if (path1 == path2) {
                return 0;
            }
            if (path1 == null) {
                return -1;
            }
            if (path2 == null) {
                return 1;
            }
            return this.runCompare(path1, path2);
        }

        private int runCompare(PathUrl path1, PathUrl path2) {
            int level2;
            if (path1 == null) {
                return 1;
            }
            if (path2 == null) {
                return -1;
            }
            String type1 = path1.getType();
            String type2 = path2.getType();
            if (type1 == null) {
                return -1;
            }
            if (type2 == null) {
                return 1;
            }
            int level1 = this.getLevel(path1.getDisplayPath());
            if (level1 == (level2 = this.getLevel(path2.getDisplayPath()))) {
                boolean matchingTypes = type1.equalsIgnoreCase(type2);
                if (!matchingTypes && "Folder".equalsIgnoreCase(type1)) {
                    return 1;
                }
                if (!matchingTypes && "Folder".equalsIgnoreCase(type2)) {
                    return -1;
                }
                String name1 = path1.getName();
                String name2 = path2.getName();
                if (name1 != null && name2 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 1;
            }
            if (level1 < level2) {
                return 1;
            }
            return -1;
        }

        private int getLevel(String path) {
            int level = 0;
            if (path != null) {
                if (path.endsWith("/") && (path = path.substring(0, path.length() - 1)).equalsIgnoreCase("/")) {
                    return 0;
                }
                int length = path.length();
                for (int i = 0; i < length; ++i) {
                    char c = path.charAt(i);
                    if (c != '/') continue;
                    ++level;
                }
            }
            return level;
        }
    }
}

