/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.access;

import com.sas.batch.metadata.access.AbstractAccessUtility;
import com.sas.batch.metadata.access.RB;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationInfoInterface;
import com.sas.services.information.metadata.AuthorizationUtilInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class ShowMetadataAccess
extends AbstractAccessUtility {
    public static final String OPTION_EFFECTIVE = "effective";
    public static final String OPTION_ONLY_GROUP = "onlyGroup";
    public static final String OPTION_ONLY_USER = "onlyUser";
    private String objectPath;
    private boolean showEffectiveAccess;
    private String userName;
    private String groupName;

    public ShowMetadataAccess() {
        this.utilityName = "sas-show-metadata-access";
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public boolean isShowEffectiveAccess() {
        return this.showEffectiveAccess;
    }

    public void setShowEffectiveAccess(boolean showEffectiveAccess) {
        this.showEffectiveAccess = showEffectiveAccess;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        if (this.objectPath == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        try {
            List matches;
            FilterComponent fc;
            Object filter;
            MetadataInterface object;
            this.initialize();
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.metadataServer, (String)this.objectPath);
            if (path.getType() == null) {
                path.setType("Folder");
            }
            if ((object = this.metadataServer.getObjectByPath(path)) == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.ObjectNotFound.fmt.log", (Object)path.getType(), (Object)path.getDisplayPath()));
            }
            AuthorizationUtilInterface auth = object.getAuthorizationUtil();
            boolean foundSomething = false;
            IdentityInterface showIdentity = null;
            if (this.userName != null) {
                filter = new Filter();
                fc = new FilterComponent("Name", 0, this.userName);
                fc.addComponent(new FilterComponent("PublicType", 0, "User"));
                filter.setFilterComponent(fc);
                matches = this.metadataServer.search((FilterInterface)filter);
                if (matches.isEmpty()) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.UserNotFound.fmt.log", (Object)this.userName));
                }
                showIdentity = (IdentityInterface)matches.get(0);
            } else if (this.groupName != null) {
                filter = new Filter();
                fc = new FilterComponent("Name", 0, this.groupName);
                fc.addComponent(new FilterComponent("PublicType", 0, "UserGroup"));
                filter.setFilterComponent(fc);
                matches = this.metadataServer.search((FilterInterface)filter);
                if (matches.isEmpty()) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.GroupNotFound.fmt.log", (Object)this.groupName));
                }
                showIdentity = (IdentityGroupInterface)matches.get(0);
            }
            if (showIdentity != null) {
                foundSomething = this.printAuthorizationInfo(auth.getAuthorizations(showIdentity, null), this.showEffectiveAccess);
            } else {
                if (!this.showEffectiveAccess) {
                    for (AccessControlTemplateInterface act : auth.getACTs()) {
                        System.out.println("  -addACT " + this.quotedACTName(act));
                        foundSomething = true;
                    }
                }
                List auths = auth.getAuthorizationsAll();
                for (AuthorizationInfoInterface info : auths) {
                    foundSomething |= this.printAuthorizationInfo(info, this.showEffectiveAccess);
                }
            }
            if (!foundSomething) {
                if (this.showEffectiveAccess) {
                    System.out.println(RB.getStringResource("ShowMetadataAccess.NoControls.log"));
                } else {
                    System.out.println(RB.getStringResource("ShowMetadataAccess.NoExplicitControls.log"));
                }
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_EFFECTIVE, RB.getStringResource("ShowMetadataAccess.Effective.Desc.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_ONLY_GROUP, true, RB.getStringResource("ShowMetadataAccess.OnlyGroup.Desc.txt"));
        option.setArgName(RB.getStringResource("ShowMetadataAccess.OnlyGroup.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_ONLY_USER, true, RB.getStringResource("ShowMetadataAccess.OnlyUser.Desc.txt"));
        option.setArgName(RB.getStringResource("ShowMetadataAccess.OnlyUser.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        this.setShowEffectiveAccess(this.commandLine.hasOption(OPTION_EFFECTIVE));
        this.userName = null;
        this.groupName = null;
        if (this.commandLine.hasOption(OPTION_ONLY_GROUP)) {
            this.setGroupName(this.commandLine.getOptionValue(OPTION_ONLY_GROUP));
        }
        if (this.commandLine.hasOption(OPTION_ONLY_USER)) {
            this.setUserName(this.commandLine.getOptionValue(OPTION_ONLY_USER));
        }
        if ((remainingArgs = this.commandLine.getArgs()).length == 0) {
            throw new ParseException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        if (remainingArgs.length > 1) {
            throw new ParseException(RB.getStringResource("Common.TooManyObjectsSpecified.log"));
        }
        this.setObjectPath(remainingArgs[0]);
        return true;
    }

    public static void main(String[] args) {
        ShowMetadataAccess utility = new ShowMetadataAccess();
        utility.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("ShowMetadataAccess.HelpUsage.txt")});
    }
}

