/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.access;

import com.sas.batch.metadata.access.AbstractAccessUtility;
import com.sas.batch.metadata.access.RB;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationBaseInterface;
import com.sas.services.information.metadata.AuthorizationInfoInterface;
import com.sas.services.information.metadata.AuthorizationUtilInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PermissionInfo;
import com.sas.services.information.metadata.PermissionInfoInterface;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class SetMetadataAccess
extends AbstractAccessUtility {
    public static final String OPTION_ADD_ACT = "addACT";
    public static final String OPTION_CONDITION = "condition";
    public static final String OPTION_DENY = "deny";
    public static final String OPTION_GRANT = "grant";
    public static final String OPTION_REMOVE = "remove";
    public static final String OPTION_REMOVE_ACT = "removeACT";
    public static final String OPTION_REMOVE_ALL = "removeAll";
    private String objectPath;
    private boolean removeAll = false;
    private List<String> addACTs;
    private List<String> removeACTs;
    private List<AbstractAccessUtility.AccessControl> aces;

    public SetMetadataAccess() {
        this.utilityName = "sas-set-metadata-access";
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public void setRemoveAll(boolean removeAll) {
        this.removeAll = removeAll;
    }

    public List<String> getAddACTs() {
        if (this.addACTs == null) {
            this.addACTs = new ArrayList<String>();
        }
        return this.addACTs;
    }

    public void setAddACTs(List<String> addACTs) {
        this.addACTs = addACTs;
    }

    public List<String> getRemoveACTs() {
        if (this.removeACTs == null) {
            this.removeACTs = new ArrayList<String>();
        }
        return this.removeACTs;
    }

    public void setRemoveACTs(List<String> removeACTs) {
        this.removeACTs = removeACTs;
    }

    public List<AbstractAccessUtility.AccessControl> getACEs() {
        if (this.aces == null) {
            this.aces = new ArrayList<AbstractAccessUtility.AccessControl>();
        }
        return this.aces;
    }

    public void setACEs(List<AbstractAccessUtility.AccessControl> aces) {
        this.aces = aces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        if (this.objectPath == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        if (!this.removeAll && this.getAddACTs().isEmpty() && this.getRemoveACTs().isEmpty() && this.getACEs().isEmpty()) {
            throw new IllegalArgumentException(RB.getStringResource("Common.NoActionSpecified.log"));
        }
        try {
            MetadataInterface object;
            this.initialize();
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this.metadataServer, (String)this.objectPath);
            if (path.getType() == null) {
                path.setType("Folder");
            }
            if ((object = this.metadataServer.getObjectByPath(path)) == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"Common.ObjectNotFound.fmt.log", (Object)path.getType(), (Object)path.getDisplayPath()));
            }
            AuthorizationUtilInterface auth = object.getAuthorizationUtil();
            if (this.removeAll) {
                for (AccessControlTemplateInterface act : auth.getACTs()) {
                    auth.removeACT(act);
                }
                for (AuthorizationInfoInterface authInfo : auth.getAuthorizationsAll()) {
                    ArrayList<PermissionInfo> newPerms = new ArrayList<PermissionInfo>(authInfo.getPermissionInfoList().size());
                    for (PermissionInfoInterface oldPerm : authInfo.getPermissionInfoList()) {
                        if (oldPerm.getPermissionSource() != PermissionInfoInterface.PermissionSource.EXPLICIT) continue;
                        newPerms.add(new PermissionInfo(PermissionInfoInterface.PermissionType.REMOVE, oldPerm.getPermission()));
                    }
                    if (newPerms.isEmpty()) continue;
                    auth.setAuthorizations(authInfo.getIdentityInfo().getIdentity(), newPerms);
                }
            }
            for (String actName : this.getAddACTs()) {
                auth.applyACT(this.getACTByName(actName, true));
            }
            for (String actName : this.getRemoveACTs()) {
                auth.removeACT(this.getACTByName(actName, true));
            }
            ArrayList<AuthorizationInfoInterface> newAuths = new ArrayList<AuthorizationInfoInterface>(10);
            for (AbstractAccessUtility.AccessControl ace : this.getACEs()) {
                newAuths.add(this.makeAuthInfo(ace, (AuthorizationBaseInterface)auth));
            }
            if (!newAuths.isEmpty()) {
                auth.setAuthorizations(newAuths);
            }
            auth.commit();
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_ADD_ACT, true, RB.getStringResource("Common.AddACT.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.AddACT.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REMOVE_ACT, true, RB.getStringResource("Common.RemoveACT.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.RemoveACT.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_GRANT, true, RB.getStringResource("Common.Grant.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Grant.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_CONDITION, true, RB.getStringResource("Common.Condition.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Condition.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_DENY, true, RB.getStringResource("Common.Deny.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Deny.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REMOVE, true, RB.getStringResource("Common.Remove.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Remove.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REMOVE_ALL, RB.getStringResource("Common.RemoveAll.Desc.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        this.setRemoveAll(this.commandLine.hasOption(OPTION_REMOVE_ALL));
        this.addACTs = null;
        this.removeACTs = null;
        this.aces = null;
        AbstractAccessUtility.AccessControl previousGrant = null;
        for (Option option : this.commandLine.getOptions()) {
            String optionName = option.getOpt();
            if (optionName.equals(OPTION_CONDITION)) {
                if (previousGrant == null) {
                    throw new ParseException(RB.getStringResource("Common.ConditionMustFollowGrant.log"));
                }
                previousGrant.setCondition(option.getValue());
                continue;
            }
            previousGrant = null;
            if (optionName.equals(OPTION_ADD_ACT)) {
                this.getAddACTs().add(option.getValue());
                continue;
            }
            if (optionName.equals(OPTION_REMOVE_ACT)) {
                this.getRemoveACTs().add(option.getValue());
                continue;
            }
            if (optionName.equals(OPTION_GRANT)) {
                previousGrant = new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.GRANT, option.getValue());
                this.getACEs().add(previousGrant);
                continue;
            }
            if (optionName.equals(OPTION_DENY)) {
                this.getACEs().add(new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.DENY, option.getValue()));
                continue;
            }
            if (!optionName.equals(OPTION_REMOVE)) continue;
            this.getACEs().add(new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.REMOVE, option.getValue()));
        }
        String[] remainingArgs = this.commandLine.getArgs();
        if (remainingArgs.length == 0) {
            throw new ParseException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        if (remainingArgs.length > 1) {
            throw new ParseException(RB.getStringResource("Common.TooManyObjectsSpecified.log"));
        }
        this.setObjectPath(remainingArgs[0]);
        return true;
    }

    public static void main(String[] args) {
        SetMetadataAccess utility = new SetMetadataAccess();
        utility.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("SetMetadataAccess.HelpUsage.txt")});
    }
}

