/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.access;

import com.sas.batch.metadata.access.AbstractAccessUtility;
import com.sas.batch.metadata.access.RB;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.AuthorizationBaseInterface;
import com.sas.services.information.metadata.AuthorizationInfoInterface;
import com.sas.services.information.metadata.PermissionInfo;
import com.sas.services.information.metadata.PermissionInfoInterface;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class MakeACT
extends AbstractAccessUtility {
    public static final String OPTION_CREATE = "create";
    public static final String OPTION_DENY = "deny";
    public static final String OPTION_GRANT = "grant";
    public static final String OPTION_REMOVE = "remove";
    public static final String OPTION_SHOW = "show";
    public static final String OPTION_REMOVE_ALL = "removeAll";
    public static final String OPTION_UPDATE = "update";
    public static final String OPTION_DESCRIPTION = "desc";
    private String templateName;
    private String actDescription = null;
    private boolean createMode = false;
    private boolean showMode = false;
    private boolean updateMode = false;
    private boolean removeAll = false;
    private List<AbstractAccessUtility.AccessControl> aces;

    public MakeACT() {
        this.utilityName = "sas-make-act";
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setACTDescription(String actDescription) {
        this.actDescription = actDescription;
    }

    public boolean isCreateMode() {
        return this.createMode;
    }

    public void setCreateMode(boolean createMode) {
        this.createMode = createMode;
    }

    public boolean isShowMode() {
        return this.showMode;
    }

    public void setShowMode(boolean showMode) {
        this.showMode = showMode;
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(boolean updateMode) {
        this.updateMode = updateMode;
    }

    public boolean isRemoveAll() {
        return this.removeAll;
    }

    public void setRemoveAll(boolean removeAll) {
        this.removeAll = removeAll;
    }

    public List<AbstractAccessUtility.AccessControl> getACEs() {
        if (this.aces == null) {
            this.aces = new ArrayList<AbstractAccessUtility.AccessControl>();
        }
        return this.aces;
    }

    public void setACEs(List<AbstractAccessUtility.AccessControl> aces) {
        this.aces = aces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        if (this.templateName == null) {
            throw new IllegalArgumentException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        if (!this.showMode && !this.removeAll && this.getACEs().isEmpty()) {
            throw new IllegalArgumentException(RB.getStringResource("Common.NoActionSpecified.log"));
        }
        try {
            this.initialize();
            AccessControlTemplateInterface act = this.getACTByName(this.templateName, this.updateMode || this.showMode);
            if (act != null && this.createMode) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"MakeACT.TemplateAlreadyExists.fmt.log", (Object)this.templateName));
            }
            if (act == null) {
                act = this.makeACT(this.templateName);
                act.setDescription(this.actDescription);
                act.update();
            }
            AuthorizationBaseInterface auth = act.getAuthorizationDefinitionUtil();
            if (this.showMode) {
                boolean foundSomething = false;
                List auths = auth.getAuthorizationsAll();
                for (AuthorizationInfoInterface info : auths) {
                    foundSomething |= this.printAuthorizationInfo(info);
                }
                if (!foundSomething) {
                    System.out.println(RB.getStringResource("MakeACT.NoAccessControls.log"));
                }
            } else {
                if (this.removeAll) {
                    for (AuthorizationInfoInterface authInfo : auth.getAuthorizationsAll()) {
                        ArrayList<PermissionInfo> newPerms = new ArrayList<PermissionInfo>(authInfo.getPermissionInfoList().size());
                        for (PermissionInfoInterface oldPerm : authInfo.getPermissionInfoList()) {
                            if (oldPerm.getPermissionSource() != PermissionInfoInterface.PermissionSource.EXPLICIT) continue;
                            newPerms.add(new PermissionInfo(PermissionInfoInterface.PermissionType.REMOVE, oldPerm.getPermission()));
                        }
                        if (newPerms.isEmpty()) continue;
                        auth.setAuthorizations(authInfo.getIdentityInfo().getIdentity(), newPerms);
                    }
                }
                ArrayList<AuthorizationInfoInterface> newAuths = new ArrayList<AuthorizationInfoInterface>(10);
                for (AbstractAccessUtility.AccessControl ace : this.getACEs()) {
                    newAuths.add(this.makeAuthInfo(ace, auth));
                }
                if (!newAuths.isEmpty()) {
                    auth.setAuthorizations(newAuths);
                }
                auth.commit();
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        OptionGroup modeGroup = new OptionGroup();
        Option option = new Option(OPTION_CREATE, RB.getStringResource("MakeACT.Create.Desc.txt"));
        modeGroup.addOption(option);
        option = new Option(OPTION_SHOW, RB.getStringResource("MakeACT.Show.Desc.txt"));
        modeGroup.addOption(option);
        option = new Option(OPTION_UPDATE, RB.getStringResource("MakeACT.Update.Desc.txt"));
        modeGroup.addOption(option);
        commandLineOptions.addOptionGroup(modeGroup);
        option = new Option(OPTION_GRANT, true, RB.getStringResource("Common.Grant.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Grant.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_DENY, true, RB.getStringResource("Common.Deny.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Deny.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REMOVE, true, RB.getStringResource("Common.Remove.Desc.txt"));
        option.setArgName(RB.getStringResource("Common.Remove.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_REMOVE_ALL, RB.getStringResource("MakeACT.RemoveAll.Desc.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_DESCRIPTION, true, RB.getStringResource("MakeACT.Description.txt"));
        option.setArgName(RB.getStringResource("MakeACT.Description.ArgName.txt"));
        option.setRequired(false);
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        this.setCreateMode(this.commandLine.hasOption(OPTION_CREATE));
        this.setShowMode(this.commandLine.hasOption(OPTION_SHOW));
        this.setUpdateMode(this.commandLine.hasOption(OPTION_UPDATE));
        this.setRemoveAll(this.commandLine.hasOption(OPTION_REMOVE_ALL));
        if (this.commandLine.hasOption(OPTION_DESCRIPTION)) {
            this.setACTDescription(this.commandLine.getOptionValue(OPTION_DESCRIPTION));
        }
        this.aces = null;
        for (Option option : this.commandLine.getOptions()) {
            String optionName = option.getOpt();
            if (optionName.equals(OPTION_GRANT)) {
                this.getACEs().add(new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.GRANT, option.getValue()));
                continue;
            }
            if (optionName.equals(OPTION_DENY)) {
                this.getACEs().add(new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.DENY, option.getValue()));
                continue;
            }
            if (!optionName.equals(OPTION_REMOVE)) continue;
            this.getACEs().add(new AbstractAccessUtility.AccessControl(PermissionInfoInterface.PermissionType.REMOVE, option.getValue()));
        }
        String[] remainingArgs = this.commandLine.getArgs();
        if (remainingArgs.length == 0) {
            throw new ParseException(RB.getStringResource("Common.NoObjectSpecified.log"));
        }
        if (remainingArgs.length > 1) {
            throw new ParseException(RB.getStringResource("Common.TooManyObjectsSpecified.log"));
        }
        this.setTemplateName(remainingArgs[0]);
        return true;
    }

    public static void main(String[] args) {
        MakeACT utility = new MakeACT();
        utility.executeBatch(args);
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("MakeACT.HelpUsage1.txt"), RB.getStringResource("MakeACT.HelpUsage2.txt")});
    }
}

